/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source.snapshot.incremental;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.engine.DebeziumEngine;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenConnectorUnderTest;
import io.debezium.junit.SkipWhenConnectorsUnderTest;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.pipeline.source.snapshot.incremental.AbstractIncrementalSnapshotChangeEventSource;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.awaitility.Awaitility;
import org.fest.assertions.Assertions;
import org.fest.assertions.IntAssert;
import org.fest.assertions.MapAssert;
import org.junit.Test;

public abstract class AbstractIncrementalSnapshotTest<T extends SourceConnector>
extends AbstractConnectorTest {
    protected static final int ROW_COUNT = 1000;
    private static final int MAXIMUM_NO_RECORDS_CONSUMES = 3;
    protected static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-is.txt").toAbsolutePath();

    protected abstract Class<T> connectorClass();

    protected abstract JdbcConnection databaseConnection();

    protected abstract String topicName();

    protected abstract String tableName();

    protected abstract List<String> topicNames();

    protected abstract List<String> tableNames();

    protected abstract String signalTableName();

    protected String signalTableNameSanitized() {
        return this.signalTableName();
    }

    protected abstract Configuration.Builder config();

    protected abstract Configuration.Builder mutableConfig(boolean var1, boolean var2);

    protected String alterTableAddColumnStatement(String tableName) {
        return "ALTER TABLE " + tableName + " add col3 int default 0";
    }

    protected String alterTableDropColumnStatement(String tableName) {
        return "ALTER TABLE " + tableName + " drop column col3";
    }

    protected String tableDataCollectionId() {
        return this.tableName();
    }

    protected List<String> tableDataCollectionIds() {
        return this.tableNames();
    }

    protected void populateTable(JdbcConnection connection, String tableName) throws SQLException {
        connection.setAutoCommit(false);
        for (int i = 0; i < 1000; ++i) {
            connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO %s (%s, aa) VALUES (%s, %s)", tableName, connection.quotedColumnIdString(this.pkFieldName()), i + 1, i)});
        }
        connection.commit();
    }

    protected void populateTable(JdbcConnection connection) throws SQLException {
        this.populateTable(connection, this.tableName());
    }

    protected void populateTables(JdbcConnection connection) throws SQLException {
        for (String tableName : this.tableNames()) {
            this.populateTable(connection, tableName);
        }
    }

    protected void populateTable() throws SQLException {
        try (JdbcConnection connection = this.databaseConnection();){
            this.populateTable(connection);
        }
    }

    protected void populateTables() throws SQLException {
        try (JdbcConnection connection = this.databaseConnection();){
            this.populateTables(connection);
        }
    }

    protected void populate4PkTable(JdbcConnection connection, String tableName) throws SQLException {
        connection.setAutoCommit(false);
        for (int i = 0; i < 1000; ++i) {
            int id = i + 1;
            int pk1 = id / 1000;
            int pk2 = id / 100 % 10;
            int pk3 = id / 10 % 10;
            int pk4 = id % 10;
            connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO %s (pk1, pk2, pk3, pk4, aa) VALUES (%s, %s, %s, %s, %s)", tableName, pk1, pk2, pk3, pk4, i)});
        }
        connection.commit();
    }

    protected Map<Integer, Integer> consumeMixedWithIncrementalSnapshot(int recordCount) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, this.topicName());
    }

    protected Map<Integer, Integer> consumeMixedWithIncrementalSnapshot(int recordCount, String topicName) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, record -> ((Struct)record.value()).getStruct("after").getInt32(this.valueFieldName()), x -> true, null, topicName);
    }

    protected <V> Map<Integer, V> consumeMixedWithIncrementalSnapshot(int recordCount, Function<SourceRecord, V> valueConverter, Predicate<Map.Entry<Integer, V>> dataCompleted, Consumer<List<SourceRecord>> recordConsumer, String topicName) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, dataCompleted, k -> k.getInt32(this.pkFieldName()), valueConverter, topicName, recordConsumer);
    }

    protected <V> Map<Integer, V> consumeMixedWithIncrementalSnapshot(int recordCount, Predicate<Map.Entry<Integer, V>> dataCompleted, Function<Struct, Integer> idCalculator, Function<SourceRecord, V> valueConverter, String topicName, Consumer<List<SourceRecord>> recordConsumer) throws InterruptedException {
        HashMap dbChanges = new HashMap();
        int noRecords = 0;
        while (true) {
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List<SourceRecord> dataRecords = records.recordsForTopic(topicName);
            if (records.allRecordsInOrder().isEmpty()) {
                ((IntAssert)Assertions.assertThat((int)(++noRecords)).describedAs(String.format("Too many no data record results, %d < %d", dbChanges.size(), recordCount))).isLessThanOrEqualTo(3);
                continue;
            }
            noRecords = 0;
            if (dataRecords == null || dataRecords.isEmpty()) continue;
            dataRecords.forEach(record -> {
                int id = (Integer)idCalculator.apply((Struct)record.key());
                Object value = valueConverter.apply((SourceRecord)record);
                dbChanges.put(id, value);
            });
            if (recordConsumer != null) {
                recordConsumer.accept(dataRecords);
            }
            if (dbChanges.size() >= recordCount && !dbChanges.entrySet().stream().anyMatch(dataCompleted.negate())) break;
        }
        Assertions.assertThat(dbChanges).hasSize(recordCount);
        return dbChanges;
    }

    protected Map<Integer, SourceRecord> consumeRecordsMixedWithIncrementalSnapshot(int recordCount) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, Function.identity(), x -> true, null, this.topicName());
    }

    protected Map<Integer, Integer> consumeMixedWithIncrementalSnapshot(int recordCount, Predicate<Map.Entry<Integer, Integer>> dataCompleted, Consumer<List<SourceRecord>> recordConsumer) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, record -> ((Struct)record.value()).getStruct("after").getInt32(this.valueFieldName()), dataCompleted, recordConsumer, this.topicName());
    }

    protected Map<Integer, SourceRecord> consumeRecordsMixedWithIncrementalSnapshot(int recordCount, Predicate<Map.Entry<Integer, SourceRecord>> dataCompleted, Consumer<List<SourceRecord>> recordConsumer) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, Function.identity(), dataCompleted, recordConsumer, this.topicName());
    }

    protected String valueFieldName() {
        return "aa";
    }

    protected String pkFieldName() {
        return "pk";
    }

    protected String getSignalTypeFieldName() {
        return "type";
    }

    protected void sendAdHocSnapshotSignal(String ... dataCollectionIds) throws SQLException {
        String dataCollectionIdsList = Arrays.stream(dataCollectionIds).map(x -> "\"" + x + "\"").collect(Collectors.joining(", "));
        try (JdbcConnection connection = this.databaseConnection();){
            String query = String.format("INSERT INTO %s VALUES('ad-hoc', 'execute-snapshot', '{\"data-collections\": [%s]}')", this.signalTableName(), dataCollectionIdsList);
            this.logger.info("Sending signal with query {}", (Object)query);
            connection.execute(new String[]{query});
        }
        catch (Exception e) {
            this.logger.warn("Failed to send signal", (Throwable)e);
        }
    }

    protected void sendAdHocSnapshotStopSignal(String ... dataCollectionIds) throws SQLException {
        Object collections = "";
        if (dataCollectionIds.length > 0) {
            String dataCollectionIdsList = Arrays.stream(dataCollectionIds).map(x -> "\"" + x + "\"").collect(Collectors.joining(", "));
            collections = ",\"data-collections\": [" + dataCollectionIdsList + "]";
        }
        try (JdbcConnection connection = this.databaseConnection();){
            String query = String.format("INSERT INTO %s VALUES('ad-hoc', 'stop-snapshot', '{\"type\": \"INCREMENTAL\"" + (String)collections + "}')", this.signalTableName());
            this.logger.info("Sending signal with query {}", (Object)query);
            connection.execute(new String[]{query});
        }
        catch (Exception e) {
            this.logger.warn("Failed to send signal", (Throwable)e);
        }
    }

    protected void sendAdHocSnapshotSignal() throws SQLException {
        this.sendAdHocSnapshotSignal(this.tableDataCollectionId());
    }

    protected void startConnector(DebeziumEngine.CompletionCallback callback) {
        this.startConnector(Function.identity(), callback, true);
    }

    protected void startConnector(Function<Configuration.Builder, Configuration.Builder> custConfig) {
        this.startConnector(custConfig, (DebeziumEngine.CompletionCallback)this.loggingCompletion(), true);
    }

    protected void startConnector(Function<Configuration.Builder, Configuration.Builder> custConfig, DebeziumEngine.CompletionCallback callback, boolean expectNoRecords) {
        Configuration config = custConfig.apply(this.config()).build();
        this.start(this.connectorClass(), config, callback);
        this.waitForConnectorToStart();
        this.waitForAvailableRecords(5L, TimeUnit.SECONDS);
        if (expectNoRecords) {
            this.assertNoRecordsToConsume();
        }
    }

    protected void startConnectorWithSnapshot(Function<Configuration.Builder, Configuration.Builder> custConfig) {
        this.startConnector(custConfig, (DebeziumEngine.CompletionCallback)this.loggingCompletion(), false);
    }

    protected void startConnector() {
        this.startConnector(Function.identity(), (DebeziumEngine.CompletionCallback)this.loggingCompletion(), true);
    }

    protected void waitForConnectorToStart() {
        this.assertConnectorIsRunning();
    }

    @Test
    public void snapshotOnly() throws Exception {
        this.populateTable();
        this.startConnector();
        this.sendAdHocSnapshotSignal();
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    public void invalidTablesInTheList() throws Exception {
        this.populateTable();
        this.startConnector();
        this.sendAdHocSnapshotSignal("invalid1", this.tableDataCollectionId(), "invalid2");
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    public void inserts() throws Exception {
        this.populateTable();
        this.startConnector();
        this.sendAdHocSnapshotSignal();
        try (JdbcConnection connection = this.databaseConnection();){
            connection.setAutoCommit(false);
            for (int i = 0; i < 1000; ++i) {
                connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO %s (%s, aa) VALUES (%s, %s)", this.tableName(), connection.quotedColumnIdString(this.pkFieldName()), i + 1000 + 1, i + 1000)});
            }
            connection.commit();
        }
        int expectedRecordCount = 2000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(2000);
        for (int i = 0; i < 2000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    public void updates() throws Exception {
        this.populateTable();
        this.startConnector();
        this.sendAdHocSnapshotSignal();
        int batchSize = 10;
        try (JdbcConnection connection = this.databaseConnection();){
            connection.setAutoCommit(false);
            for (int i = 0; i < 1000; ++i) {
                connection.executeWithoutCommitting(new String[]{String.format("UPDATE %s SET aa = aa + 2000 WHERE %s > %s AND %s <= %s", this.tableName(), connection.quotedColumnIdString(this.pkFieldName()), i * 10, connection.quotedColumnIdString(this.pkFieldName()), (i + 1) * 10)});
                connection.commit();
            }
        }
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000, x -> (Integer)x.getValue() >= 2000, null);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)(i + 2000))});
        }
    }

    @Test
    public void updatesWithRestart() throws Exception {
        this.populateTable();
        Configuration config = this.config().build();
        this.startAndConsumeTillEnd(this.connectorClass(), config);
        this.waitForConnectorToStart();
        this.waitForAvailableRecords(1L, TimeUnit.SECONDS);
        this.assertNoRecordsToConsume();
        this.sendAdHocSnapshotSignal();
        int batchSize = 10;
        try (JdbcConnection connection = this.databaseConnection();){
            connection.setAutoCommit(false);
            for (int i = 0; i < 1000; ++i) {
                connection.executeWithoutCommitting(new String[]{String.format("UPDATE %s SET aa = aa + 2000 WHERE %s > %s AND %s <= %s", this.tableName(), connection.quotedColumnIdString(this.pkFieldName()), i * 10, connection.quotedColumnIdString(this.pkFieldName()), (i + 1) * 10)});
                connection.commit();
            }
        }
        int expectedRecordCount = 1000;
        AtomicInteger recordCounter = new AtomicInteger();
        AtomicBoolean restarted = new AtomicBoolean();
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000, x -> (Integer)x.getValue() >= 2000, x -> {
            if (recordCounter.addAndGet(x.size()) > 50 && !restarted.get()) {
                this.stopConnector();
                this.assertConnectorNotRunning();
                this.start(this.connectorClass(), config);
                this.waitForConnectorToStart();
                restarted.set(true);
            }
        });
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)(i + 2000))});
        }
    }

    @Test
    public void updatesLargeChunk() throws Exception {
        this.populateTable();
        this.startConnector((Configuration.Builder x) -> (Configuration.Builder)x.with(CommonConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 1000));
        this.sendAdHocSnapshotSignal();
        try (JdbcConnection connection = this.databaseConnection();){
            connection.execute(new String[]{String.format("UPDATE %s SET aa = aa + 2000", this.tableName())});
        }
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000, x -> (Integer)x.getValue() >= 2000, null);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)(i + 2000))});
        }
    }

    @Test
    public void snapshotOnlyWithRestart() throws Exception {
        this.populateTable();
        Configuration config = this.config().build();
        this.startAndConsumeTillEnd(this.connectorClass(), config);
        this.waitForConnectorToStart();
        this.waitForAvailableRecords(1L, TimeUnit.SECONDS);
        this.assertNoRecordsToConsume();
        this.sendAdHocSnapshotSignal();
        int expectedRecordCount = 1000;
        AtomicInteger recordCounter = new AtomicInteger();
        AtomicBoolean restarted = new AtomicBoolean();
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000, x -> true, x -> {
            if (recordCounter.addAndGet(x.size()) > 50 && !restarted.get()) {
                this.stopConnector();
                this.assertConnectorNotRunning();
                this.start(this.connectorClass(), config);
                this.waitForConnectorToStart();
                restarted.set(true);
            }
        });
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    @SkipWhenConnectorsUnderTest(value={@SkipWhenConnectorUnderTest(check=EqualityCheck.EQUAL, value=SkipWhenConnectorUnderTest.Connector.SQL_SERVER), @SkipWhenConnectorUnderTest(check=EqualityCheck.EQUAL, value=SkipWhenConnectorUnderTest.Connector.DB2)})
    @FixFor(value={"DBZ-4272"})
    public void snapshotPreceededBySchemaChange() throws Exception {
        this.populateTable();
        this.startConnector();
        this.waitForConnectorToStart();
        try (JdbcConnection connection = this.databaseConnection();){
            connection.execute(new String[]{this.alterTableAddColumnStatement(this.tableName())});
        }
        this.sendAdHocSnapshotSignal();
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
        try (JdbcConnection connection = this.databaseConnection();){
            connection.execute(new String[]{this.alterTableDropColumnStatement(this.tableName())});
        }
        this.sendAdHocSnapshotSignal();
        dbChanges = this.consumeMixedWithIncrementalSnapshot(1000);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    public void snapshotWithRegexDataCollections() throws Exception {
        this.populateTable();
        this.startConnector();
        this.sendAdHocSnapshotSignal(".*");
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    @FixFor(value={"DBZ-4271"})
    public void stopCurrentIncrementalSnapshotWithoutCollectionsAndTakeNewNewIncrementalSnapshotAfterRestart() throws Exception {
        LogInterceptor interceptor = new LogInterceptor(AbstractIncrementalSnapshotChangeEventSource.class);
        this.populateTable();
        this.startConnector((Configuration.Builder x) -> (Configuration.Builder)x.with(CommonConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 1));
        this.sendAdHocSnapshotSignalAndWait(new String[0]);
        this.sendAdHocSnapshotStopSignalAndWait(new String[0]);
        Assertions.assertThat((boolean)this.consumeAnyRemainingIncrementalSnapshotEventsAndCheckForStopMessage(interceptor, "Stopping incremental snapshot")).isTrue();
        this.stopConnector(r -> interceptor.clear());
        this.startConnector();
        Assertions.assertThat((boolean)interceptor.containsMessage("No incremental snapshot in progress")).isTrue();
        this.sendAdHocSnapshotSignal();
        try (JdbcConnection connection = this.databaseConnection();){
            connection.setAutoCommit(false);
            for (int i = 0; i < 1000; ++i) {
                connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO %s (%s, aa) VALUES (%s, %s)", this.tableName(), connection.quotedColumnIdString(this.pkFieldName()), i + 1000 + 1, i + 1000)});
            }
            connection.commit();
        }
        int expectedRecordCount = 2000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(2000);
        for (int i = 0; i < 2000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    @FixFor(value={"DBZ-4271"})
    public void stopCurrentIncrementalSnapshotWithAllCollectionsAndTakeNewNewIncrementalSnapshotAfterRestart() throws Exception {
        LogInterceptor interceptor = new LogInterceptor(AbstractIncrementalSnapshotChangeEventSource.class);
        this.populateTable();
        this.startConnector((Configuration.Builder x) -> (Configuration.Builder)x.with(CommonConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 1));
        this.sendAdHocSnapshotSignalAndWait(new String[0]);
        this.sendAdHocSnapshotStopSignalAndWait(this.tableDataCollectionId());
        Assertions.assertThat((boolean)this.consumeAnyRemainingIncrementalSnapshotEventsAndCheckForStopMessage(interceptor, "Removing '[" + this.tableDataCollectionId() + "]' collections from incremental snapshot")).isTrue();
        this.stopConnector(r -> interceptor.clear());
        this.startConnector();
        Assertions.assertThat((boolean)interceptor.containsMessage("No incremental snapshot in progress")).isTrue();
        this.sendAdHocSnapshotSignal();
        try (JdbcConnection connection = this.databaseConnection();){
            connection.setAutoCommit(false);
            for (int i = 0; i < 1000; ++i) {
                connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO %s (%s, aa) VALUES (%s, %s)", this.tableName(), connection.quotedColumnIdString(this.pkFieldName()), i + 1000 + 1, i + 1000)});
            }
            connection.commit();
        }
        int expectedRecordCount = 2000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(2000);
        for (int i = 0; i < 2000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    @FixFor(value={"DBZ-4271"})
    public void removeNotYetCapturedCollectionFromInProgressIncrementalSnapshot() throws Exception {
        LogInterceptor interceptor = new LogInterceptor(AbstractIncrementalSnapshotChangeEventSource.class);
        this.populateTables();
        this.startConnector((Configuration.Builder x) -> (Configuration.Builder)x.with(CommonConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 250));
        List<String> collectionIds = this.tableDataCollectionIds();
        Assertions.assertThat(collectionIds).hasSize(2);
        List<String> tableNames = this.tableNames();
        Assertions.assertThat(tableNames).hasSize(2);
        List<String> topicNames = this.topicNames();
        Assertions.assertThat(topicNames).hasSize(2);
        String collectionIdToRemove = collectionIds.get(1);
        String tableToSnapshot = tableNames.get(0);
        String topicToConsume = topicNames.get(0);
        this.sendAdHocSnapshotSignal(collectionIds.toArray(new String[0]));
        this.sendAdHocSnapshotStopSignal(collectionIdToRemove);
        Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> interceptor.containsMessage("Removing '[" + collectionIdToRemove + "]' collections from incremental snapshot"));
        try (JdbcConnection connection = this.databaseConnection();){
            connection.setAutoCommit(false);
            for (int i = 0; i < 1000; ++i) {
                connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO %s (%s, aa) VALUES (%s, %s)", tableToSnapshot, connection.quotedColumnIdString(this.pkFieldName()), i + 1000 + 1, i + 1000)});
            }
            connection.commit();
        }
        int expectedRecordCount = 2000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(2000, topicToConsume);
        for (int i = 0; i < 2000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    @FixFor(value={"DBZ-4271"})
    public void removeStartedCapturedCollectionFromInProgressIncrementalSnapshot() throws Exception {
        LogInterceptor interceptor = new LogInterceptor(AbstractIncrementalSnapshotChangeEventSource.class);
        this.populateTables();
        this.startConnector((Configuration.Builder x) -> (Configuration.Builder)x.with(CommonConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 250));
        List<String> collectionIds = this.tableDataCollectionIds();
        Assertions.assertThat(collectionIds).hasSize(2);
        List<String> tableNames = this.tableNames();
        Assertions.assertThat(tableNames).hasSize(2);
        List<String> topicNames = this.topicNames();
        Assertions.assertThat(topicNames).hasSize(2);
        String collectionIdToRemove = collectionIds.get(0);
        String tableToSnapshot = tableNames.get(1);
        String topicToConsume = topicNames.get(1);
        this.sendAdHocSnapshotSignal(collectionIds.toArray(new String[0]));
        this.sendAdHocSnapshotStopSignal(collectionIdToRemove);
        Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> interceptor.containsMessage("Removing '[" + collectionIdToRemove + "]' collections from incremental snapshot"));
        try (JdbcConnection connection = this.databaseConnection();){
            connection.setAutoCommit(false);
            for (int i = 0; i < 1000; ++i) {
                connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO %s (%s, aa) VALUES (%s, %s)", tableToSnapshot, connection.quotedColumnIdString(this.pkFieldName()), i + 1000 + 1, i + 1000)});
            }
            connection.commit();
        }
        int expectedRecordCount = 2000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(2000, topicToConsume);
        for (int i = 0; i < 2000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    @FixFor(value={"DBZ-4834"})
    public void shouldSnapshotNewlyAddedTableToIncludeListAfterRestart() throws Exception {
        this.populateTables();
        this.startConnectorWithSnapshot(x -> this.mutableConfig(true, false));
        this.waitForConnectorToStart();
        AbstractConnectorTest.SourceRecords snapshotRecords = this.consumeRecordsByTopic(1000);
        this.stopConnector();
        this.startConnector((Configuration.Builder x) -> this.mutableConfig(false, false));
        this.waitForConnectorToStart();
        this.sendAdHocSnapshotSignal();
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
        this.stopConnector();
    }

    protected void sendAdHocSnapshotSignalAndWait(String ... collectionIds) throws Exception {
        if (collectionIds.length == 0) {
            this.sendAdHocSnapshotSignal();
        } else {
            this.sendAdHocSnapshotSignal(collectionIds);
        }
        Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> {
            AtomicBoolean result = new AtomicBoolean(false);
            this.consumeAvailableRecords(r -> {
                if (r.topic().endsWith(this.signalTableNameSanitized())) {
                    result.set(true);
                }
            });
            return result.get();
        });
    }

    protected void sendAdHocSnapshotStopSignalAndWait(String ... collectionIds) throws Exception {
        this.sendAdHocSnapshotStopSignal(collectionIds);
        Awaitility.await().atMost(60L, TimeUnit.SECONDS).until(() -> {
            AtomicBoolean stopSignal = new AtomicBoolean(false);
            this.consumeAvailableRecords(r -> {
                String type;
                Struct after;
                if (r.topic().endsWith(this.signalTableNameSanitized()) && (after = ((Struct)r.value()).getStruct("after")) != null && "stop-snapshot".equals(type = after.getString(this.getSignalTypeFieldName()))) {
                    stopSignal.set(true);
                }
            });
            return stopSignal.get();
        });
    }

    protected boolean consumeAnyRemainingIncrementalSnapshotEventsAndCheckForStopMessage(LogInterceptor interceptor, String stopMessage) throws Exception {
        AtomicBoolean stopMessageFound = new AtomicBoolean(false);
        Awaitility.await().atMost(60L, TimeUnit.SECONDS).pollDelay(5L, TimeUnit.SECONDS).pollInterval(1L, TimeUnit.SECONDS).until(() -> {
            if (interceptor.containsMessage(stopMessage)) {
                stopMessageFound.set(true);
            }
            return this.consumeAvailableRecords(r -> {}) == 0;
        });
        return stopMessageFound.get();
    }

    @Override
    protected int getMaximumEnqueuedRecordCount() {
        return 3000;
    }
}

