/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms.outbox;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.debezium.config.Configuration;
import io.debezium.data.VerifyRecord;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.transforms.outbox.EventRouter;
import io.debezium.transforms.outbox.EventRouterConfigDefinition;
import java.lang.invoke.CallSite;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.header.Headers;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.transforms.util.Requirements;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractEventRouterTest<T extends SourceConnector>
extends AbstractConnectorTest {
    protected EventRouter<SourceRecord> outboxEventRouter;

    protected abstract Class<T> getConnectorClass();

    protected abstract JdbcConnection databaseConnection();

    protected abstract Configuration.Builder getConfigurationBuilder(boolean var1);

    protected abstract String topicName();

    protected abstract String tableName();

    protected abstract String getSchemaNamePrefix();

    protected abstract Schema getPayloadSchema();

    protected abstract void createTable() throws Exception;

    protected abstract void alterTableWithExtra4Fields() throws Exception;

    protected abstract void alterTableWithTimestampField() throws Exception;

    protected abstract void alterTableModifyPayload() throws Exception;

    protected abstract String getAdditionalFieldValues(boolean var1);

    protected abstract String getAdditionalFieldValuesTimestampOnly();

    protected abstract String createInsert(String var1, String var2, String var3, String var4, String var5, String var6);

    protected abstract void waitForSnapshotCompleted() throws InterruptedException;

    protected abstract void waitForStreamingStarted() throws InterruptedException;

    @Before
    public void beforeEach() throws Exception {
        this.createTable();
        this.outboxEventRouter = new EventRouter();
        this.outboxEventRouter.configure(Collections.emptyMap());
    }

    @After
    public void afterEach() throws Exception {
        this.stopConnector();
        this.assertNoRecordsToConsume();
        this.outboxEventRouter.close();
    }

    @Test
    @FixFor(value={"DBZ-1169", "DBZ-3940"})
    public void shouldConsumeRecordsFromInsert() throws Exception {
        this.startConnectorWithInitialSnapshotRecord();
        this.databaseConnection().execute(new String[]{this.createInsert("59a42efd-b015-44a9-9dde-cb36d9002425", "UserCreated", "User", "10711fa5", "{}", "")});
        AbstractConnectorTest.SourceRecords streamingRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat(streamingRecords.allRecordsInOrder()).hasSize(1);
        SourceRecord record = streamingRecords.recordsForTopic(this.topicName()).get(0);
        SourceRecord routedEvent = (SourceRecord)this.outboxEventRouter.apply((ConnectRecord)record);
        Assertions.assertThat((Object)routedEvent).isNotNull();
        Assertions.assertThat((String)routedEvent.topic()).isEqualTo((Object)"outbox.event.User");
        Assertions.assertThat((Object)routedEvent.keySchema()).isEqualTo((Object)Schema.STRING_SCHEMA);
        Assertions.assertThat((Object)routedEvent.key()).isEqualTo((Object)"10711fa5");
        Assertions.assertThat((Object)routedEvent.value()).isInstanceOf(String.class);
        JsonNode payload = new ObjectMapper().readTree((String)routedEvent.value());
        Assertions.assertThat((Iterable)payload.get("email")).isNull();
    }

    @Test
    @FixFor(value={"DBZ-1385", "DBZ-3940"})
    public void shouldSendEventTypeAsHeader() throws Exception {
        this.startConnectorWithInitialSnapshotRecord();
        this.databaseConnection().execute(new String[]{this.createInsert("59a42efd-b015-44a9-9dde-cb36d9002425", "UserCreated", "User", "10711fa5", "{\"email\": \"gh@mefi.in\"}", "")});
        HashMap<String, CallSite> config = new HashMap<String, CallSite>();
        String placements = this.getFieldEventType() + ":header:eventType";
        config.put(EventRouterConfigDefinition.FIELDS_ADDITIONAL_PLACEMENT.name(), (CallSite)((Object)placements));
        this.outboxEventRouter.configure(config);
        AbstractConnectorTest.SourceRecords streamingRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat(streamingRecords.allRecordsInOrder()).hasSize(1);
        SourceRecord record = streamingRecords.recordsForTopic(this.topicName()).get(0);
        SourceRecord routedEvent = (SourceRecord)this.outboxEventRouter.apply((ConnectRecord)record);
        Assertions.assertThat((Object)routedEvent).isNotNull();
        Assertions.assertThat((String)routedEvent.topic()).isEqualTo((Object)"outbox.event.User");
        Object value = routedEvent.value();
        Assertions.assertThat((Object)routedEvent.headers().lastWithName("eventType").value()).isEqualTo((Object)"UserCreated");
        Assertions.assertThat((Object)value).isInstanceOf(String.class);
        JsonNode payload = new ObjectMapper().readTree((String)value);
        Assertions.assertThat((String)payload.get("email").asText()).isEqualTo((Object)"gh@mefi.in");
    }

    @Test
    @FixFor(value={"DBZ-2014", "DBZ-3940"})
    public void shouldSendEventTypeAsValue() throws Exception {
        this.startConnectorWithInitialSnapshotRecord();
        this.databaseConnection().execute(new String[]{this.createInsert("d4da2428-8b19-11ea-bc55-0242ac130003", "UserCreated", "User", "9948fcad", "{\"email\": \"gh@mefi.in\"}", "")});
        HashMap<String, CallSite> config = new HashMap<String, CallSite>();
        String placements = this.getFieldEventType() + ":envelope:eventType";
        config.put(EventRouterConfigDefinition.FIELDS_ADDITIONAL_PLACEMENT.name(), (CallSite)((Object)placements));
        this.outboxEventRouter.configure(config);
        AbstractConnectorTest.SourceRecords streamingRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat(streamingRecords.allRecordsInOrder()).hasSize(1);
        SourceRecord record = streamingRecords.recordsForTopic(this.topicName()).get(0);
        SourceRecord routedEvent = (SourceRecord)this.outboxEventRouter.apply((ConnectRecord)record);
        Assertions.assertThat((Object)routedEvent).isNotNull();
        Assertions.assertThat((String)routedEvent.topic()).isEqualTo((Object)"outbox.event.User");
        Struct valueStruct = Requirements.requireStruct((Object)routedEvent.value(), (String)"test payload");
        Assertions.assertThat((String)valueStruct.getString("eventType")).isEqualTo((Object)"UserCreated");
        JsonNode payload = new ObjectMapper().readTree(valueStruct.getString("payload"));
        Assertions.assertThat((String)payload.get("email").asText()).isEqualTo((Object)"gh@mefi.in");
    }

    @Test
    @FixFor(value={"DBZ-2014", "DBZ-3940"})
    public void shouldRespectJsonFormatAsString() throws Exception {
        this.startConnectorWithInitialSnapshotRecord();
        this.databaseConnection().execute(new String[]{this.createInsert("f9171eb6-19f3-4579-9206-0e179d2ebad7", "UserCreated", "User", "7bdf2e9e", "{\"email\": \"gh@mefi.in\"}", "")});
        AbstractConnectorTest.SourceRecords streamingRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat(streamingRecords.allRecordsInOrder()).hasSize(1);
        SourceRecord record = streamingRecords.recordsForTopic(this.topicName()).get(0);
        SourceRecord routedEvent = (SourceRecord)this.outboxEventRouter.apply((ConnectRecord)record);
        Assertions.assertThat((Object)routedEvent.value()).isInstanceOf(String.class);
        JsonNode payload = new ObjectMapper().readTree((String)routedEvent.value());
        Assertions.assertThat((String)payload.get("email").asText()).isEqualTo((Object)"gh@mefi.in");
    }

    @Test
    @FixFor(value={"DBZ-1169", "DBZ-3940"})
    public void shouldSupportAllFeatures() throws Exception {
        this.startConnectorWithNoSnapshot();
        StringBuilder placements = new StringBuilder();
        placements.append(this.envelope(this.getFieldSchemaVersion(), "eventVersion")).append(",");
        placements.append(this.envelope(this.getFieldAggregateType(), "aggregateType")).append(",");
        placements.append(this.envelope(this.getSomeBoolType(), "someBoolType")).append(",");
        placements.append(this.header(this.getSomeBoolType(), null)).append(",");
        placements.append(this.envelope(this.getIsDeleted(), "deleted"));
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(EventRouterConfigDefinition.FIELD_SCHEMA_VERSION.name(), this.getFieldSchemaVersion());
        config.put(EventRouterConfigDefinition.FIELD_EVENT_TIMESTAMP.name(), this.getFieldEventTimestamp());
        config.put(EventRouterConfigDefinition.FIELDS_ADDITIONAL_PLACEMENT.name(), placements.toString());
        this.outboxEventRouter.configure(config);
        this.alterTableWithExtra4Fields();
        this.databaseConnection().execute(new String[]{this.createInsert("f9171eb6-19f3-4579-9206-0e179d2ebad7", "UserUpdated", "UserEmail", "7bdf2e9e", "{\"email\": \"gh@mefi.in\"}", this.getAdditionalFieldValues(false))});
        AbstractConnectorTest.SourceRecords streamingRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat(streamingRecords.allRecordsInOrder()).hasSize(1);
        SourceRecord record = streamingRecords.recordsForTopic(this.topicName()).get(0);
        SourceRecord routedEvent = (SourceRecord)this.outboxEventRouter.apply((ConnectRecord)record);
        Schema expectedSchema = SchemaBuilder.struct().version(Integer.valueOf(1)).name(this.getSchemaNamePrefix() + "UserEmail.Value").field("payload", this.getPayloadSchema()).field("eventVersion", Schema.INT32_SCHEMA).field("aggregateType", Schema.STRING_SCHEMA).field("someBoolType", Schema.BOOLEAN_SCHEMA).field("deleted", SchemaBuilder.bool().optional().defaultValue((Object)false).build()).build();
        VerifyRecord.assertConnectSchemasAreEqual(null, (Schema)routedEvent.valueSchema(), (Schema)expectedSchema);
        Assertions.assertThat((Long)routedEvent.timestamp()).isEqualTo(1553460779000L);
        Assertions.assertThat((String)routedEvent.topic()).isEqualTo((Object)"outbox.event.UserEmail");
        Headers headers = routedEvent.headers();
        Assertions.assertThat((Iterable)headers).hasSize(2);
        Header headerId = headers.lastWithName("id");
        Assertions.assertThat((Object)headerId.schema()).isEqualTo((Object)this.getIdSchema());
        Assertions.assertThat((Object)headerId.value()).isEqualTo(this.getId("f9171eb6-19f3-4579-9206-0e179d2ebad7"));
        Header headerBool = headers.lastWithName(this.getSomeBoolType());
        Assertions.assertThat((Object)headerBool.schema()).isEqualTo((Object)SchemaBuilder.BOOLEAN_SCHEMA);
        Assertions.assertThat((Object)headerBool.value()).isEqualTo((Object)true);
        Assertions.assertThat((Object)routedEvent.keySchema()).isEqualTo((Object)SchemaBuilder.STRING_SCHEMA);
        Assertions.assertThat((Object)routedEvent.key()).isEqualTo((Object)"7bdf2e9e");
        Struct valueStruct = Requirements.requireStruct((Object)routedEvent.value(), (String)"test envelope");
        Assertions.assertThat((String)valueStruct.getString("aggregateType")).isEqualTo((Object)"UserEmail");
        Assertions.assertThat((Integer)valueStruct.getInt32("eventVersion")).isEqualTo(1);
        Assertions.assertThat((Object)valueStruct.get("someBoolType")).isEqualTo((Object)true);
        Assertions.assertThat((Object)valueStruct.get("deleted")).isEqualTo((Object)false);
    }

    @Test
    @FixFor(value={"DBZ-1707", "DBZ-3940"})
    public void shouldConvertMicrosecondsTimestampToMilliseconds() throws Exception {
        this.startConnectorWithNoSnapshot();
        this.outboxEventRouter = new EventRouter();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(EventRouterConfigDefinition.FIELD_EVENT_TIMESTAMP.name(), this.getFieldEventTimestamp());
        this.outboxEventRouter.configure(config);
        this.alterTableWithTimestampField();
        this.databaseConnection().execute(new String[]{this.createInsert("f9171eb6-19f3-4579-9206-0e179d2ebad7", "UserUpdated", "UserEmail", "7bdf2e9e", "{\"email\": \"gh@mefi.in\"}", this.getAdditionalFieldValuesTimestampOnly())});
        AbstractConnectorTest.SourceRecords streamingRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat(streamingRecords.allRecordsInOrder()).hasSize(1);
        SourceRecord record = streamingRecords.recordsForTopic(this.topicName()).get(0);
        SourceRecord routedEvent = (SourceRecord)this.outboxEventRouter.apply((ConnectRecord)record);
        Assertions.assertThat((Long)routedEvent.timestamp()).isEqualTo(1553460779000L);
    }

    @Test
    @FixFor(value={"DBZ-1320", "DBZ-3940"})
    public void shouldNotProduceTombstoneEventForNullPayload() throws Exception {
        this.startConnectorWithNoSnapshot();
        StringBuilder placements = new StringBuilder();
        placements.append(this.envelope(this.getFieldSchemaVersion(), "eventVersion")).append(",");
        placements.append(this.envelope(this.getFieldAggregateType(), "agregateType")).append(",");
        placements.append(this.envelope(this.getSomeBoolType(), "someBoolType")).append(",");
        placements.append(this.header(this.getSomeBoolType(), null)).append(",");
        placements.append(this.envelope(this.getIsDeleted(), "deleted"));
        this.outboxEventRouter = new EventRouter();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(EventRouterConfigDefinition.FIELD_SCHEMA_VERSION.name(), this.getFieldSchemaVersion());
        config.put(EventRouterConfigDefinition.FIELD_EVENT_TIMESTAMP.name(), this.getFieldEventTimestamp());
        config.put(EventRouterConfigDefinition.FIELDS_ADDITIONAL_PLACEMENT.name(), placements.toString());
        this.outboxEventRouter.configure(config);
        this.alterTableWithExtra4Fields();
        this.databaseConnection().execute(new String[]{this.createInsert("a9d76f78-bda6-48d3-97ed-13a146163218", "UserUpdated", "UserEmail", "a9d76f78", null, this.getAdditionalFieldValues(true))});
        AbstractConnectorTest.SourceRecords streamingRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat(streamingRecords.topics()).hasSize(1);
        SourceRecord record = streamingRecords.recordsForTopic(this.topicName()).get(0);
        SourceRecord routedEvent = (SourceRecord)this.outboxEventRouter.apply((ConnectRecord)record);
        Assertions.assertThat((Object)routedEvent.valueSchema()).isNotNull();
        Assertions.assertThat((Long)routedEvent.timestamp()).isEqualTo(1553460779000L);
        Assertions.assertThat((String)routedEvent.topic()).isEqualTo((Object)"outbox.event.UserEmail");
        Headers headers = routedEvent.headers();
        Assertions.assertThat((int)headers.size()).isEqualTo(2);
        Header headerId = headers.lastWithName("id");
        Assertions.assertThat((Object)headerId.schema()).isEqualTo((Object)this.getIdSchema());
        Assertions.assertThat((Object)headerId.value()).isEqualTo(this.getId("a9d76f78-bda6-48d3-97ed-13a146163218"));
        Header headerBool = headers.lastWithName(this.getSomeBoolType());
        Assertions.assertThat((Object)headerBool.schema()).isEqualTo((Object)SchemaBuilder.BOOLEAN_SCHEMA);
        Assertions.assertThat((Object)headerBool.value()).isEqualTo((Object)true);
        Assertions.assertThat((Object)routedEvent.keySchema()).isEqualTo((Object)SchemaBuilder.STRING_SCHEMA);
        Assertions.assertThat((Object)routedEvent.key()).isEqualTo((Object)"a9d76f78");
        System.out.println(routedEvent);
        Assertions.assertThat((Object)routedEvent.value()).isNotNull();
        Assertions.assertThat((Object)((Struct)routedEvent.value()).get("payload")).isNull();
    }

    @Test
    @FixFor(value={"DBZ-1320", "DBZ-3940"})
    public void shouldProduceTombstoneEventForNullPayload() throws Exception {
        this.startConnectorWithNoSnapshot();
        StringBuilder placements = new StringBuilder();
        placements.append(this.envelope(this.getFieldSchemaVersion(), "eventVersion")).append(",");
        placements.append(this.envelope(this.getFieldAggregateType(), "aggregateType")).append(",");
        placements.append(this.envelope(this.getSomeBoolType(), "someBoolType")).append(",");
        placements.append(this.header(this.getSomeBoolType(), null)).append(",");
        placements.append(this.envelope(this.getIsDeleted(), "deleted"));
        this.outboxEventRouter = new EventRouter();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(EventRouterConfigDefinition.FIELD_SCHEMA_VERSION.name(), this.getFieldSchemaVersion());
        config.put(EventRouterConfigDefinition.FIELD_EVENT_TIMESTAMP.name(), this.getFieldEventTimestamp());
        config.put(EventRouterConfigDefinition.ROUTE_TOMBSTONE_ON_EMPTY_PAYLOAD.name(), "true");
        config.put(EventRouterConfigDefinition.FIELDS_ADDITIONAL_PLACEMENT.name(), placements.toString());
        this.outboxEventRouter.configure(config);
        this.alterTableWithExtra4Fields();
        this.databaseConnection().execute(new String[]{this.createInsert("a9d76f78-bda6-48d3-97ed-13a146163218", "UserUpdated", "UserEmail", "a9d76f78", null, this.getAdditionalFieldValues(true))});
        AbstractConnectorTest.SourceRecords streamingRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat(streamingRecords.topics()).hasSize(1);
        SourceRecord record = streamingRecords.recordsForTopic(this.topicName()).get(0);
        SourceRecord routedEvent = (SourceRecord)this.outboxEventRouter.apply((ConnectRecord)record);
        Assertions.assertThat((Object)routedEvent.valueSchema()).isNull();
        Assertions.assertThat((Long)routedEvent.timestamp()).isEqualTo(1553460779000L);
        Assertions.assertThat((String)routedEvent.topic()).isEqualTo((Object)"outbox.event.UserEmail");
        Headers headers = routedEvent.headers();
        Assertions.assertThat((int)headers.size()).isEqualTo(2);
        Header headerId = headers.lastWithName("id");
        Assertions.assertThat((Object)headerId.schema()).isEqualTo((Object)this.getIdSchema());
        Assertions.assertThat((Object)headerId.value()).isEqualTo(this.getId("a9d76f78-bda6-48d3-97ed-13a146163218"));
        Header headerBool = headers.lastWithName(this.getSomeBoolType());
        Assertions.assertThat((Object)headerBool.schema()).isEqualTo((Object)SchemaBuilder.BOOLEAN_SCHEMA);
        Assertions.assertThat((Object)headerBool.value()).isEqualTo((Object)true);
        Assertions.assertThat((Object)routedEvent.keySchema()).isEqualTo((Object)SchemaBuilder.STRING_SCHEMA);
        Assertions.assertThat((Object)routedEvent.key()).isEqualTo((Object)"a9d76f78");
        Assertions.assertThat((Object)routedEvent.value()).isNull();
    }

    @Test
    @FixFor(value={"DBZ-1320", "DBZ-3940"})
    public void shouldProduceTombstoneEventForEmptyPayload() throws Exception {
        this.startConnectorWithNoSnapshot();
        this.outboxEventRouter = new EventRouter();
        HashMap<String, String> config = new HashMap<String, String>();
        config.put(EventRouterConfigDefinition.ROUTE_TOMBSTONE_ON_EMPTY_PAYLOAD.name(), "true");
        this.outboxEventRouter.configure(config);
        this.alterTableModifyPayload();
        this.databaseConnection().execute(new String[]{this.createInsert("a9d76f78-bda6-48d3-97ed-13a146163218", "UserUpdated", "UserEmail", "a9d76f78", "", null)});
        AbstractConnectorTest.SourceRecords streamingRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat(streamingRecords.topics()).hasSize(1);
        SourceRecord record = streamingRecords.recordsForTopic(this.topicName()).get(0);
        SourceRecord routedEvent = (SourceRecord)this.outboxEventRouter.apply((ConnectRecord)record);
        Assertions.assertThat((Object)routedEvent.valueSchema()).isNull();
        Assertions.assertThat((String)routedEvent.topic()).isEqualTo((Object)"outbox.event.UserEmail");
        Headers headers = routedEvent.headers();
        Assertions.assertThat((int)headers.size()).isEqualTo(1);
        Header headerId = headers.lastWithName("id");
        Assertions.assertThat((Object)headerId.schema()).isEqualTo((Object)this.getIdSchema());
        Assertions.assertThat((Object)headerId.value()).isEqualTo(this.getId("a9d76f78-bda6-48d3-97ed-13a146163218"));
        Assertions.assertThat((Object)routedEvent.keySchema()).isEqualTo((Object)SchemaBuilder.STRING_SCHEMA);
        Assertions.assertThat((Object)routedEvent.key()).isEqualTo((Object)"a9d76f78");
        Assertions.assertThat((Object)routedEvent.value()).isNull();
    }

    protected String getFieldEventType() {
        return EventRouterConfigDefinition.FIELD_EVENT_TYPE.defaultValueAsString();
    }

    protected String getFieldSchemaVersion() {
        return "version";
    }

    protected String getFieldEventTimestamp() {
        return "createdat";
    }

    protected String getFieldAggregateType() {
        return "aggregatetype";
    }

    protected String getSomeBoolType() {
        return "somebooltype";
    }

    protected String getIsDeleted() {
        return "is_deleted";
    }

    protected Schema getIdSchema() {
        return SchemaBuilder.STRING_SCHEMA;
    }

    protected Object getId(String idValue) {
        return idValue;
    }

    private String envelope(String source, String destination) {
        return source + ":envelope:" + destination;
    }

    private String header(String source, String destination) {
        return source + ":header" + (String)(destination != null && destination.length() > 0 ? ":" + destination : "");
    }

    private void startConnectorWithInitialSnapshotRecord() throws Exception {
        this.doInsert(this.createInsert("70f52ae3-f671-4bac-ae62-1b9be6e73700", "UserCreated", "User", "10711faf", "{}", ""));
        Configuration.Builder configBuilder = this.getConfigurationBuilder(true);
        this.start(this.getConnectorClass(), configBuilder.build());
        this.assertConnectorIsRunning();
        this.waitForSnapshotCompleted();
        AbstractConnectorTest.SourceRecords snapshotRecords = this.consumeRecordsByTopic(1);
        Assertions.assertThat(snapshotRecords.allRecordsInOrder()).hasSize(1);
        List<SourceRecord> records = snapshotRecords.recordsForTopic(this.topicName());
        Assertions.assertThat(records).hasSize(1);
    }

    private void startConnectorWithNoSnapshot() throws Exception {
        Configuration.Builder configBuilder = this.getConfigurationBuilder(false);
        this.start(this.getConnectorClass(), configBuilder.build());
        this.assertConnectorIsRunning();
        this.waitForStreamingStarted();
        this.assertNoRecordsToConsume();
    }

    private void doInsert(String insertSql) throws SQLException {
        this.databaseConnection().execute(new String[]{insertSql});
    }
}

