/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source.snapshot.incremental;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.doc.FixFor;
import io.debezium.embedded.AbstractConnectorTest;
import io.debezium.engine.DebeziumEngine;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.junit.EqualityCheck;
import io.debezium.junit.SkipWhenConnectorUnderTest;
import io.debezium.junit.SkipWhenConnectorsUnderTest;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.fest.assertions.IntAssert;
import org.fest.assertions.MapAssert;
import org.junit.Test;

public abstract class AbstractIncrementalSnapshotTest<T extends SourceConnector>
extends AbstractConnectorTest {
    protected static final int ROW_COUNT = 1000;
    private static final int MAXIMUM_NO_RECORDS_CONSUMES = 3;
    protected static final Path DB_HISTORY_PATH = Testing.Files.createTestingPath((String)"file-db-history-is.txt").toAbsolutePath();

    protected abstract Class<T> connectorClass();

    protected abstract JdbcConnection databaseConnection();

    protected abstract String topicName();

    protected abstract String tableName();

    protected abstract String signalTableName();

    protected abstract Configuration.Builder config();

    protected String alterTableAddColumnStatement(String tableName) {
        return "ALTER TABLE " + tableName + " add col3 int default 0";
    }

    protected String alterTableDropColumnStatement(String tableName) {
        return "ALTER TABLE " + tableName + " drop column col3";
    }

    protected String tableDataCollectionId() {
        return this.tableName();
    }

    protected void populateTable(JdbcConnection connection, String tableName) throws SQLException {
        connection.setAutoCommit(false);
        for (int i = 0; i < 1000; ++i) {
            connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO %s (pk, aa) VALUES (%s, %s)", tableName, i + 1, i)});
        }
        connection.commit();
    }

    protected void populateTable(JdbcConnection connection) throws SQLException {
        this.populateTable(connection, this.tableName());
    }

    protected void populateTable() throws SQLException {
        try (JdbcConnection connection = this.databaseConnection();){
            this.populateTable(connection);
        }
    }

    protected void populate4PkTable(JdbcConnection connection, String tableName) throws SQLException {
        connection.setAutoCommit(false);
        for (int i = 0; i < 1000; ++i) {
            int id = i + 1;
            int pk1 = id / 1000;
            int pk2 = id / 100 % 10;
            int pk3 = id / 10 % 10;
            int pk4 = id % 10;
            connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO %s (pk1, pk2, pk3, pk4, aa) VALUES (%s, %s, %s, %s, %s)", tableName, pk1, pk2, pk3, pk4, i)});
        }
        connection.commit();
    }

    protected Map<Integer, Integer> consumeMixedWithIncrementalSnapshot(int recordCount) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, record -> ((Struct)record.value()).getStruct("after").getInt32(this.valueFieldName()), x -> true, null);
    }

    protected <V> Map<Integer, V> consumeMixedWithIncrementalSnapshot(int recordCount, Function<SourceRecord, V> valueConverter, Predicate<Map.Entry<Integer, V>> dataCompleted, Consumer<List<SourceRecord>> recordConsumer) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, dataCompleted, k -> k.getInt32(this.pkFieldName()), valueConverter, this.topicName(), recordConsumer);
    }

    protected <V> Map<Integer, V> consumeMixedWithIncrementalSnapshot(int recordCount, Predicate<Map.Entry<Integer, V>> dataCompleted, Function<Struct, Integer> idCalculator, Function<SourceRecord, V> valueConverter, String topicName, Consumer<List<SourceRecord>> recordConsumer) throws InterruptedException {
        HashMap dbChanges = new HashMap();
        int noRecords = 0;
        while (true) {
            AbstractConnectorTest.SourceRecords records = this.consumeRecordsByTopic(1);
            List<SourceRecord> dataRecords = records.recordsForTopic(topicName);
            if (records.allRecordsInOrder().isEmpty()) {
                ((IntAssert)Assertions.assertThat((int)(++noRecords)).describedAs(String.format("Too many no data record results, %d < %d", dbChanges.size(), recordCount))).isLessThanOrEqualTo(3);
                continue;
            }
            noRecords = 0;
            if (dataRecords == null || dataRecords.isEmpty()) continue;
            dataRecords.forEach(record -> {
                int id = (Integer)idCalculator.apply((Struct)record.key());
                Object value = valueConverter.apply((SourceRecord)record);
                dbChanges.put(id, value);
            });
            if (recordConsumer != null) {
                recordConsumer.accept(dataRecords);
            }
            if (dbChanges.size() >= recordCount && !dbChanges.entrySet().stream().anyMatch(dataCompleted.negate())) break;
        }
        Assertions.assertThat(dbChanges).hasSize(recordCount);
        return dbChanges;
    }

    protected Map<Integer, SourceRecord> consumeRecordsMixedWithIncrementalSnapshot(int recordCount) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, Function.identity(), x -> true, null);
    }

    protected Map<Integer, Integer> consumeMixedWithIncrementalSnapshot(int recordCount, Predicate<Map.Entry<Integer, Integer>> dataCompleted, Consumer<List<SourceRecord>> recordConsumer) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, record -> ((Struct)record.value()).getStruct("after").getInt32(this.valueFieldName()), dataCompleted, recordConsumer);
    }

    protected Map<Integer, SourceRecord> consumeRecordsMixedWithIncrementalSnapshot(int recordCount, Predicate<Map.Entry<Integer, SourceRecord>> dataCompleted, Consumer<List<SourceRecord>> recordConsumer) throws InterruptedException {
        return this.consumeMixedWithIncrementalSnapshot(recordCount, Function.identity(), dataCompleted, recordConsumer);
    }

    protected String valueFieldName() {
        return "aa";
    }

    protected String pkFieldName() {
        return "pk";
    }

    protected void sendAdHocSnapshotSignal(String ... dataCollectionIds) throws SQLException {
        String dataCollectionIdsList = Arrays.stream(dataCollectionIds).map(x -> '\"' + x + '\"').collect(Collectors.joining(", "));
        try (JdbcConnection connection = this.databaseConnection();){
            String query = String.format("INSERT INTO %s VALUES('ad-hoc', 'execute-snapshot', '{\"data-collections\": [%s]}')", this.signalTableName(), dataCollectionIdsList);
            this.logger.info("Sending signal with query {}", (Object)query);
            connection.execute(new String[]{query});
        }
        catch (Exception e) {
            this.logger.warn("Failed to send signal", (Throwable)e);
        }
    }

    protected void sendAdHocSnapshotSignal() throws SQLException {
        this.sendAdHocSnapshotSignal(this.tableDataCollectionId());
    }

    protected void startConnector(DebeziumEngine.CompletionCallback callback) {
        this.startConnector(Function.identity(), callback);
    }

    protected void startConnector(Function<Configuration.Builder, Configuration.Builder> custConfig) {
        this.startConnector(custConfig, (DebeziumEngine.CompletionCallback)this.loggingCompletion());
    }

    protected void startConnector(Function<Configuration.Builder, Configuration.Builder> custConfig, DebeziumEngine.CompletionCallback callback) {
        Configuration config = custConfig.apply(this.config()).build();
        this.start(this.connectorClass(), config, callback);
        this.waitForConnectorToStart();
        this.waitForAvailableRecords(5L, TimeUnit.SECONDS);
        this.assertNoRecordsToConsume();
    }

    protected void startConnector() {
        this.startConnector(Function.identity(), (DebeziumEngine.CompletionCallback)this.loggingCompletion());
    }

    protected void waitForConnectorToStart() {
        this.assertConnectorIsRunning();
    }

    @Test
    public void snapshotOnly() throws Exception {
        this.populateTable();
        this.startConnector();
        this.sendAdHocSnapshotSignal();
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    public void invalidTablesInTheList() throws Exception {
        this.populateTable();
        this.startConnector();
        this.sendAdHocSnapshotSignal("invalid1", this.tableDataCollectionId(), "invalid2");
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    public void inserts() throws Exception {
        this.populateTable();
        this.startConnector();
        this.sendAdHocSnapshotSignal();
        try (JdbcConnection connection = this.databaseConnection();){
            connection.setAutoCommit(false);
            for (int i = 0; i < 1000; ++i) {
                connection.executeWithoutCommitting(new String[]{String.format("INSERT INTO %s (pk, aa) VALUES (%s, %s)", this.tableName(), i + 1000 + 1, i + 1000)});
            }
            connection.commit();
        }
        int expectedRecordCount = 2000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(2000);
        for (int i = 0; i < 2000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    public void updates() throws Exception {
        this.populateTable();
        this.startConnector();
        this.sendAdHocSnapshotSignal();
        int batchSize = 10;
        try (JdbcConnection connection = this.databaseConnection();){
            connection.setAutoCommit(false);
            for (int i = 0; i < 1000; ++i) {
                connection.executeWithoutCommitting(new String[]{String.format("UPDATE %s SET aa = aa + 2000 WHERE pk > %s AND pk <= %s", this.tableName(), i * 10, (i + 1) * 10)});
                connection.commit();
            }
        }
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000, x -> (Integer)x.getValue() >= 2000, null);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)(i + 2000))});
        }
    }

    @Test
    public void updatesWithRestart() throws Exception {
        this.populateTable();
        Configuration config = this.config().build();
        this.startAndConsumeTillEnd(this.connectorClass(), config);
        this.waitForConnectorToStart();
        this.waitForAvailableRecords(1L, TimeUnit.SECONDS);
        this.assertNoRecordsToConsume();
        this.sendAdHocSnapshotSignal();
        int batchSize = 10;
        try (JdbcConnection connection = this.databaseConnection();){
            connection.setAutoCommit(false);
            for (int i = 0; i < 1000; ++i) {
                connection.executeWithoutCommitting(new String[]{String.format("UPDATE %s SET aa = aa + 2000 WHERE pk > %s AND pk <= %s", this.tableName(), i * 10, (i + 1) * 10)});
                connection.commit();
            }
        }
        int expectedRecordCount = 1000;
        AtomicInteger recordCounter = new AtomicInteger();
        AtomicBoolean restarted = new AtomicBoolean();
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000, x -> (Integer)x.getValue() >= 2000, x -> {
            if (recordCounter.addAndGet(x.size()) > 50 && !restarted.get()) {
                this.stopConnector();
                this.assertConnectorNotRunning();
                this.start(this.connectorClass(), config);
                this.waitForConnectorToStart();
                restarted.set(true);
            }
        });
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)(i + 2000))});
        }
    }

    @Test
    public void updatesLargeChunk() throws Exception {
        this.populateTable();
        this.startConnector((Configuration.Builder x) -> (Configuration.Builder)x.with(CommonConnectorConfig.INCREMENTAL_SNAPSHOT_CHUNK_SIZE, 1000));
        this.sendAdHocSnapshotSignal();
        try (JdbcConnection connection = this.databaseConnection();){
            connection.execute(new String[]{String.format("UPDATE %s SET aa = aa + 2000", this.tableName())});
        }
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000, x -> (Integer)x.getValue() >= 2000, null);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)(i + 2000))});
        }
    }

    @Test
    public void snapshotOnlyWithRestart() throws Exception {
        this.populateTable();
        Configuration config = this.config().build();
        this.startAndConsumeTillEnd(this.connectorClass(), config);
        this.waitForConnectorToStart();
        this.waitForAvailableRecords(1L, TimeUnit.SECONDS);
        this.assertNoRecordsToConsume();
        this.sendAdHocSnapshotSignal();
        int expectedRecordCount = 1000;
        AtomicInteger recordCounter = new AtomicInteger();
        AtomicBoolean restarted = new AtomicBoolean();
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000, x -> true, x -> {
            if (recordCounter.addAndGet(x.size()) > 50 && !restarted.get()) {
                this.stopConnector();
                this.assertConnectorNotRunning();
                this.start(this.connectorClass(), config);
                this.waitForConnectorToStart();
                restarted.set(true);
            }
        });
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Test
    @SkipWhenConnectorsUnderTest(value={@SkipWhenConnectorUnderTest(check=EqualityCheck.EQUAL, value=SkipWhenConnectorUnderTest.Connector.SQL_SERVER), @SkipWhenConnectorUnderTest(check=EqualityCheck.EQUAL, value=SkipWhenConnectorUnderTest.Connector.DB2)})
    @FixFor(value={"DBZ-4272"})
    public void snapshotPreceededBySchemaChange() throws Exception {
        this.populateTable();
        this.startConnector();
        this.waitForConnectorToStart();
        try (JdbcConnection connection = this.databaseConnection();){
            connection.execute(new String[]{this.alterTableAddColumnStatement(this.tableName())});
        }
        this.sendAdHocSnapshotSignal();
        int expectedRecordCount = 1000;
        Map<Integer, Integer> dbChanges = this.consumeMixedWithIncrementalSnapshot(1000);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
        try (JdbcConnection connection = this.databaseConnection();){
            connection.execute(new String[]{this.alterTableDropColumnStatement(this.tableName())});
        }
        this.sendAdHocSnapshotSignal();
        dbChanges = this.consumeMixedWithIncrementalSnapshot(1000);
        for (int i = 0; i < 1000; ++i) {
            Assertions.assertThat(dbChanges).includes(new MapAssert.Entry[]{MapAssert.entry((Object)(i + 1), (Object)i)});
        }
    }

    @Override
    protected int getMaximumEnqueuedRecordCount() {
        return 3000;
    }
}

