/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import io.debezium.config.Configuration;
import io.debezium.embedded.EmbeddedEngine;
import io.debezium.embedded.spi.OffsetCommitPolicy;
import java.time.Duration;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class OffsetCommitPolicyTest {
    @Test
    public void shouldAlwaysCommit() {
        OffsetCommitPolicy policy = OffsetCommitPolicy.always();
        Assertions.assertThat((boolean)policy.performCommit(0L, Duration.ofNanos(0L))).isTrue();
        Assertions.assertThat((boolean)policy.performCommit(10000L, Duration.ofDays(1000L))).isTrue();
    }

    @Test
    public void shouldCommitPeriodically() {
        OffsetCommitPolicy policy = OffsetCommitPolicy.periodic((Configuration)((Configuration.Builder)Configuration.create().with(EmbeddedEngine.OFFSET_FLUSH_INTERVAL_MS, 36000000)).build());
        Assertions.assertThat((boolean)policy.performCommit(0L, Duration.ofNanos(0L))).isFalse();
        Assertions.assertThat((boolean)policy.performCommit(10000L, Duration.ofHours(9L))).isFalse();
        Assertions.assertThat((boolean)policy.performCommit(0L, Duration.ofHours(10L))).isTrue();
    }

    @Test
    public void shouldCommitPeriodicallyWithProperties() {
        Properties props = ((Configuration.Builder)Configuration.create().with(EmbeddedEngine.OFFSET_FLUSH_INTERVAL_MS, 36000000)).build().asProperties();
        OffsetCommitPolicy.PeriodicCommitOffsetPolicy policy = new OffsetCommitPolicy.PeriodicCommitOffsetPolicy(props);
        Assertions.assertThat((boolean)policy.performCommit(0L, Duration.ofNanos(0L))).isFalse();
        Assertions.assertThat((boolean)policy.performCommit(10000L, Duration.ofHours(9L))).isFalse();
        Assertions.assertThat((boolean)policy.performCommit(0L, Duration.ofHours(10L))).isTrue();
    }

    @Test
    public void shouldCombineTwoPolicies() {
        AtomicBoolean commitFirst = new AtomicBoolean(false);
        AtomicBoolean commitSecond = new AtomicBoolean(false);
        OffsetCommitPolicy policy1 = (num, time) -> commitFirst.get();
        OffsetCommitPolicy policy2 = (num, time) -> commitSecond.get();
        OffsetCommitPolicy both1 = policy1.and(policy2);
        OffsetCommitPolicy both2 = policy2.and(policy1);
        OffsetCommitPolicy either1 = policy1.or(policy2);
        OffsetCommitPolicy either2 = policy2.or(policy1);
        Assertions.assertThat((boolean)both1.performCommit(0L, Duration.ofNanos(0L))).isFalse();
        Assertions.assertThat((boolean)both2.performCommit(0L, Duration.ofNanos(0L))).isFalse();
        Assertions.assertThat((boolean)either1.performCommit(0L, Duration.ofNanos(0L))).isFalse();
        Assertions.assertThat((boolean)either2.performCommit(0L, Duration.ofNanos(0L))).isFalse();
        commitFirst.set(true);
        Assertions.assertThat((boolean)both1.performCommit(0L, Duration.ofNanos(0L))).isFalse();
        Assertions.assertThat((boolean)both2.performCommit(0L, Duration.ofNanos(0L))).isFalse();
        Assertions.assertThat((boolean)either1.performCommit(0L, Duration.ofNanos(0L))).isTrue();
        Assertions.assertThat((boolean)either2.performCommit(0L, Duration.ofNanos(0L))).isTrue();
        commitSecond.set(true);
        Assertions.assertThat((boolean)both1.performCommit(0L, Duration.ofNanos(0L))).isTrue();
        Assertions.assertThat((boolean)both2.performCommit(0L, Duration.ofNanos(0L))).isTrue();
        Assertions.assertThat((boolean)either1.performCommit(0L, Duration.ofNanos(0L))).isTrue();
        Assertions.assertThat((boolean)either2.performCommit(0L, Duration.ofNanos(0L))).isTrue();
        commitFirst.set(false);
        Assertions.assertThat((boolean)both1.performCommit(0L, Duration.ofNanos(0L))).isFalse();
        Assertions.assertThat((boolean)both2.performCommit(0L, Duration.ofNanos(0L))).isFalse();
        Assertions.assertThat((boolean)either1.performCommit(0L, Duration.ofNanos(0L))).isTrue();
        Assertions.assertThat((boolean)either2.performCommit(0L, Duration.ofNanos(0L))).isTrue();
        commitSecond.set(false);
        Assertions.assertThat((boolean)both1.performCommit(0L, Duration.ofNanos(0L))).isFalse();
        Assertions.assertThat((boolean)both2.performCommit(0L, Duration.ofNanos(0L))).isFalse();
        Assertions.assertThat((boolean)either1.performCommit(0L, Duration.ofNanos(0L))).isFalse();
        Assertions.assertThat((boolean)either2.performCommit(0L, Duration.ofNanos(0L))).isFalse();
    }

    @Test
    public void shouldCombineOnePolicyWithNull() {
        AtomicBoolean commit = new AtomicBoolean(false);
        OffsetCommitPolicy policy1 = (num, time) -> commit.get();
        Assertions.assertThat((Object)policy1.and(null)).isSameAs((Object)policy1);
        Assertions.assertThat((Object)policy1.or(null)).isSameAs((Object)policy1);
    }
}

