/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import java.util.concurrent.TimeUnit;

@FunctionalInterface
interface OffsetCommitPolicy {
    public static OffsetCommitPolicy always() {
        return (number, time, unit) -> true;
    }

    public static OffsetCommitPolicy periodic(long minimumTime, TimeUnit timeUnit) {
        if (minimumTime <= 0L) {
            return OffsetCommitPolicy.always();
        }
        return (number, actualTime, actualUnit) -> timeUnit.convert(actualTime, actualUnit) >= minimumTime;
    }

    public boolean performCommit(long var1, long var3, TimeUnit var5);

    default public OffsetCommitPolicy or(OffsetCommitPolicy other) {
        if (other == null) {
            return this;
        }
        return (number, time, unit) -> this.performCommit(number, time, unit) || other.performCommit(number, time, unit);
    }

    default public OffsetCommitPolicy and(OffsetCommitPolicy other) {
        if (other == null) {
            return this;
        }
        return (number, time, unit) -> this.performCommit(number, time, unit) && other.performCommit(number, time, unit);
    }
}

