/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.embedded;

import io.debezium.config.Configuration;
import io.debezium.embedded.EmbeddedEngine;
import io.debezium.function.BooleanConsumer;
import io.debezium.util.Testing;
import java.nio.file.Path;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceConnector;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConnectorTest
implements Testing {
    protected static final Path OFFSET_STORE_PATH = Testing.Files.createTestingPath((String)"file-connector-offsets.txt").toAbsolutePath();
    private ExecutorService executor;
    private EmbeddedEngine engine;
    private BlockingQueue<SourceRecord> consumedLines;
    protected long pollTimeoutInMs = TimeUnit.SECONDS.toMillis(5L);
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private CountDownLatch latch;

    @Before
    public final void initializeConnectorTestFramework() throws Exception {
        this.resetBeforeEachTest();
        this.consumedLines = new ArrayBlockingQueue<SourceRecord>(this.getMaximumEnqueuedRecordCount());
        Testing.Files.delete((Path)OFFSET_STORE_PATH);
    }

    @After
    public final void stopConnector() {
        this.stopConnector(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopConnector(BooleanConsumer callback) {
        try {
            if (this.engine != null && this.engine.isRunning()) {
                this.engine.stop();
                try {
                    this.engine.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
            if (this.executor != null) {
                List<Runnable> neverRunTasks = this.executor.shutdownNow();
                Assertions.assertThat(neverRunTasks).isEmpty();
                try {
                    while (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
            if (this.engine != null && this.engine.isRunning()) {
                try {
                    while (!this.engine.await(5L, TimeUnit.SECONDS)) {
                    }
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
            if (callback != null) {
                callback.accept(this.engine != null ? this.engine.isRunning() : false);
            }
        }
        finally {
            this.engine = null;
            this.executor = null;
        }
    }

    protected int getMaximumEnqueuedRecordCount() {
        return 100;
    }

    protected void start(Class<? extends SourceConnector> connectorClass, Configuration connectorConfig) {
        this.start(connectorClass, connectorConfig, (success, msg, error) -> {
            if (success) {
                this.logger.info(msg);
            } else {
                this.logger.error(msg, error);
            }
        });
    }

    protected void start(Class<? extends SourceConnector> connectorClass, Configuration connectorConfig, EmbeddedEngine.CompletionCallback callback) {
        Configuration config = ((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)((Configuration.Builder)Configuration.copy((Configuration)connectorConfig).with(EmbeddedEngine.ENGINE_NAME, "testing-connector")).with(EmbeddedEngine.CONNECTOR_CLASS, connectorClass.getName())).with("offset.storage.file.filename", (Object)OFFSET_STORE_PATH)).with(EmbeddedEngine.OFFSET_FLUSH_INTERVAL_MS, 0)).build();
        this.latch = new CountDownLatch(1);
        EmbeddedEngine.CompletionCallback wrapperCallback = (success, msg, error) -> {
            try {
                if (callback != null) {
                    callback.handle(success, msg, error);
                }
            }
            finally {
                this.latch.countDown();
            }
        };
        this.engine = EmbeddedEngine.create().using(config).notifying(this.consumedLines::add).using(this.getClass().getClassLoader()).using(wrapperCallback).build();
        Assertions.assertThat((Object)this.executor).isNull();
        this.executor = Executors.newFixedThreadPool(1);
        this.executor.execute((Runnable)this.engine);
    }

    protected void setConsumeTimeout(long timeout, TimeUnit unit) {
        if (timeout < 0L) {
            throw new IllegalArgumentException("The timeout may not be negative");
        }
        this.pollTimeoutInMs = unit.toMillis(timeout);
    }

    protected SourceRecord consumeRecord() throws InterruptedException {
        return this.consumedLines.poll(this.pollTimeoutInMs, TimeUnit.MILLISECONDS);
    }

    protected int consumeRecords(int numberOfRecords) throws InterruptedException {
        return this.consumeRecords(numberOfRecords, null);
    }

    protected int consumeRecords(int numberOfRecords, Consumer<SourceRecord> recordConsumer) throws InterruptedException {
        int recordsConsumed = 0;
        for (int i = 0; i != numberOfRecords; ++i) {
            SourceRecord record = this.consumedLines.poll(this.pollTimeoutInMs, TimeUnit.MILLISECONDS);
            if (record == null) continue;
            ++recordsConsumed;
            if (recordConsumer == null) continue;
            recordConsumer.accept(record);
        }
        return recordsConsumed;
    }

    protected int consumeAvailableRecords(Consumer<SourceRecord> recordConsumer) {
        LinkedList records = new LinkedList();
        this.consumedLines.drainTo(records);
        if (recordConsumer != null) {
            records.forEach(recordConsumer);
        }
        return records.size();
    }

    protected boolean waitForAvailableRecords(long timeout, TimeUnit unit) {
        Assertions.assertThat((long)timeout).isGreaterThanOrEqualTo(0L);
        long now = System.currentTimeMillis();
        long stop = now + unit.toMillis(timeout);
        while (System.currentTimeMillis() < stop && this.consumedLines.isEmpty()) {
        }
        return !this.consumedLines.isEmpty();
    }

    protected void assertConnectorIsRunning() {
        Assertions.assertThat((boolean)this.engine.isRunning()).isTrue();
    }

    protected void assertConnectorNotRunning() {
        Assertions.assertThat((boolean)this.engine.isRunning()).isFalse();
    }

    protected void assertNoRecordsToConsume() {
        Assertions.assertThat((boolean)this.consumedLines.isEmpty()).isTrue();
    }

    protected void print(SourceRecord record) {
        StringBuilder sb = new StringBuilder("SourceRecord{");
        sb.append("sourcePartition=").append(record.sourcePartition());
        sb.append(", sourceOffset=").append(record.sourceOffset());
        sb.append(", topic=").append(record.topic());
        sb.append(", kafkaPartition=").append(record.kafkaPartition());
        sb.append(", key=");
        this.append(record.key(), sb);
        sb.append(", value=");
        this.append(record.value(), sb);
        sb.append("}");
        Testing.print((Object)sb.toString());
    }

    protected void append(Object obj, StringBuilder sb) {
        boolean first;
        if (obj == null) {
            sb.append("null");
        } else if (obj instanceof Schema) {
            Schema schema = (Schema)obj;
            sb.append('{');
            sb.append("name=").append(schema.name());
            sb.append(", type=").append(schema.type());
            sb.append(", optional=").append(schema.isOptional());
            sb.append(", fields=");
            first = true;
            for (Field field : schema.fields()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append("name=").append(field.name());
                sb.append(", index=").append(field.index());
                sb.append(", schema=");
                this.append(field.schema(), sb);
            }
            sb.append('}');
        }
        if (obj instanceof Struct) {
            Struct s = (Struct)obj;
            sb.append('{');
            first = true;
            for (Field field : s.schema().fields()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                sb.append(field.name()).append('=');
                this.append(s.get(field), sb);
            }
            sb.append('}');
        } else if (obj instanceof Map) {
            Map map = (Map)obj;
            sb.append('{');
            first = true;
            for (Map.Entry entry : map.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                this.append(entry.getKey(), sb);
                sb.append('=');
                this.append(entry.getValue(), sb);
            }
            sb.append('}');
        } else if (obj instanceof List) {
            List list = (List)obj;
            sb.append('[');
            first = true;
            for (Object object : list) {
                if (first) {
                    first = false;
                } else {
                    sb.append(", ");
                }
                this.append(object, sb);
            }
            sb.append(']');
        } else if (obj instanceof String) {
            sb.append('\"').append(obj.toString()).append('\"');
        } else {
            sb.append(obj.toString());
        }
    }
}

