/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.mapping;

import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.mapping.TruncateColumn;
import java.nio.ByteBuffer;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class TruncateColumnTest {
    private final Column column = Column.editor().name("col").create();
    private ValueConverter converter;

    @Test
    public void shouldTruncateStrings() {
        this.converter = new TruncateColumn(5).create(this.column);
        Assertions.assertThat((String)this.converter.convert((Object)"1234567890").toString()).isEqualTo((Object)"12345");
        Assertions.assertThat((String)this.converter.convert((Object)"123456").toString()).isEqualTo((Object)"12345");
        Assertions.assertThat((String)this.converter.convert((Object)"12345").toString()).isEqualTo((Object)"12345");
        Assertions.assertThat((String)this.converter.convert((Object)"1234").toString()).isEqualTo((Object)"1234");
        Assertions.assertThat((String)this.converter.convert((Object)"123").toString()).isEqualTo((Object)"123");
        Assertions.assertThat((String)this.converter.convert((Object)"12").toString()).isEqualTo((Object)"12");
        Assertions.assertThat((String)this.converter.convert((Object)"1").toString()).isEqualTo((Object)"1");
        Assertions.assertThat((Object)this.converter.convert(null)).isNull();
        this.converter = new TruncateColumn(0).create(this.column);
        Assertions.assertThat((String)this.converter.convert((Object)"1234567890").toString()).isEqualTo((Object)"");
        Assertions.assertThat((String)this.converter.convert((Object)"123456").toString()).isEqualTo((Object)"");
        Assertions.assertThat((String)this.converter.convert((Object)"12345").toString()).isEqualTo((Object)"");
        Assertions.assertThat((String)this.converter.convert((Object)"1234").toString()).isEqualTo((Object)"");
        Assertions.assertThat((String)this.converter.convert((Object)"123").toString()).isEqualTo((Object)"");
        Assertions.assertThat((String)this.converter.convert((Object)"12").toString()).isEqualTo((Object)"");
        Assertions.assertThat((String)this.converter.convert((Object)"1").toString()).isEqualTo((Object)"");
        Assertions.assertThat((String)this.converter.convert((Object)"").toString()).isEqualTo((Object)"");
        Assertions.assertThat((Object)this.converter.convert(null)).isNull();
    }

    @Test
    public void shouldTruncateByteBuffer() {
        this.converter = new TruncateColumn(3).create(this.column);
        ByteBuffer buffer5 = this.createBuffer(5);
        ByteBuffer buffer4 = this.createBuffer(4);
        ByteBuffer buffer3 = this.createBuffer(3);
        ByteBuffer buffer2 = this.createBuffer(2);
        ByteBuffer buffer1 = this.createBuffer(1);
        Assertions.assertThat((Object)this.converter.convert((Object)buffer5)).isEqualTo((Object)buffer3);
        Assertions.assertThat((Object)this.converter.convert((Object)buffer4)).isEqualTo((Object)buffer3);
        Assertions.assertThat((Object)this.converter.convert((Object)buffer3)).isEqualTo((Object)buffer3);
        Assertions.assertThat((Object)this.converter.convert((Object)buffer2)).isEqualTo((Object)buffer2);
        Assertions.assertThat((Object)this.converter.convert((Object)buffer1)).isEqualTo((Object)buffer1);
        Assertions.assertThat((Object)this.converter.convert(null)).isNull();
        this.converter = new TruncateColumn(0).create(this.column);
        ByteBuffer buffer0 = this.createBuffer(0);
        Assertions.assertThat((Object)this.converter.convert((Object)buffer5)).isEqualTo((Object)buffer0);
        Assertions.assertThat((Object)this.converter.convert((Object)buffer4)).isEqualTo((Object)buffer0);
        Assertions.assertThat((Object)this.converter.convert((Object)buffer3)).isEqualTo((Object)buffer0);
        Assertions.assertThat((Object)this.converter.convert((Object)buffer2)).isEqualTo((Object)buffer0);
        Assertions.assertThat((Object)this.converter.convert((Object)buffer1)).isEqualTo((Object)buffer0);
        Assertions.assertThat((Object)this.converter.convert((Object)buffer0)).isEqualTo((Object)buffer0);
        Assertions.assertThat((Object)this.converter.convert(null)).isNull();
    }

    private ByteBuffer createBuffer(int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        for (int i = 0; i < size; ++i) {
            buffer.put((byte)i);
        }
        buffer.position(0);
        return buffer;
    }
}

