/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.connector.common;

import io.debezium.DebeziumException;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.connector.common.BaseSourceTask;
import io.debezium.doc.FixFor;
import io.debezium.function.LogPositionValidator;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.pipeline.ChangeEventSourceCoordinator;
import io.debezium.pipeline.spi.OffsetContext;
import io.debezium.pipeline.spi.Offsets;
import io.debezium.pipeline.spi.Partition;
import io.debezium.schema.DatabaseSchema;
import io.debezium.schema.HistorizedDatabaseSchema;
import io.debezium.spi.snapshot.Snapshotter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.source.SourceTaskContext;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class BaseSourceTaskSnapshotModesValidationTest {
    private final MyBaseSourceTask baseSourceTask = new MyBaseSourceTask();

    @Before
    public void setup() {
        this.baseSourceTask.initialize((SourceTaskContext)Mockito.mock(SourceTaskContext.class));
    }

    @Test
    @FixFor(value={"DBZ-7780"})
    public void whenSnapshotModePermitsSchemaOrDataAndSnapshotIsNotCompletedOnConnectorRestartsValidateMustPass() {
        CommonConnectorConfig commonConnectorConfig = (CommonConnectorConfig)Mockito.mock(CommonConnectorConfig.class);
        LogPositionValidator logPositionValidator = (partition, offsetContext, config) -> true;
        Partition partition2 = (Partition)Mockito.mock(Partition.class);
        OffsetContext offset = (OffsetContext)Mockito.mock(OffsetContext.class);
        Mockito.when((Object)offset.isSnapshotRunning()).thenReturn((Object)true);
        Offsets previousOffsets = Offsets.of((Partition)partition2, (OffsetContext)offset);
        DatabaseSchema databaseSchema = (DatabaseSchema)Mockito.mock(DatabaseSchema.class);
        Snapshotter snapshotter = (Snapshotter)Mockito.mock(Snapshotter.class);
        Mockito.when((Object)snapshotter.shouldSnapshotData(true, true)).thenReturn((Object)false);
        Mockito.when((Object)snapshotter.shouldSnapshotSchema(true, true)).thenReturn((Object)true);
        Assertions.assertThatCode(() -> this.baseSourceTask.validateAndLoadSchemaHistory(commonConnectorConfig, logPositionValidator, previousOffsets, databaseSchema, snapshotter)).doesNotThrowAnyException();
    }

    @Test
    public void whenSnapshotModeNotPermitsSchemaAndDataAndSnapshotIsNotCompletedOnConnectorRestartsExceptionWillBeThrown() {
        CommonConnectorConfig commonConnectorConfig = (CommonConnectorConfig)Mockito.mock(CommonConnectorConfig.class);
        LogPositionValidator logPositionValidator = (partition, offsetContext, config) -> true;
        Partition partition2 = (Partition)Mockito.mock(Partition.class);
        OffsetContext offset = (OffsetContext)Mockito.mock(OffsetContext.class);
        Mockito.when((Object)offset.isSnapshotRunning()).thenReturn((Object)true);
        Offsets previousOffsets = Offsets.of((Partition)partition2, (OffsetContext)offset);
        DatabaseSchema databaseSchema = (DatabaseSchema)Mockito.mock(DatabaseSchema.class);
        Snapshotter snapshotter = (Snapshotter)Mockito.mock(Snapshotter.class);
        Mockito.when((Object)snapshotter.shouldSnapshotData(true, true)).thenReturn((Object)false);
        Mockito.when((Object)snapshotter.shouldSnapshotSchema(true, true)).thenReturn((Object)false);
        ((AbstractThrowableAssert)Assertions.assertThatCode(() -> this.baseSourceTask.validateAndLoadSchemaHistory(commonConnectorConfig, logPositionValidator, previousOffsets, databaseSchema, snapshotter)).isInstanceOf(DebeziumException.class)).hasMessage("The connector previously stopped while taking a snapshot, but now the connector is configured to never allow snapshots. Reconfigure the connector to use snapshots initially or when needed.");
    }

    @Test
    public void whenNoOffsetExistsAndSnapshotPermitsSchemaRecoveryAnExceptionWillBeThrown() {
        CommonConnectorConfig commonConnectorConfig = (CommonConnectorConfig)Mockito.mock(CommonConnectorConfig.class);
        LogPositionValidator logPositionValidator = (partition, offsetContext, config) -> true;
        Partition partition2 = (Partition)Mockito.mock(Partition.class);
        Offsets previousOffsets = Offsets.of((Partition)partition2, null);
        DatabaseSchema databaseSchema = (DatabaseSchema)Mockito.mock(DatabaseSchema.class);
        Snapshotter snapshotter = (Snapshotter)Mockito.mock(Snapshotter.class);
        Mockito.when((Object)snapshotter.shouldSnapshotOnSchemaError()).thenReturn((Object)true);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.baseSourceTask.validateAndLoadSchemaHistory(commonConnectorConfig, logPositionValidator, previousOffsets, databaseSchema, snapshotter)).isInstanceOf(DebeziumException.class)).hasMessage("Could not find existing redo log information while attempting schema only recovery snapshot");
    }

    @Test
    public void whenNoOffsetExistsAndDatabaseIsHistorizedThenSchemaStorageIsInitialized() {
        CommonConnectorConfig commonConnectorConfig = (CommonConnectorConfig)Mockito.mock(CommonConnectorConfig.class);
        LogPositionValidator logPositionValidator = (partition, offsetContext, config) -> true;
        Partition partition2 = (Partition)Mockito.mock(Partition.class);
        Offsets previousOffsets = Offsets.of((Partition)partition2, null);
        HistorizedDatabaseSchema databaseSchema = (HistorizedDatabaseSchema)Mockito.mock(HistorizedDatabaseSchema.class);
        Mockito.when((Object)databaseSchema.isHistorized()).thenReturn((Object)true);
        Snapshotter snapshotter = (Snapshotter)Mockito.mock(Snapshotter.class);
        this.baseSourceTask.validateAndLoadSchemaHistory(commonConnectorConfig, logPositionValidator, previousOffsets, (DatabaseSchema)databaseSchema, snapshotter);
        ((HistorizedDatabaseSchema)Mockito.verify((Object)databaseSchema)).initializeStorage();
    }

    @Test
    public void whenCompletedSnapshotExistsAndHistoryNotExistsAndSnapshotOnSchemaErrorThenSchemaStorageIsInitialized() {
        CommonConnectorConfig commonConnectorConfig = (CommonConnectorConfig)Mockito.mock(CommonConnectorConfig.class);
        LogPositionValidator logPositionValidator = (partition, offsetContext, config) -> true;
        Partition partition2 = (Partition)Mockito.mock(Partition.class);
        OffsetContext offset = (OffsetContext)Mockito.mock(OffsetContext.class);
        Mockito.when((Object)offset.isSnapshotRunning()).thenReturn((Object)false);
        Offsets previousOffsets = Offsets.of((Partition)partition2, (OffsetContext)offset);
        HistorizedDatabaseSchema databaseSchema = (HistorizedDatabaseSchema)Mockito.mock(HistorizedDatabaseSchema.class);
        Mockito.when((Object)databaseSchema.isHistorized()).thenReturn((Object)true);
        Snapshotter snapshotter = (Snapshotter)Mockito.mock(Snapshotter.class);
        Mockito.when((Object)snapshotter.shouldSnapshotOnSchemaError()).thenReturn((Object)true);
        this.baseSourceTask.validateAndLoadSchemaHistory(commonConnectorConfig, logPositionValidator, previousOffsets, (DatabaseSchema)databaseSchema, snapshotter);
        ((HistorizedDatabaseSchema)Mockito.verify((Object)databaseSchema)).initializeStorage();
    }

    @Test
    public void whenCompletedSnapshotExistsAndHistoryNotExistsAndSnapshotOnSchemaErrorIsFalseThenAnExceptionWillBeThrown() {
        CommonConnectorConfig commonConnectorConfig = (CommonConnectorConfig)Mockito.mock(CommonConnectorConfig.class);
        LogPositionValidator logPositionValidator = (partition, offsetContext, config) -> true;
        Partition partition2 = (Partition)Mockito.mock(Partition.class);
        OffsetContext offset = (OffsetContext)Mockito.mock(OffsetContext.class);
        Mockito.when((Object)offset.isSnapshotRunning()).thenReturn((Object)false);
        Offsets previousOffsets = Offsets.of((Partition)partition2, (OffsetContext)offset);
        HistorizedDatabaseSchema databaseSchema = (HistorizedDatabaseSchema)Mockito.mock(HistorizedDatabaseSchema.class);
        Mockito.when((Object)databaseSchema.isHistorized()).thenReturn((Object)true);
        Snapshotter snapshotter = (Snapshotter)Mockito.mock(Snapshotter.class);
        Mockito.when((Object)snapshotter.shouldSnapshotOnSchemaError()).thenReturn((Object)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.baseSourceTask.validateAndLoadSchemaHistory(commonConnectorConfig, logPositionValidator, previousOffsets, (DatabaseSchema)databaseSchema, snapshotter)).isInstanceOf(DebeziumException.class)).hasMessage("The db history topic is missing. You may attempt to recover it by reconfiguring the connector to recovery.");
    }

    @Test
    public void whenCompletedSnapshotExistsAndStoredOffsetPositionIsPresentOnDbLogThenSchemaWillBeRecovered() {
        CommonConnectorConfig commonConnectorConfig = (CommonConnectorConfig)Mockito.mock(CommonConnectorConfig.class);
        Mockito.when((Object)commonConnectorConfig.isLogPositionCheckEnabled()).thenReturn((Object)true);
        LogPositionValidator logPositionValidator = (partition, offsetContext, config) -> true;
        Partition partition2 = (Partition)Mockito.mock(Partition.class);
        OffsetContext offset = (OffsetContext)Mockito.mock(OffsetContext.class);
        Mockito.when((Object)offset.isSnapshotRunning()).thenReturn((Object)false);
        Offsets previousOffsets = Offsets.of((Partition)partition2, (OffsetContext)offset);
        HistorizedDatabaseSchema databaseSchema = (HistorizedDatabaseSchema)Mockito.mock(HistorizedDatabaseSchema.class);
        Mockito.when((Object)databaseSchema.isHistorized()).thenReturn((Object)true);
        Mockito.when((Object)databaseSchema.historyExists()).thenReturn((Object)true);
        Snapshotter snapshotter = (Snapshotter)Mockito.mock(Snapshotter.class);
        this.baseSourceTask.validateAndLoadSchemaHistory(commonConnectorConfig, logPositionValidator, previousOffsets, (DatabaseSchema)databaseSchema, snapshotter);
        ((HistorizedDatabaseSchema)Mockito.verify((Object)databaseSchema)).recover(partition2, offset);
    }

    @Test
    public void whenCompletedSnapshotExistsAndStoredOffsetPositionIsNotPresentOnDbLogThenAWarnShouldBeLogged() {
        LogInterceptor logInterceptor = new LogInterceptor(BaseSourceTask.class);
        CommonConnectorConfig commonConnectorConfig = (CommonConnectorConfig)Mockito.mock(CommonConnectorConfig.class);
        Mockito.when((Object)commonConnectorConfig.isLogPositionCheckEnabled()).thenReturn((Object)true);
        LogPositionValidator logPositionValidator = (partition, offsetContext, config) -> false;
        Partition partition2 = (Partition)Mockito.mock(Partition.class);
        OffsetContext offset = (OffsetContext)Mockito.mock(OffsetContext.class);
        Mockito.when((Object)offset.isSnapshotRunning()).thenReturn((Object)false);
        Offsets previousOffsets = Offsets.of((Partition)partition2, (OffsetContext)offset);
        HistorizedDatabaseSchema databaseSchema = (HistorizedDatabaseSchema)Mockito.mock(HistorizedDatabaseSchema.class);
        Mockito.when((Object)databaseSchema.isHistorized()).thenReturn((Object)true);
        Mockito.when((Object)databaseSchema.historyExists()).thenReturn((Object)true);
        Snapshotter snapshotter = (Snapshotter)Mockito.mock(Snapshotter.class);
        this.baseSourceTask.validateAndLoadSchemaHistory(commonConnectorConfig, logPositionValidator, previousOffsets, (DatabaseSchema)databaseSchema, snapshotter);
        Assertions.assertThat((boolean)logInterceptor.containsWarnMessage("The connector is trying to read redo log starting at " + offset + ", but this is no longer available on the server. Reconfigure the connector to use a snapshot when needed if you want to recover. If not the connector will streaming from the last available position in the log")).isTrue();
    }

    @Test
    public void whenCompletedSnapshotExistsAndStoredOffsetPositionIsNotPresentOnDbLogAndSnapshotOnDataErrorThenOffsetWillBeReset() {
        CommonConnectorConfig commonConnectorConfig = (CommonConnectorConfig)Mockito.mock(CommonConnectorConfig.class);
        Mockito.when((Object)commonConnectorConfig.isLogPositionCheckEnabled()).thenReturn((Object)true);
        LogPositionValidator logPositionValidator = (partition, offsetContext, config) -> false;
        Partition partition2 = (Partition)Mockito.mock(Partition.class);
        OffsetContext offset = (OffsetContext)Mockito.mock(OffsetContext.class);
        Mockito.when((Object)offset.isSnapshotRunning()).thenReturn((Object)false);
        Offsets previousOffsets = Offsets.of((Partition)partition2, (OffsetContext)offset);
        HistorizedDatabaseSchema databaseSchema = (HistorizedDatabaseSchema)Mockito.mock(HistorizedDatabaseSchema.class);
        Mockito.when((Object)databaseSchema.isHistorized()).thenReturn((Object)true);
        Mockito.when((Object)databaseSchema.historyExists()).thenReturn((Object)true);
        Snapshotter snapshotter = (Snapshotter)Mockito.mock(Snapshotter.class);
        Mockito.when((Object)snapshotter.shouldSnapshotOnDataError()).thenReturn((Object)true);
        this.baseSourceTask.validateAndLoadSchemaHistory(commonConnectorConfig, logPositionValidator, previousOffsets, (DatabaseSchema)databaseSchema, snapshotter);
        Assertions.assertThat((Object)previousOffsets.getTheOnlyOffset()).isNull();
    }

    public static class MyBaseSourceTask
    extends BaseSourceTask<Partition, OffsetContext> {
        final List<SourceRecord> records = new ArrayList<SourceRecord>();
        final AtomicInteger startCount = new AtomicInteger();
        final AtomicInteger stopCount = new AtomicInteger();
        final ChangeEventSourceCoordinator<Partition, OffsetContext> coordinator = (ChangeEventSourceCoordinator)Mockito.mock(ChangeEventSourceCoordinator.class);

        protected ChangeEventSourceCoordinator<Partition, OffsetContext> start(Configuration config) {
            this.startCount.incrementAndGet();
            return this.coordinator;
        }

        protected List<SourceRecord> doPoll() {
            return this.records;
        }

        protected void resetErrorHandlerRetriesIfNeeded(List<SourceRecord> records) {
        }

        protected void doStop() {
            this.stopCount.incrementAndGet();
        }

        protected Iterable<Field> getAllConfigurationFields() {
            return List.of(Field.create((String)"f1"));
        }

        public String version() {
            return "1.0";
        }
    }
}

