/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.snapshot;

import io.debezium.DebeziumException;
import io.debezium.annotation.ConnectorSpecific;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.common.BaseSourceConnector;
import io.debezium.service.spi.ServiceRegistry;
import io.debezium.snapshot.SnapshotQueryProvider;
import io.debezium.snapshot.spi.SnapshotQuery;
import io.debezium.spi.schema.DataCollectionId;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class SnapshotQueryProviderTest {
    @Test
    public void whenBothImplementationHasConnectorSpecificAnnotationTheRightOneWillBeSelected() {
        SnapshotQueryProvider snapshotQueryProvider = new SnapshotQueryProvider(List.of(new SnapshotQueryAnnotatedCustomA(), new SnapshotQueryAnnotatedCustomB()));
        MockedObjects mockedObjects = this.getMockedObjects("myQuery", MyConnectorA.class.getName());
        SnapshotQuery service = snapshotQueryProvider.createService(mockedObjects.configuration, mockedObjects.serviceRegistry);
        Assertions.assertThat((String)service.getClass().getName()).isEqualTo((Object)SnapshotQueryAnnotatedCustomA.class.getName());
    }

    @Test
    public void whenOneImplementationHasConnectorSpecificAnnotationThatMatchTheRunningConnectorItWillBeSelected() {
        SnapshotQueryProvider snapshotQueryProvider = new SnapshotQueryProvider(List.of(new SnapshotQueryCustomA(), new SnapshotQueryAnnotatedCustomB()));
        MockedObjects mockedObjects = this.getMockedObjects("myQuery", MyConnectorB.class.getName());
        SnapshotQuery service = snapshotQueryProvider.createService(mockedObjects.configuration, mockedObjects.serviceRegistry);
        Assertions.assertThat((String)service.getClass().getName()).isEqualTo((Object)SnapshotQueryAnnotatedCustomB.class.getName());
    }

    @Test
    public void whenNoImplementationHasConnectorSpecificAnnotationThenTheFirstNotAnnotatedOneWillBeSelected() {
        SnapshotQueryProvider snapshotQueryProvider = new SnapshotQueryProvider(List.of(new SnapshotQueryCustomA(), new SnapshotQueryCustomB()));
        MockedObjects mockedObjects = this.getMockedObjects("myQuery", MyConnectorB.class.getName());
        SnapshotQuery service = snapshotQueryProvider.createService(mockedObjects.configuration, mockedObjects.serviceRegistry);
        Assertions.assertThat((String)service.getClass().getName()).isEqualTo((Object)SnapshotQueryCustomA.class.getName());
    }

    @Test
    public void whenNoImplementationIsFoundThenAnExceptionIsThrown() {
        SnapshotQueryProvider snapshotQueryProvider = new SnapshotQueryProvider(List.of(new SnapshotQueryCustomA(), new SnapshotQueryCustomB()));
        MockedObjects mockedObjects = this.getMockedObjects("notExisting", MyConnectorB.class.getName());
        Assert.assertThrows(DebeziumException.class, () -> snapshotQueryProvider.createService(mockedObjects.configuration, mockedObjects.serviceRegistry));
    }

    private MockedObjects getMockedObjects(String snapshotMode, String connectorClassName) {
        CommonConnectorConfig commonConnectorConfig = (CommonConnectorConfig)Mockito.mock(CommonConnectorConfig.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        EnumeratedValue enumeratedValue = (EnumeratedValue)Mockito.mock(EnumeratedValue.class);
        Mockito.when((Object)commonConnectorConfig.snapshotQueryMode()).thenReturn((Object)enumeratedValue);
        Mockito.when((Object)commonConnectorConfig.snapshotQueryMode().getValue()).thenReturn((Object)snapshotMode);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString("connector.class")).thenReturn((Object)connectorClassName);
        ServiceRegistry serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        BeanRegistry beanRegistry = (BeanRegistry)Mockito.mock(BeanRegistry.class);
        Mockito.when((Object)((CommonConnectorConfig)beanRegistry.lookupByName("ConnectorConfig", CommonConnectorConfig.class))).thenReturn((Object)commonConnectorConfig);
        Mockito.when((Object)((BeanRegistry)serviceRegistry.tryGetService(BeanRegistry.class))).thenReturn((Object)beanRegistry);
        return new MockedObjects(configuration, serviceRegistry);
    }

    @ConnectorSpecific(connector=MyConnectorA.class)
    private class SnapshotQueryAnnotatedCustomA
    extends AbstractSnapshotQuery {
        private SnapshotQueryAnnotatedCustomA() {
        }

        public String name() {
            return "myQuery";
        }
    }

    @ConnectorSpecific(connector=MyConnectorB.class)
    private class SnapshotQueryAnnotatedCustomB
    extends AbstractSnapshotQuery {
        private SnapshotQueryAnnotatedCustomB() {
        }

        public String name() {
            return "myQuery";
        }
    }

    private class MyConnectorA
    extends BaseSourceConnector {
        private MyConnectorA() {
        }

        protected Map<String, ConfigValue> validateAllFields(Configuration config) {
            return null;
        }

        public <T extends DataCollectionId> List<T> getMatchingCollections(Configuration config) {
            return null;
        }

        public void start(Map<String, String> map) {
        }

        public Class<? extends Task> taskClass() {
            return null;
        }

        public List<Map<String, String>> taskConfigs(int i) {
            return null;
        }

        public void stop() {
        }

        public ConfigDef config() {
            return null;
        }

        public String version() {
            return null;
        }
    }

    private static class MockedObjects {
        public final Configuration configuration;
        public final ServiceRegistry serviceRegistry;

        MockedObjects(Configuration configuration, ServiceRegistry serviceRegistry) {
            this.configuration = configuration;
            this.serviceRegistry = serviceRegistry;
        }
    }

    private class SnapshotQueryCustomA
    extends AbstractSnapshotQuery {
        private SnapshotQueryCustomA() {
        }

        public String name() {
            return "myQuery";
        }
    }

    private class MyConnectorB
    extends BaseSourceConnector {
        private MyConnectorB() {
        }

        protected Map<String, ConfigValue> validateAllFields(Configuration config) {
            return null;
        }

        public <T extends DataCollectionId> List<T> getMatchingCollections(Configuration config) {
            return null;
        }

        public void start(Map<String, String> map) {
        }

        public Class<? extends Task> taskClass() {
            return null;
        }

        public List<Map<String, String>> taskConfigs(int i) {
            return null;
        }

        public void stop() {
        }

        public ConfigDef config() {
            return null;
        }

        public String version() {
            return null;
        }
    }

    private class SnapshotQueryCustomB
    extends AbstractSnapshotQuery {
        private SnapshotQueryCustomB() {
        }

        public String name() {
            return "myQuery";
        }
    }

    private abstract class AbstractSnapshotQuery
    implements SnapshotQuery {
        private AbstractSnapshotQuery() {
        }

        public void configure(Map<String, ?> properties) {
        }

        public Optional<String> snapshotQuery(String tableId, List<String> snapshotSelectColumns) {
            return Optional.empty();
        }
    }
}

