/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.snapshot;

import io.debezium.DebeziumException;
import io.debezium.annotation.ConnectorSpecific;
import io.debezium.bean.spi.BeanRegistry;
import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.common.BaseSourceConnector;
import io.debezium.service.spi.ServiceRegistry;
import io.debezium.snapshot.SnapshotLockProvider;
import io.debezium.snapshot.spi.SnapshotLock;
import io.debezium.spi.schema.DataCollectionId;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigValue;
import org.apache.kafka.connect.connector.Task;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class SnapshotLockProviderTest {
    @Test
    public void whenBothImplementationHasConnectorSpecificAnnotationTheRightOneWillBeSelected() {
        SnapshotLockProvider snapshotLockProvider = new SnapshotLockProvider(List.of(new SnapshotLockAnnotatedCustomA(), new SnapshotLockAnnotatedCustomB()));
        MockedObjects mockedObjects = this.getMockedObjects("myLock", MyConnectorA.class.getName());
        SnapshotLock service = snapshotLockProvider.createService(mockedObjects.configuration, mockedObjects.serviceRegistry);
        Assertions.assertThat((String)service.getClass().getName()).isEqualTo((Object)SnapshotLockAnnotatedCustomA.class.getName());
    }

    @Test
    public void whenOneImplementationHasConnectorSpecificAnnotationThatMatchTheRunningConnectorItWillBeSelected() {
        SnapshotLockProvider snapshotLockProvider = new SnapshotLockProvider(List.of(new SnapshotLockCustomA(), new SnapshotLockAnnotatedCustomB()));
        MockedObjects mockedObjects = this.getMockedObjects("myLock", MyConnectorB.class.getName());
        SnapshotLock service = snapshotLockProvider.createService(mockedObjects.configuration, mockedObjects.serviceRegistry);
        Assertions.assertThat((String)service.getClass().getName()).isEqualTo((Object)SnapshotLockAnnotatedCustomB.class.getName());
    }

    @Test
    public void whenNoImplementationHasConnectorSpecificAnnotationThenTheFirstNotAnnotatedOneWillBeSelected() {
        SnapshotLockProvider snapshotLockProvider = new SnapshotLockProvider(List.of(new SnapshotLockCustomA(), new SnapshotLockCustomB()));
        MockedObjects mockedObjects = this.getMockedObjects("myLock", MyConnectorB.class.getName());
        SnapshotLock service = snapshotLockProvider.createService(mockedObjects.configuration, mockedObjects.serviceRegistry);
        Assertions.assertThat((String)service.getClass().getName()).isEqualTo((Object)SnapshotLockCustomA.class.getName());
    }

    @Test
    public void whenNoImplementationIsFoundThenAnExceptionIsThrown() {
        SnapshotLockProvider snapshotLockProvider = new SnapshotLockProvider(List.of(new SnapshotLockCustomA(), new SnapshotLockCustomB()));
        MockedObjects mockedObjects = this.getMockedObjects("notExisting", MyConnectorB.class.getName());
        Assert.assertThrows(DebeziumException.class, () -> snapshotLockProvider.createService(mockedObjects.configuration, mockedObjects.serviceRegistry));
    }

    private MockedObjects getMockedObjects(String snapshotMode, String connectorClassName) {
        CommonConnectorConfig commonConnectorConfig = (CommonConnectorConfig)Mockito.mock(CommonConnectorConfig.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        EnumeratedValue enumeratedValue = (EnumeratedValue)Mockito.mock(EnumeratedValue.class);
        Mockito.when((Object)commonConnectorConfig.getSnapshotLockingMode()).thenReturn(Optional.of(enumeratedValue));
        Mockito.when((Object)((EnumeratedValue)commonConnectorConfig.getSnapshotLockingMode().get()).getValue()).thenReturn((Object)snapshotMode);
        Configuration configuration = (Configuration)Mockito.mock(Configuration.class);
        Mockito.when((Object)configuration.getString("connector.class")).thenReturn((Object)connectorClassName);
        ServiceRegistry serviceRegistry = (ServiceRegistry)Mockito.mock(ServiceRegistry.class);
        BeanRegistry beanRegistry = (BeanRegistry)Mockito.mock(BeanRegistry.class);
        Mockito.when((Object)((CommonConnectorConfig)beanRegistry.lookupByName("ConnectorConfig", CommonConnectorConfig.class))).thenReturn((Object)commonConnectorConfig);
        Mockito.when((Object)((BeanRegistry)serviceRegistry.tryGetService(BeanRegistry.class))).thenReturn((Object)beanRegistry);
        return new MockedObjects(configuration, serviceRegistry);
    }

    @ConnectorSpecific(connector=MyConnectorA.class)
    private class SnapshotLockAnnotatedCustomA
    extends AbstractSnapshotLock {
        private SnapshotLockAnnotatedCustomA() {
        }

        public String name() {
            return "myLock";
        }
    }

    @ConnectorSpecific(connector=MyConnectorB.class)
    private class SnapshotLockAnnotatedCustomB
    extends AbstractSnapshotLock {
        private SnapshotLockAnnotatedCustomB() {
        }

        public String name() {
            return "myLock";
        }
    }

    private class MyConnectorA
    extends BaseSourceConnector {
        private MyConnectorA() {
        }

        protected Map<String, ConfigValue> validateAllFields(Configuration config) {
            return null;
        }

        public <T extends DataCollectionId> List<T> getMatchingCollections(Configuration config) {
            return null;
        }

        public void start(Map<String, String> map) {
        }

        public Class<? extends Task> taskClass() {
            return null;
        }

        public List<Map<String, String>> taskConfigs(int i) {
            return null;
        }

        public void stop() {
        }

        public ConfigDef config() {
            return null;
        }

        public String version() {
            return null;
        }
    }

    private static class MockedObjects {
        public final Configuration configuration;
        public final ServiceRegistry serviceRegistry;

        MockedObjects(Configuration configuration, ServiceRegistry serviceRegistry) {
            this.configuration = configuration;
            this.serviceRegistry = serviceRegistry;
        }
    }

    private class SnapshotLockCustomA
    extends AbstractSnapshotLock {
        private SnapshotLockCustomA() {
        }

        public String name() {
            return "myLock";
        }
    }

    private class MyConnectorB
    extends BaseSourceConnector {
        private MyConnectorB() {
        }

        protected Map<String, ConfigValue> validateAllFields(Configuration config) {
            return null;
        }

        public <T extends DataCollectionId> List<T> getMatchingCollections(Configuration config) {
            return null;
        }

        public void start(Map<String, String> map) {
        }

        public Class<? extends Task> taskClass() {
            return null;
        }

        public List<Map<String, String>> taskConfigs(int i) {
            return null;
        }

        public void stop() {
        }

        public ConfigDef config() {
            return null;
        }

        public String version() {
            return null;
        }
    }

    private class SnapshotLockCustomB
    extends AbstractSnapshotLock {
        private SnapshotLockCustomB() {
        }

        public String name() {
            return "myLock";
        }
    }

    private abstract class AbstractSnapshotLock
    implements SnapshotLock {
        private AbstractSnapshotLock() {
        }

        public void configure(Map<String, ?> properties) {
        }

        public Optional<String> tableLockingStatement(Duration lockTimeout, String tableId) {
            return Optional.empty();
        }
    }
}

