/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.DebeziumException;
import io.debezium.data.Envelope;
import io.debezium.data.VerifyRecord;
import io.debezium.junit.logging.LogInterceptor;
import io.debezium.time.Date;
import io.debezium.time.MicroTimestamp;
import io.debezium.time.NanoTimestamp;
import io.debezium.time.Timestamp;
import io.debezium.time.ZonedTime;
import io.debezium.time.ZonedTimestamp;
import io.debezium.transforms.TimezoneConverter;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.HashMap;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.AssertionsForClassTypes;
import org.junit.Test;

public class TimezoneConverterTest {
    private final TimezoneConverter<SourceRecord> converter = new TimezoneConverter();
    protected final Schema sourceSchema = SchemaBuilder.struct().optional().field("table", Schema.STRING_SCHEMA).field("lsn", Schema.INT32_SCHEMA).field("ts_ms", Schema.OPTIONAL_INT32_SCHEMA).build();
    protected final Schema recordSchema = SchemaBuilder.struct().optional().field("id", Schema.INT8_SCHEMA).field("name", Schema.STRING_SCHEMA).field("order_date", Date.builder().optional().build()).field("ship_date", Date.builder().optional().build()).field("order_date_micros", MicroTimestamp.builder().optional().build()).field("order_date_nanos", NanoTimestamp.builder().optional().build()).field("order_date_timestamp", Timestamp.builder().optional().build()).field("order_date_zoned_timestamp", ZonedTimestamp.builder().optional().build()).field("shipping_date_zoned_timestamp", ZonedTimestamp.builder().optional().build()).field("order_date_zoned_time", ZonedTime.builder().optional().build()).field("order_date_kc_timestamp", org.apache.kafka.connect.data.Timestamp.builder().optional().build()).build();

    @Test
    public void testMultipleDebeziumTimestamps() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "+05:30");
        this.converter.configure(props);
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"Srikanth");
        before.put("order_date_micros", (Object)1529507596945104L);
        before.put("order_date_nanos", (Object)1531481025340000104L);
        before.put("order_date_timestamp", (Object)1514908810123L);
        before.put("order_date_zoned_timestamp", (Object)"2018-01-02T11:15:30.123456789+00:00");
        before.put("order_date_zoned_time", (Object)"11:15:30.123456789+00:00");
        source.put("table", (Object)"orders");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)123456789);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)before, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record);
        SourceRecord transformedRecord = (SourceRecord)this.converter.apply((ConnectRecord)record);
        VerifyRecord.isValid(transformedRecord);
        Struct transformedValue = (Struct)transformedRecord.value();
        Struct transformedAfter = transformedValue.getStruct("after");
        Struct transformedSource = transformedValue.getStruct("source");
        Assertions.assertThat((Object)transformedAfter.get("order_date_micros")).isEqualTo((Object)1529487796945104L);
        Assertions.assertThat((Object)transformedAfter.get("order_date_nanos")).isEqualTo((Object)1531461225340000104L);
        Assertions.assertThat((Object)transformedAfter.get("order_date_timestamp")).isEqualTo((Object)1514889010123L);
        Assertions.assertThat((Object)transformedAfter.get("order_date_zoned_timestamp")).isEqualTo((Object)"2018-01-02T16:45:30.123456789+05:30");
        Assertions.assertThat((Object)transformedAfter.get("order_date_zoned_time")).isEqualTo((Object)"16:45:30.123456789+05:30");
        Assertions.assertThat((Object)transformedSource.get("table")).isEqualTo((Object)"orders");
        Assertions.assertThat((Object)transformedSource.get("ts_ms")).isEqualTo((Object)123456789);
    }

    @Test
    public void testSingleDebeziumTimestamp() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "Pacific/Easter");
        this.converter.configure(props);
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"Srikanth");
        before.put("order_date_zoned_timestamp", (Object)"2011-01-11T16:40:30.123456789+00:00");
        before.put("shipping_date_zoned_timestamp", (Object)"2011-02-02T11:04:30.123456789+00:00");
        source.put("table", (Object)"orders");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)123456789);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)before, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record);
        SourceRecord transformedRecord = (SourceRecord)this.converter.apply((ConnectRecord)record);
        VerifyRecord.isValid(transformedRecord);
        Struct transformedValue = (Struct)transformedRecord.value();
        Struct transformedAfter = transformedValue.getStruct("after");
        Assertions.assertThat((Object)transformedAfter.get("order_date_zoned_timestamp")).isEqualTo((Object)"2011-01-11T11:40:30.123456789-05:00");
        Assertions.assertThat((Object)transformedAfter.get("shipping_date_zoned_timestamp")).isEqualTo((Object)"2011-02-02T06:04:30.123456789-05:00");
    }

    @Test
    public void testKafkaConnectTimestamp() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "Africa/Cairo");
        this.converter.configure(props);
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"Pierre Wright");
        before.put("order_date_kc_timestamp", (Object)java.util.Date.from(LocalDateTime.of(2018, 3, 27, 2, 0, 0).toInstant(ZoneOffset.UTC)));
        source.put("table", (Object)"orders");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)123456789);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)before, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record);
        SourceRecord transformedRecord = (SourceRecord)this.converter.apply((ConnectRecord)record);
        VerifyRecord.isValid(transformedRecord);
        Struct transformedValue = (Struct)transformedRecord.value();
        Struct transformedAfter = transformedValue.getStruct("after");
        Assertions.assertThat((Object)transformedAfter.get("order_date_kc_timestamp")).isInstanceOf(java.util.Date.class);
        Assertions.assertThat((Object)transformedAfter.get("order_date_kc_timestamp")).isEqualTo((Object)java.util.Date.from(LocalDateTime.of(2018, 3, 27, 0, 0, 0).toInstant(ZoneOffset.UTC)));
    }

    @Test
    public void testIncludeListWithTablePrefix() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "Atlantic/Azores");
        props.put("include.list", "source:customers:after.order_date_zoned_timestamp");
        this.converter.configure(props);
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"John Doe");
        before.put("order_date_zoned_timestamp", (Object)"2020-01-01T11:55:30+00:00");
        before.put("shipping_date_zoned_timestamp", (Object)"2020-05-01T11:55:30+00:00");
        source.put("table", (Object)"customers");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)123456789);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)before, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record);
        SourceRecord transformedRecord = (SourceRecord)this.converter.apply((ConnectRecord)record);
        VerifyRecord.isValid(transformedRecord);
        Struct transformedValue = (Struct)transformedRecord.value();
        Struct transformedAfter = transformedValue.getStruct("after");
        Assertions.assertThat((Object)transformedAfter.get("order_date_zoned_timestamp")).isEqualTo((Object)"2020-01-01T10:55:30-01:00");
        Assertions.assertThat((Object)transformedAfter.get("shipping_date_zoned_timestamp")).isEqualTo((Object)"2020-05-01T11:55:30+00:00");
    }

    @Test
    public void testIncludeListWithTopicPrefix() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "+05:30");
        props.put("include.list", "topic:db.server1.table1:order_date_zoned_time");
        this.converter.configure(props);
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"John Doe");
        before.put("order_date_zoned_time", (Object)"11:55:30+00:00");
        source.put("table", (Object)"customers");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)123456789);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)before, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record);
        SourceRecord transformedRecord = (SourceRecord)this.converter.apply((ConnectRecord)record);
        VerifyRecord.isValid(transformedRecord);
        Struct transformedValue = (Struct)transformedRecord.value();
        Struct transformedAfter = transformedValue.getStruct("after");
        Assertions.assertThat((Object)transformedAfter.get("order_date_zoned_time")).isEqualTo((Object)"17:25:30+05:30");
    }

    @Test
    public void testIncludeListWithNoPrefix() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "Asia/Kolkata");
        props.put("include.list", "db.server1.table1:order_date_zoned_time");
        this.converter.configure(props);
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"John Doe");
        before.put("order_date_zoned_time", (Object)"11:55:30+00:00");
        source.put("table", (Object)"customers");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)123456789);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)before, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record);
        SourceRecord transformedRecord = (SourceRecord)this.converter.apply((ConnectRecord)record);
        VerifyRecord.isValid(transformedRecord);
        Struct transformedValue = (Struct)transformedRecord.value();
        Struct transformedAfter = transformedValue.getStruct("after");
        Assertions.assertThat((Object)transformedAfter.get("order_date_zoned_time")).isEqualTo((Object)"17:25:30+05:30");
    }

    @Test
    public void testExcludeListWithTablePrefix() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "+05:30");
        props.put("exclude.list", "source:customers:order_date_zoned_timestamp");
        this.converter.configure(props);
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"John Doe");
        before.put("order_date_zoned_time", (Object)"11:55:30+00:00");
        source.put("table", (Object)"customers");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)123456789);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)before, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record);
        SourceRecord transformedRecord = (SourceRecord)this.converter.apply((ConnectRecord)record);
        VerifyRecord.isValid(transformedRecord);
        Struct transformedValue = (Struct)transformedRecord.value();
        Struct transformedAfter = transformedValue.getStruct("after");
        Assertions.assertThat((Object)transformedAfter.get("order_date_zoned_time")).isEqualTo((Object)"17:25:30+05:30");
    }

    @Test
    public void testExcludeListWithTopicPrefix() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "America/Chicago");
        props.put("exclude.list", "topic:db.server1.table1:order_date_zoned_time");
        this.converter.configure(props);
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"John Doe");
        before.put("order_date_zoned_time", (Object)"11:55:30+00:00");
        before.put("order_date", (Object)Date.toEpochDay((Object)LocalDate.parse("2016-11-04"), null));
        source.put("table", (Object)"customers");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)123456789);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)before, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record);
        SourceRecord transformedRecord = (SourceRecord)this.converter.apply((ConnectRecord)record);
        VerifyRecord.isValid(transformedRecord);
        Struct transformedValue = (Struct)transformedRecord.value();
        Struct transformedAfter = transformedValue.getStruct("after");
        Assertions.assertThat((Object)transformedAfter.get("order_date_zoned_time")).isEqualTo((Object)"11:55:30+00:00");
        Assertions.assertThat((Object)transformedAfter.get("order_date")).isEqualTo((Object)Date.toEpochDay((Object)LocalDate.parse("2016-11-04"), null));
    }

    @Test
    public void testExcludeListWithNoPrefix() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "+08:00:00");
        props.put("exclude.list", "db.server1.table1:ship_date");
        this.converter.configure(props);
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"John Doe");
        before.put("order_date_zoned_time", (Object)"11:55:30+00:00");
        source.put("table", (Object)"customers");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)123456789);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)before, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record);
        SourceRecord transformedRecord = (SourceRecord)this.converter.apply((ConnectRecord)record);
        VerifyRecord.isValid(transformedRecord);
        Struct transformedValue = (Struct)transformedRecord.value();
        Struct transformedAfter = transformedValue.getStruct("after");
        Assertions.assertThat((Object)transformedAfter.get("order_date_zoned_time")).isEqualTo((Object)"19:55:30+08:00");
    }

    @Test
    public void testIncludeListMultipleTables() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "+03:00");
        props.put("include.list", "source:customers1,orders1,public1");
        this.converter.configure(props);
        Struct customersBefore = new Struct(this.recordSchema);
        Struct customersSource = new Struct(this.sourceSchema);
        customersBefore.put("id", (Object)1);
        customersBefore.put("name", (Object)"John Doe");
        customersBefore.put("order_date_zoned_timestamp", (Object)"2020-01-01T11:55:30+00:00");
        customersBefore.put("shipping_date_zoned_timestamp", (Object)"2020-01-01T15:40:10+00:00");
        customersSource.put("table", (Object)"customers1");
        customersSource.put("lsn", (Object)1);
        customersSource.put("ts_ms", (Object)123456789);
        Envelope customersEnvelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct customersPayload = customersEnvelope.create((Object)customersBefore, customersSource, Instant.now());
        SourceRecord customersRecord = new SourceRecord(new HashMap(), new HashMap(), "db.server1.customers", customersEnvelope.schema(), (Object)customersPayload);
        VerifyRecord.isValid(customersRecord);
        SourceRecord transformedCustomersRecord = (SourceRecord)this.converter.apply((ConnectRecord)customersRecord);
        VerifyRecord.isValid(transformedCustomersRecord);
        Struct transformedCustomersValue = (Struct)transformedCustomersRecord.value();
        Struct transformedCustomersAfter = transformedCustomersValue.getStruct("after");
        Assertions.assertThat((Object)transformedCustomersAfter.get("order_date_zoned_timestamp")).isEqualTo((Object)"2020-01-01T14:55:30+03:00");
        Assertions.assertThat((Object)transformedCustomersAfter.get("shipping_date_zoned_timestamp")).isEqualTo((Object)"2020-01-01T18:40:10+03:00");
        Struct ordersBefore = new Struct(this.recordSchema);
        Struct ordersSource = new Struct(this.sourceSchema);
        ordersBefore.put("id", (Object)1);
        ordersBefore.put("name", (Object)"John Doe");
        ordersBefore.put("order_date_zoned_timestamp", (Object)"2023-08-01T11:50:45+00:00");
        ordersBefore.put("shipping_date_zoned_timestamp", (Object)"2023-09-01T11:55:30+00:00");
        ordersSource.put("table", (Object)"orders1");
        ordersSource.put("lsn", (Object)1);
        ordersSource.put("ts_ms", (Object)123456789);
        Envelope ordersEnvelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct ordersPayload = ordersEnvelope.create((Object)ordersBefore, ordersSource, Instant.now());
        SourceRecord ordersRecord = new SourceRecord(new HashMap(), new HashMap(), "db.server1.orders", ordersEnvelope.schema(), (Object)ordersPayload);
        VerifyRecord.isValid(ordersRecord);
        SourceRecord transformedOrdersRecord = (SourceRecord)this.converter.apply((ConnectRecord)ordersRecord);
        VerifyRecord.isValid(transformedOrdersRecord);
        Struct transformedOrdersValue = (Struct)transformedOrdersRecord.value();
        Struct transformedOrdersAfter = transformedOrdersValue.getStruct("after");
        Assertions.assertThat((Object)transformedOrdersAfter.get("order_date_zoned_timestamp")).isEqualTo((Object)"2023-08-01T14:50:45+03:00");
        Assertions.assertThat((Object)transformedOrdersAfter.get("shipping_date_zoned_timestamp")).isEqualTo((Object)"2023-09-01T14:55:30+03:00");
    }

    @Test
    public void testExcludeListMultipleTables() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "-06:00");
        props.put("exclude.list", "topic:db.server1.customers,db.server1.public");
        this.converter.configure(props);
        Struct customersBefore = new Struct(this.recordSchema);
        Struct customersSource = new Struct(this.sourceSchema);
        customersBefore.put("id", (Object)1);
        customersBefore.put("name", (Object)"John Doe");
        customersBefore.put("order_date_zoned_timestamp", (Object)"2020-01-01T11:55:30+00:00");
        customersBefore.put("shipping_date_zoned_timestamp", (Object)"2020-01-01T15:40:10+00:00");
        customersSource.put("table", (Object)"customers1");
        customersSource.put("lsn", (Object)1);
        customersSource.put("ts_ms", (Object)123456789);
        Envelope customersEnvelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct customersPayload = customersEnvelope.create((Object)customersBefore, customersSource, Instant.now());
        SourceRecord customersRecord = new SourceRecord(new HashMap(), new HashMap(), "db.server1.customers", customersEnvelope.schema(), (Object)customersPayload);
        VerifyRecord.isValid(customersRecord);
        SourceRecord transformedCustomersRecord = (SourceRecord)this.converter.apply((ConnectRecord)customersRecord);
        VerifyRecord.isValid(transformedCustomersRecord);
        Struct transformedCustomersValue = (Struct)transformedCustomersRecord.value();
        Struct transformedCustomersAfter = transformedCustomersValue.getStruct("after");
        Assertions.assertThat((Object)transformedCustomersAfter.get("order_date_zoned_timestamp")).isEqualTo((Object)"2020-01-01T11:55:30+00:00");
        Assertions.assertThat((Object)transformedCustomersAfter.get("shipping_date_zoned_timestamp")).isEqualTo((Object)"2020-01-01T15:40:10+00:00");
        Struct ordersBefore = new Struct(this.recordSchema);
        Struct ordersSource = new Struct(this.sourceSchema);
        ordersBefore.put("id", (Object)1);
        ordersBefore.put("name", (Object)"John Doe");
        ordersBefore.put("order_date_zoned_timestamp", (Object)"2023-08-01T11:50:45+00:00");
        ordersBefore.put("shipping_date_zoned_timestamp", (Object)"2023-09-01T11:55:30+00:00");
        ordersSource.put("table", (Object)"orders1");
        ordersSource.put("lsn", (Object)1);
        ordersSource.put("ts_ms", (Object)123456789);
        Envelope ordersEnvelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct ordersPayload = ordersEnvelope.create((Object)ordersBefore, ordersSource, Instant.now());
        SourceRecord ordersRecord = new SourceRecord(new HashMap(), new HashMap(), "db.server1.orders", ordersEnvelope.schema(), (Object)ordersPayload);
        VerifyRecord.isValid(ordersRecord);
        SourceRecord transformedOrdersRecord = (SourceRecord)this.converter.apply((ConnectRecord)ordersRecord);
        VerifyRecord.isValid(transformedOrdersRecord);
        Struct transformedOrdersValue = (Struct)transformedOrdersRecord.value();
        Struct transformedOrdersAfter = transformedOrdersValue.getStruct("after");
        Assertions.assertThat((Object)transformedOrdersAfter.get("order_date_zoned_timestamp")).isEqualTo((Object)"2023-08-01T05:50:45-06:00");
        Assertions.assertThat((Object)transformedOrdersAfter.get("shipping_date_zoned_timestamp")).isEqualTo((Object)"2023-09-01T05:55:30-06:00");
    }

    @Test
    public void testBothIncludeExcludeList() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "+05:30");
        props.put("include.list", "topic:db.server1.customers,db.server1.public");
        props.put("exclude.list", "topic:db.server1.customers,db.server1.public");
        Assertions.assertThat((Throwable)AssertionsForClassTypes.catchThrowable(() -> this.converter.configure(props))).isInstanceOf(DebeziumException.class);
        Assertions.assertThat((Throwable)AssertionsForClassTypes.catchThrowable(() -> this.converter.configure(props))).hasMessageContaining("Both include and exclude lists are specified. Please specify only one.");
    }

    @Test
    public void testWithNoConfig() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("include.list", "topic:db.server1.customers");
        Assertions.assertThat((Throwable)AssertionsForClassTypes.catchThrowable(() -> this.converter.configure(props))).isInstanceOf(ConfigException.class);
        Assertions.assertThat((Throwable)AssertionsForClassTypes.catchThrowable(() -> this.converter.configure(props))).hasMessageContaining("Invalid value null for configuration converted.timezone: The 'converted.timezone' value is invalid: A value is required");
    }

    @Test
    public void testWithInvalidConfig() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "Asia");
        props.put("include.list", "topic:db.server1.customers");
        Assertions.assertThat((Throwable)AssertionsForClassTypes.catchThrowable(() -> this.converter.configure(props))).isInstanceOf(DebeziumException.class);
        Assertions.assertThat((Throwable)AssertionsForClassTypes.catchThrowable(() -> this.converter.configure(props))).hasMessageContaining("Invalid timezone format. Please specify either a geographic timezone (e.g. America/Los_Angeles) or a UTC offset in the format of +/-hh:mm, (e.g. +08:00).");
    }

    @Test
    public void testExcludeListWithMultipleFields() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "Europe/Moscow");
        props.put("exclude.list", "topic:db.server1.customers:order_date_zoned_time,db.server1.inventory:order_date");
        this.converter.configure(props);
        Struct customersBefore = new Struct(this.recordSchema);
        customersBefore.put("id", (Object)1);
        customersBefore.put("name", (Object)"Amy Rose");
        customersBefore.put("order_date_zoned_time", (Object)"10:19:25+00:00");
        Struct customersSource = new Struct(this.sourceSchema);
        customersSource.put("table", (Object)"customers");
        customersSource.put("lsn", (Object)1);
        customersSource.put("ts_ms", (Object)123456789);
        Envelope customersEnvelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct customersPayload = customersEnvelope.create((Object)customersBefore, customersSource, Instant.now());
        SourceRecord customersRecord = new SourceRecord(new HashMap(), new HashMap(), "db.server1.customers", customersEnvelope.schema(), (Object)customersPayload);
        VerifyRecord.isValid(customersRecord);
        SourceRecord transformedCustomersRecord = (SourceRecord)this.converter.apply((ConnectRecord)customersRecord);
        VerifyRecord.isValid(transformedCustomersRecord);
        Struct transformedCustomersValue = (Struct)transformedCustomersRecord.value();
        Struct transformedCustomersAfter = transformedCustomersValue.getStruct("after");
        Assertions.assertThat((Object)transformedCustomersAfter.get("name")).isEqualTo((Object)"Amy Rose");
        Assertions.assertThat((Object)transformedCustomersAfter.get("order_date_zoned_time")).isEqualTo((Object)"10:19:25+00:00");
        Struct inventoryBefore = new Struct(this.recordSchema);
        inventoryBefore.put("id", (Object)1);
        inventoryBefore.put("name", (Object)"Amy Rose");
        inventoryBefore.put("order_date_zoned_time", (Object)"19:19:25+00:00");
        Struct inventorySource = new Struct(this.sourceSchema);
        inventorySource.put("table", (Object)"inventory");
        inventorySource.put("lsn", (Object)1);
        inventorySource.put("ts_ms", (Object)123456789);
        Envelope inventoryEnvelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct inventoryPayload = inventoryEnvelope.create((Object)inventoryBefore, inventorySource, Instant.now());
        SourceRecord inventoryRecord = new SourceRecord(new HashMap(), new HashMap(), "db.server1.inventory", inventoryEnvelope.schema(), (Object)inventoryPayload);
        VerifyRecord.isValid(inventoryRecord);
        SourceRecord transformedInventoryRecord = (SourceRecord)this.converter.apply((ConnectRecord)inventoryRecord);
        VerifyRecord.isValid(transformedInventoryRecord);
        Struct transformedInventoryValue = (Struct)transformedInventoryRecord.value();
        Struct transformedInventoryAfter = transformedInventoryValue.getStruct("after");
        Assertions.assertThat((Object)transformedInventoryAfter.get("name")).isEqualTo((Object)"Amy Rose");
        Assertions.assertThat((Object)transformedInventoryAfter.get("order_date_zoned_time")).isEqualTo((Object)"22:19:25+03:00");
    }

    @Test
    public void testDayLightSavings() {
        String withDayLightSavingsInstant = "2014-06-22T10:15:30Z";
        String withoutDayLightSavingsInstant = "2014-12-22T10:15:30Z";
        Clock clockWithDayLightSavings = Clock.fixed(Instant.parse(withDayLightSavingsInstant), ZoneId.of("UTC"));
        Clock clockWithoutDayLightSavings = Clock.fixed(Instant.parse(withoutDayLightSavingsInstant), ZoneId.of("UTC"));
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "Europe/Paris");
        this.converter.configure(props);
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"Amy Rose");
        before.put("order_date_zoned_timestamp", (Object)Instant.now(clockWithDayLightSavings).toString());
        before.put("shipping_date_zoned_timestamp", (Object)Instant.now(clockWithoutDayLightSavings).toString());
        source.put("table", (Object)"customers");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)123456789);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)before, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record);
        SourceRecord transformedRecord = (SourceRecord)this.converter.apply((ConnectRecord)record);
        VerifyRecord.isValid(transformedRecord);
        Struct transformedValue = (Struct)transformedRecord.value();
        Struct transformedAfter = transformedValue.getStruct("after");
        Assertions.assertThat((Object)transformedAfter.get("order_date_zoned_timestamp")).isEqualTo((Object)"2014-06-22T12:15:30+02:00");
        Assertions.assertThat((Object)transformedAfter.get("shipping_date_zoned_timestamp")).isEqualTo((Object)"2014-12-22T11:15:30+01:00");
    }

    @Test
    public void testUnsupportedLogicalTypes() {
        LogInterceptor logInterceptor = new LogInterceptor(TimezoneConverter.class);
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "Europe/Moscow");
        props.put("include.list", "source:customers:order_date");
        this.converter.configure(props);
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"Amy Rose");
        before.put("order_date", (Object)Date.toEpochDay((Object)LocalDate.parse("2016-11-04"), null));
        before.put("ship_date", (Object)Date.toEpochDay((Object)LocalDate.parse("2016-11-06"), null));
        source.put("table", (Object)"customers");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)123456789);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)before, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record);
        this.converter.apply((ConnectRecord)record);
        Assertions.assertThat((boolean)logInterceptor.containsMessage("Skipping conversion for unsupported logical type: io.debezium.time.Date for field: order_date")).isTrue();
    }

    @Test
    public void testSourceBlockTimestamp() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("converted.timezone", "Europe/Moscow");
        props.put("include.list", "source:customers:source.ts_ms");
        this.converter.configure(props);
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"Amy Rose");
        before.put("order_date_zoned_time", (Object)"11:15:30.123456789+00:00");
        source.put("table", (Object)"customers");
        source.put("lsn", (Object)1);
        source.put("ts_ms", (Object)123456789);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();
        Struct payload = envelope.create((Object)before, source, Instant.now());
        SourceRecord record = new SourceRecord(new HashMap(), new HashMap(), "db.server1.table1", envelope.schema(), (Object)payload);
        VerifyRecord.isValid(record);
        SourceRecord transformedRecord = (SourceRecord)this.converter.apply((ConnectRecord)record);
        VerifyRecord.isValid(transformedRecord);
        Struct transformedValue = (Struct)transformedRecord.value();
        Struct transformedSource = transformedValue.getStruct("source");
        Struct transformedAfter = transformedValue.getStruct("after");
        Assertions.assertThat((Object)transformedSource.get("ts_ms")).isEqualTo((Object)123456789);
        Assertions.assertThat((Object)transformedAfter.get("order_date_zoned_time")).isEqualTo((Object)"11:15:30.123456789+00:00");
    }
}

