/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source.snapshot.incremental;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.EnumeratedValue;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.jdbc.JdbcConfiguration;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.source.snapshot.incremental.ChunkQueryBuilder;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.RowValueConstructorChunkQueryBuilder;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import java.util.List;
import java.util.Optional;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class RowValueConstructorChunkQueryBuilderTest {
    protected RelationalDatabaseConnectorConfig config() {
        return this.buildConfig(((Configuration.Builder)((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.SIGNAL_DATA_COLLECTION, "debezium.signal")).with(RelationalDatabaseConnectorConfig.TOPIC_PREFIX, "core")).build());
    }

    protected RelationalDatabaseConnectorConfig buildConfig(Configuration configuration) {
        return new RelationalDatabaseConnectorConfig(configuration, null, null, 0, ColumnFilterMode.CATALOG, true){

            protected SourceInfoStructMaker<?> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
                return null;
            }

            public String getContextName() {
                return null;
            }

            public String getConnectorName() {
                return null;
            }

            public EnumeratedValue getSnapshotMode() {
                return null;
            }

            public Optional<EnumeratedValue> getSnapshotLockingMode() {
                return Optional.empty();
            }
        };
    }

    @Test
    public void testBuildQueryOnePkColumn() {
        RowValueConstructorChunkQueryBuilder chunkQueryBuilder = new RowValueConstructorChunkQueryBuilder(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""));
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        Column pk1 = Column.editor().name("pk1").optional(false).create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1"}).create();
        Assertions.assertThat((String)chunkQueryBuilder.buildChunkQuery((IncrementalSnapshotContext)context, table, Optional.empty())).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" ORDER BY \"pk1\" LIMIT 1024");
        context.nextChunkPosition(new Object[]{1});
        context.maximumKey(new Object[]{10});
        Assertions.assertThat((String)chunkQueryBuilder.buildChunkQuery((IncrementalSnapshotContext)context, table, Optional.empty())).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE \"pk1\" > ? AND \"pk1\" <= ? ORDER BY \"pk1\" LIMIT 1024");
    }

    @Test
    public void testBuildQueryOnePkColumnWithAdditionalCondition() {
        RowValueConstructorChunkQueryBuilder chunkQueryBuilder = new RowValueConstructorChunkQueryBuilder(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""));
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        Column pk1 = Column.editor().name("pk1").optional(false).create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1"}).create();
        Assertions.assertThat((String)chunkQueryBuilder.buildChunkQuery((IncrementalSnapshotContext)context, table, Optional.of("\"val1\"=foo"))).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE \"val1\"=foo ORDER BY \"pk1\" LIMIT 1024");
        context.nextChunkPosition(new Object[]{1});
        context.maximumKey(new Object[]{10});
        Assertions.assertThat((String)chunkQueryBuilder.buildChunkQuery((IncrementalSnapshotContext)context, table, Optional.of("\"val1\"=foo"))).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE \"pk1\" > ? AND \"pk1\" <= ? AND \"val1\"=foo ORDER BY \"pk1\" LIMIT 1024");
    }

    @Test
    public void testBuildQueryTwoPkColumnsWithAdditionalConditionWithSurrogateKey() {
        RowValueConstructorChunkQueryBuilder chunkQueryBuilder = new RowValueConstructorChunkQueryBuilder(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""));
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        Column pk1 = Column.editor().name("pk1").optional(false).create();
        Column pk2 = Column.editor().name("pk2").optional(false).create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(pk2).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1", "pk2"}).create();
        context.addDataCollectionNamesToSnapshot("12345", List.of(table.id().toString()), List.of(), "pk2");
        Assertions.assertThat((String)chunkQueryBuilder.buildChunkQuery((IncrementalSnapshotContext)context, table, Optional.of("\"val1\"=foo"))).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE \"val1\"=foo ORDER BY \"pk2\" LIMIT 1024");
        context.nextChunkPosition(new Object[]{1});
        context.maximumKey(new Object[]{10});
        Assertions.assertThat((String)chunkQueryBuilder.buildChunkQuery((IncrementalSnapshotContext)context, table, Optional.of("\"val1\"=foo"))).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE \"pk2\" > ? AND \"pk2\" <= ? AND \"val1\"=foo ORDER BY \"pk2\" LIMIT 1024");
    }

    @Test
    public void testBuildQueryThreePkColumns() {
        RowValueConstructorChunkQueryBuilder chunkQueryBuilder = new RowValueConstructorChunkQueryBuilder(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""));
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        Column pk1 = Column.editor().name("pk1").optional(false).create();
        Column pk2 = Column.editor().name("pk2").optional(false).create();
        Column pk3 = Column.editor().name("pk3").optional(false).create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(pk2).addColumn(pk3).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1", "pk2", "pk3"}).create();
        Assertions.assertThat((String)chunkQueryBuilder.buildChunkQuery((IncrementalSnapshotContext)context, table, Optional.empty())).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" ORDER BY \"pk1\", \"pk2\", \"pk3\" LIMIT 1024");
        context.nextChunkPosition(new Object[]{1, 5, 3});
        context.maximumKey(new Object[]{10, 50, 30});
        Assertions.assertThat((String)chunkQueryBuilder.buildChunkQuery((IncrementalSnapshotContext)context, table, Optional.empty())).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE ROW(\"pk1\", \"pk2\", \"pk3\") > ROW(?, ?, ?) AND ROW(\"pk1\", \"pk2\", \"pk3\") <= ROW(?, ?, ?) ORDER BY \"pk1\", \"pk2\", \"pk3\" LIMIT 1024");
    }

    @Test
    public void testBuildQueryThreePkColumnsWithAdditionalCondition() {
        RowValueConstructorChunkQueryBuilder chunkQueryBuilder = new RowValueConstructorChunkQueryBuilder(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""));
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        Column pk1 = Column.editor().name("pk1").optional(false).create();
        Column pk2 = Column.editor().name("pk2").optional(false).create();
        Column pk3 = Column.editor().name("pk3").optional(false).create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(pk2).addColumn(pk3).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1", "pk2", "pk3"}).create();
        Assertions.assertThat((String)chunkQueryBuilder.buildChunkQuery((IncrementalSnapshotContext)context, table, Optional.of("\"val1\"=foo"))).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE \"val1\"=foo ORDER BY \"pk1\", \"pk2\", \"pk3\" LIMIT 1024");
        context.nextChunkPosition(new Object[]{1, 5, 3});
        context.maximumKey(new Object[]{10, 50, 30});
        Assertions.assertThat((String)chunkQueryBuilder.buildChunkQuery((IncrementalSnapshotContext)context, table, Optional.of("\"val1\"=foo"))).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE ROW(\"pk1\", \"pk2\", \"pk3\") > ROW(?, ?, ?) AND ROW(\"pk1\", \"pk2\", \"pk3\") <= ROW(?, ?, ?) AND \"val1\"=foo ORDER BY \"pk1\", \"pk2\", \"pk3\" LIMIT 1024");
    }

    @Test
    public void testBuildQueryOptionalThrowsUnsupported() {
        RelationalDatabaseConnectorConfig config = this.buildConfig(((Configuration.Builder)this.config().getJdbcConfig().edit().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "s1.table1:pk1")).build());
        RowValueConstructorChunkQueryBuilder chunkQueryBuilder = new RowValueConstructorChunkQueryBuilder(config, new JdbcConnection(config.getJdbcConfig(), c -> null, "\"", "\""));
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        Column pk1 = Column.editor().name("pk1").optional(true).create();
        Column val1 = Column.editor().name("val1").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(val1).create();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> RowValueConstructorChunkQueryBuilderTest.lambda$testBuildQueryOptionalThrowsUnsupported$6((ChunkQueryBuilder)chunkQueryBuilder, (IncrementalSnapshotContext)context, table)).isInstanceOf(UnsupportedOperationException.class)).hasMessage("The sort order of NULL values in the incremental snapshot key is unknown.");
    }

    @Test
    public void testBuildQueryOptionalKeysNulls() {
        RelationalDatabaseConnectorConfig config = this.buildConfig(((Configuration.Builder)this.config().getJdbcConfig().edit().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "s1.table1:pk1,pk2,pk3")).build());
        RowValueConstructorChunkQueryBuilder chunkQueryBuilder = new RowValueConstructorChunkQueryBuilder(config, (JdbcConnection)new NullHandlingJdbcConnection(config.getJdbcConfig(), c -> null, "\"", "\"", false));
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        Column pk1 = Column.editor().name("pk1").optional(true).create();
        Column pk2 = Column.editor().name("pk2").optional(true).create();
        Column pk3 = Column.editor().name("pk3").optional(false).create();
        Column val1 = Column.editor().name("val1").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(pk2).addColumn(pk3).addColumn(val1).create();
        Assertions.assertThat((String)chunkQueryBuilder.buildChunkQuery((IncrementalSnapshotContext)context, table, Optional.empty())).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" ORDER BY \"pk1\", \"pk2\", \"pk3\" LIMIT 1024");
        context.nextChunkPosition(new Object[]{1, 5, 3});
        context.maximumKey(new Object[]{10, 50, 30});
        Assertions.assertThat((String)chunkQueryBuilder.buildChunkQuery((IncrementalSnapshotContext)context, table, Optional.empty())).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE (((\"pk1\" > ? AND \"pk1\" IS NOT NULL)) OR (\"pk1\" = ? AND (\"pk2\" > ? AND \"pk2\" IS NOT NULL)) OR (\"pk1\" = ? AND \"pk2\" = ? AND \"pk3\" > ?)) AND NOT (((\"pk1\" > ? AND \"pk1\" IS NOT NULL)) OR (\"pk1\" = ? AND (\"pk2\" > ? AND \"pk2\" IS NOT NULL)) OR (\"pk1\" = ? AND \"pk2\" = ? AND \"pk3\" > ?)) ORDER BY \"pk1\", \"pk2\", \"pk3\" LIMIT 1024");
    }

    private static /* synthetic */ void lambda$testBuildQueryOptionalThrowsUnsupported$6(ChunkQueryBuilder chunkQueryBuilder, IncrementalSnapshotContext context, Table table) throws Throwable {
        chunkQueryBuilder.buildChunkQuery(context, table, Optional.empty());
    }

    protected static class NullHandlingJdbcConnection
    extends JdbcConnection {
        private final boolean nullsLast;

        public NullHandlingJdbcConnection(JdbcConfiguration config, JdbcConnection.ConnectionFactory connectionFactory, String openingQuoteCharacter, String closingQuoteCharacter, boolean nullsLast) {
            super(config, connectionFactory, openingQuoteCharacter, closingQuoteCharacter);
            this.nullsLast = nullsLast;
        }

        public Optional<Boolean> nullsSortLast() {
            return Optional.of(this.nullsLast);
        }
    }
}

