/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.util.Clock;
import io.debezium.util.ElapsedTimeStrategy;
import io.debezium.util.MockClock;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicBoolean;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ElapsedTimeStrategyTest {
    private ElapsedTimeStrategy delay;
    private MockClock clock;

    @Before
    public void beforeEach() {
        this.clock = new MockClock();
    }

    @Test
    public void testConstantDelay() {
        this.clock.advanceTo(100L);
        this.delay = ElapsedTimeStrategy.constant((Clock)this.clock, (long)10L);
        this.assertNotElapsed();
        this.assertNotElapsed();
        this.clock.advanceTo(109L);
        this.assertNotElapsed();
        this.clock.advanceTo(110L);
        this.assertElapsed();
        this.clock.advanceTo(119L);
        this.assertNotElapsed();
        this.clock.advanceTo(128L);
        this.assertElapsed();
        this.clock.advanceTo(130L);
        this.assertElapsed();
        this.clock.advanceTo(139L);
        this.assertNotElapsed();
        this.clock.advanceTo(140L);
        this.assertElapsed();
        this.clock.advanceTo(100000000000000L);
        this.assertElapsed();
    }

    @Test
    public void testLinearDelay() {
        this.clock.advanceTo(100L);
        this.delay = ElapsedTimeStrategy.linear((Clock)this.clock, (Duration)Duration.ofMillis(100L));
        this.assertNotElapsed();
        this.assertNotElapsed();
        this.clock.advanceTo(199L);
        this.assertNotElapsed();
        this.clock.advanceTo(200L);
        this.assertElapsed();
        this.clock.advanceTo(201L);
        this.assertNotElapsed();
        this.clock.advanceTo(301L);
        this.assertNotElapsed();
        this.clock.advanceTo(400L);
        this.assertElapsed();
        this.clock.advanceTo(401L);
        this.assertNotElapsed();
        this.clock.advanceTo(699L);
        this.assertNotElapsed();
        this.clock.advanceTo(701L);
        this.assertElapsed();
        this.clock.advanceTo(1099L);
        this.assertNotElapsed();
        this.clock.advanceTo(1101L);
        this.assertElapsed();
        this.clock.advanceTo(100000000000000L);
        this.assertElapsed();
    }

    @Test
    public void testStepDelayStartingBeforeStep() {
        this.clock.advanceTo(100L);
        AtomicBoolean step = new AtomicBoolean(false);
        this.delay = ElapsedTimeStrategy.step((Clock)this.clock, (Duration)Duration.ofMillis(10L), step::get, (Duration)Duration.ofMillis(100L));
        this.assertNotElapsed();
        this.assertNotElapsed();
        this.clock.advanceTo(109L);
        this.assertNotElapsed();
        this.clock.advanceTo(110L);
        this.assertElapsed();
        this.clock.advanceTo(119L);
        this.assertNotElapsed();
        this.clock.advanceTo(120L);
        this.assertElapsed();
        this.clock.advanceTo(129L);
        this.assertNotElapsed();
        step.set(true);
        this.assertNotElapsed();
        this.clock.advanceTo(130L);
        this.assertElapsed();
        this.clock.advanceTo(229L);
        this.assertNotElapsed();
        this.clock.advanceTo(230L);
        this.assertElapsed();
        this.clock.advanceTo(329L);
        this.assertNotElapsed();
        step.set(false);
        this.clock.advanceTo(330L);
        this.assertElapsed();
        this.clock.advanceTo(331L);
        this.assertNotElapsed();
        this.clock.advanceTo(341L);
        this.assertNotElapsed();
        this.clock.advanceTo(429L);
        this.assertNotElapsed();
        this.clock.advanceTo(430L);
        this.assertElapsed();
        this.clock.advanceTo(100000000000000L);
        this.assertElapsed();
    }

    @Test
    public void testStepDelayStartingAfterStep() {
        this.clock.advanceTo(100L);
        AtomicBoolean step = new AtomicBoolean(true);
        this.delay = ElapsedTimeStrategy.step((Clock)this.clock, (Duration)Duration.ofMillis(10L), step::get, (Duration)Duration.ofMillis(100L));
        this.assertNotElapsed();
        this.assertNotElapsed();
        this.clock.advanceTo(109L);
        this.assertNotElapsed();
        this.clock.advanceTo(110L);
        this.assertNotElapsed();
        this.clock.advanceTo(199L);
        this.assertNotElapsed();
        this.clock.advanceTo(200L);
        this.assertElapsed();
        this.clock.advanceTo(209L);
        this.assertNotElapsed();
        this.clock.advanceTo(300L);
        this.assertElapsed();
        step.set(false);
        this.assertNotElapsed();
        this.clock.advanceTo(399L);
        this.assertNotElapsed();
        this.clock.advanceTo(400L);
        this.assertElapsed();
        this.clock.advanceTo(409L);
        this.assertNotElapsed();
        this.clock.advanceTo(410L);
        this.assertNotElapsed();
        this.clock.advanceTo(499L);
        this.assertNotElapsed();
        this.clock.advanceTo(500L);
        this.assertElapsed();
        step.set(true);
        this.clock.advanceTo(501L);
        this.assertNotElapsed();
        this.clock.advanceTo(510L);
        this.assertNotElapsed();
        this.clock.advanceTo(599L);
        this.assertNotElapsed();
        this.clock.advanceTo(600L);
        this.assertElapsed();
        this.clock.advanceTo(100000000000000L);
        this.assertElapsed();
    }

    @Test
    public void testExponentialDelay() {
        this.clock.advanceTo(100L);
        this.delay = ElapsedTimeStrategy.exponential((Clock)this.clock, (Duration)Duration.ofMillis(100L), (Duration)Duration.ofMillis(4000L));
        this.assertNotElapsed();
        this.assertNotElapsed();
        this.clock.advanceTo(199L);
        this.assertNotElapsed();
        this.clock.advanceTo(200L);
        this.assertElapsed();
        this.clock.advanceTo(201L);
        this.assertNotElapsed();
        this.clock.advanceTo(301L);
        this.assertNotElapsed();
        this.clock.advanceTo(400L);
        this.assertElapsed();
        this.clock.advanceTo(401L);
        this.assertNotElapsed();
        this.clock.advanceTo(799L);
        this.assertNotElapsed();
        this.clock.advanceTo(800L);
        this.assertElapsed();
        this.clock.advanceTo(801L);
        this.assertNotElapsed();
        this.clock.advanceTo(1599L);
        this.assertNotElapsed();
        this.clock.advanceTo(1600L);
        this.assertElapsed();
        this.clock.advanceTo(1601L);
        this.assertNotElapsed();
        this.clock.advanceTo(3199L);
        this.assertNotElapsed();
        this.clock.advanceTo(3200L);
        this.assertElapsed();
        this.clock.advanceTo(3201L);
        this.assertNotElapsed();
        this.clock.advanceTo(6399L);
        this.assertNotElapsed();
        this.clock.advanceTo(6400L);
        this.assertElapsed();
        this.clock.advanceTo(6401L);
        this.assertNotElapsed();
        this.clock.advanceTo(10399L);
        this.assertNotElapsed();
        this.clock.advanceTo(10400L);
        this.assertElapsed();
        this.clock.advanceTo(100000000000000L);
        this.assertElapsed();
        this.clock.advanceTo(100000000000001L);
        this.assertNotElapsed();
        this.clock.advanceTo(100000000006400L);
        this.assertElapsed();
    }

    protected void assertElapsed() {
        Assertions.assertThat((boolean)this.delay.hasElapsed()).isTrue();
        this.assertNotElapsed();
    }

    protected void assertNotElapsed() {
        for (int i = 0; i != 5; ++i) {
            Assertions.assertThat((boolean)this.delay.hasElapsed()).isFalse();
        }
    }
}

