/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import io.debezium.time.Conversions;
import java.sql.Time;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class ConversionsTest {
    @Test
    public void shouldReturnNullIfNullIsSupplied() {
        Assertions.assertThat((LocalDate)Conversions.toLocalDate(null)).isNull();
        Assertions.assertThat((LocalDateTime)Conversions.toLocalDateTime(null)).isNull();
        Assertions.assertThat((LocalTime)Conversions.toLocalTime(null)).isNull();
    }

    @Test
    public void shouldReturnSameLocalDateInstanceWhenConvertingToLocalDate() {
        LocalDate now = LocalDate.now();
        Assertions.assertThat((LocalDate)Conversions.toLocalDate((Object)now)).isSameAs((Object)now);
    }

    @Test
    public void shouldReturnLocalDateInstanceWhenConvertingLocalDateTimeToLocalDate() {
        LocalDateTime now = LocalDateTime.now();
        Assertions.assertThat((LocalDate)Conversions.toLocalDate((Object)now)).isEqualTo((Object)now.toLocalDate());
    }

    @Test
    public void shouldReturnLocalDateInstanceWhenConvertingUtilDateToLocalDate() {
        LocalDate now = LocalDate.now();
        Date date = new Date(now.getYear() - 1900, now.getMonthValue() - 1, now.getDayOfMonth());
        Assertions.assertThat((LocalDate)Conversions.toLocalDate((Object)date)).isEqualTo((Object)now);
    }

    @Test
    public void shouldReturnLocalDateInstanceWhenConvertingSqlDateToLocalDate() {
        LocalDate now = LocalDate.now();
        java.sql.Date date = new java.sql.Date(now.getYear() - 1900, now.getMonthValue() - 1, now.getDayOfMonth());
        Assertions.assertThat((LocalDate)Conversions.toLocalDate((Object)date)).isEqualTo((Object)now);
    }

    @Test
    public void shouldThrowExceptionWhenConvertingSqlTimeToLocalDate() {
        Time time = new Time(1L);
        try {
            Conversions.toLocalDate((Object)time);
            Assert.fail((String)"Should not accept java.sql.Time values");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnLocalDateInstanceWhenConvertingLongToLocalDate() {
        LocalDate now = LocalDate.now();
        long epochDay = now.toEpochDay();
        Assertions.assertThat((LocalDate)Conversions.toLocalDate((Object)epochDay)).isEqualTo((Object)now);
    }

    @Test
    public void shouldReturnSameLocalDateTimeInstanceWhenConvertingToLocalDateTime() {
        LocalDateTime now = LocalDateTime.now();
        Assertions.assertThat((LocalDateTime)Conversions.toLocalDateTime((Object)now)).isSameAs((Object)now);
    }

    @Test
    public void shouldReturnLocalDateTimeInstanceWhenConvertingLocalDateToLocalDateTime() {
        LocalDate now = LocalDate.now();
        Assertions.assertThat((LocalDateTime)Conversions.toLocalDateTime((Object)now)).isEqualTo((Object)LocalDateTime.of(now, LocalTime.MIDNIGHT));
    }

    @Test
    public void shouldReturnLocalDateTimeInstanceWhenConvertingLocalTimeToLocalDateTime() {
        LocalTime now = LocalTime.now();
        Assertions.assertThat((LocalDateTime)Conversions.toLocalDateTime((Object)now)).isEqualTo((Object)LocalDateTime.of(Conversions.EPOCH, now));
    }

    @Test
    public void shouldReturnLocalDateTimeInstanceWhenConvertingUtilTimeToLocalDateTime() {
        LocalDateTime now = LocalDateTime.now();
        Date date = new Date(now.getYear() - 1900, now.getMonthValue() - 1, now.getDayOfMonth(), now.getHour(), now.getMinute(), now.getSecond());
        Assertions.assertThat((LocalDateTime)Conversions.toLocalDateTime((Object)date)).isEqualTo((Object)now.withNano(0));
    }

    @Test
    public void shouldReturnLocalDateTimeInstanceWhenConvertingSqlDateToLocalDateTime() {
        LocalDate now = LocalDate.now();
        java.sql.Date date = new java.sql.Date(now.getYear() - 1900, now.getMonthValue() - 1, now.getDayOfMonth());
        Assertions.assertThat((LocalDateTime)Conversions.toLocalDateTime((Object)date)).isEqualTo((Object)LocalDateTime.of(now, LocalTime.MIDNIGHT));
    }

    @Test
    public void shouldReturnLocalDateTimeInstanceWhenConvertingSqlTimeToLocalDateTime() {
        LocalTime now = LocalTime.now();
        Time time = new Time(now.getHour(), now.getMinute(), now.getSecond());
        Assertions.assertThat((LocalDateTime)Conversions.toLocalDateTime((Object)time)).isEqualTo((Object)LocalDateTime.of(Conversions.EPOCH, now.withNano(0)));
    }

    @Test
    public void shouldReturnLocalDateTimeInstanceWhenConvertingLongToLocalDateTime() {
        try {
            Conversions.toLocalDateTime((Object)1L);
            Assert.fail((String)"Should not accept Long values");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnSameLocalTimeInstanceWhenConvertingToLocalTime() {
        LocalTime now = LocalTime.now();
        Assertions.assertThat((LocalTime)Conversions.toLocalTime((Object)now)).isSameAs((Object)now);
    }

    @Test
    public void shouldReturnLocalTimeInstanceWhenConvertingLocalDateTimeToLocalTime() {
        LocalDateTime now = LocalDateTime.now();
        Assertions.assertThat((LocalTime)Conversions.toLocalTime((Object)now)).isEqualTo((Object)now.toLocalTime());
    }

    @Test
    public void shouldReturnLocalTimeInstanceWhenConvertingUtilTimeToLocalTime() {
        LocalTime now = LocalTime.now();
        Date date = new Date(0, 0, 1, now.getHour(), now.getMinute(), now.getSecond());
        Assertions.assertThat((LocalTime)Conversions.toLocalTime((Object)date)).isEqualTo((Object)now.withNano(0));
    }

    @Test
    public void shouldThrowExceptionWhenConvertingSqlDateToLocalTime() {
        java.sql.Date date = new java.sql.Date(1L);
        try {
            Conversions.toLocalTime((Object)date);
            Assert.fail((String)"Should not accept java.sql.Date values");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnLocalTimeInstanceWhenConvertingSqlTimeToLocalTime() {
        LocalTime now = LocalTime.now();
        Time time = new Time(now.getHour(), now.getMinute(), now.getSecond());
        Assertions.assertThat((LocalTime)Conversions.toLocalTime((Object)time)).isEqualTo((Object)now.withNano(0));
    }

    @Test
    public void shouldReturnCorrectInstantWhenConvertingMicroSecondsSinceEpoch() {
        long usSinceEpoch = 601060312290123456L;
        Assertions.assertThat((Instant)Conversions.toInstantFromMicros((long)usSinceEpoch)).isEqualTo((Object)OffsetDateTime.of(21016, 11, 4, 13, 51, 30, 123456000, ZoneOffset.UTC).toInstant());
        Instant source = LocalDateTime.parse("1970-01-01T00:00:01.250").toInstant(ZoneOffset.UTC);
        long epochMicros = Conversions.toEpochMicros((Instant)source);
        Instant target = Conversions.toInstantFromMicros((long)epochMicros);
        Assertions.assertThat((Instant)target).isEqualTo((Object)source);
        source = LocalDateTime.parse("1969-12-31T23:59:58.750000").toInstant(ZoneOffset.UTC);
        epochMicros = Conversions.toEpochMicros((Instant)source);
        target = Conversions.toInstantFromMicros((long)epochMicros);
        Assertions.assertThat((Instant)target).isEqualTo((Object)source);
        source = LocalDateTime.parse("1969-12-31T23:59:58.250000").toInstant(ZoneOffset.UTC);
        epochMicros = Conversions.toEpochMicros((Instant)source);
        target = Conversions.toInstantFromMicros((long)epochMicros);
        Assertions.assertThat((Instant)target).isEqualTo((Object)source);
        source = OffsetDateTime.of(21016, 11, 4, 13, 51, 30, 123456000, ZoneOffset.UTC).toInstant();
        epochMicros = Conversions.toEpochMicros((Instant)source);
        target = Conversions.toInstantFromMicros((long)epochMicros);
        Assertions.assertThat((Instant)target).isEqualTo((Object)source);
        source = OffsetDateTime.of(294247, 1, 10, 4, 0, 54, 775807000, ZoneOffset.UTC).toInstant();
        epochMicros = Conversions.toEpochMicros((Instant)source);
        target = Conversions.toInstantFromMicros((long)epochMicros);
        Assertions.assertThat((Instant)target).isEqualTo((Object)source);
        source = OffsetDateTime.of(-4713, 1, 1, 0, 0, 0, 0, ZoneOffset.UTC).toInstant();
        epochMicros = Conversions.toEpochMicros((Instant)source);
        target = Conversions.toInstantFromMicros((long)epochMicros);
        Assertions.assertThat((Instant)target).isEqualTo((Object)source);
    }
}

