/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.relational.HistorizedRelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.TableId;
import io.debezium.util.Testing;

public class Configurator {
    private Configuration.Builder configBuilder = Configuration.create();

    private Configurator with(Field field, String value) {
        this.configBuilder.with(field, value);
        return this;
    }

    public Configurator includeDatabases(String regexList) {
        Testing.debug("Using \"" + RelationalDatabaseConnectorConfig.DATABASE_INCLUDE_LIST.name() + "\" config property");
        return this.with(RelationalDatabaseConnectorConfig.DATABASE_INCLUDE_LIST, regexList);
    }

    public Configurator excludeDatabases(String regexList) {
        Testing.debug("Using \"" + RelationalDatabaseConnectorConfig.DATABASE_EXCLUDE_LIST.name() + "\" config property");
        return this.with(RelationalDatabaseConnectorConfig.DATABASE_EXCLUDE_LIST, regexList);
    }

    public Configurator includeCollections(String regexList) {
        Testing.debug("Using \"" + RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST.name() + "\" config property");
        return this.with(RelationalDatabaseConnectorConfig.TABLE_INCLUDE_LIST, regexList);
    }

    public Configurator excludeCollections(String regexList) {
        Testing.debug("Using \"" + RelationalDatabaseConnectorConfig.TABLE_EXCLUDE_LIST.name() + "\" config property");
        return this.with(RelationalDatabaseConnectorConfig.TABLE_EXCLUDE_LIST, regexList);
    }

    public Configurator storeOnlyCapturedDatabasesDdl(String flag) {
        Testing.debug("Using \"" + HistorizedRelationalDatabaseConnectorConfig.STORE_ONLY_CAPTURED_DATABASES_DDL.name() + "\" config property");
        return this.with(HistorizedRelationalDatabaseConnectorConfig.STORE_ONLY_CAPTURED_DATABASES_DDL, flag);
    }

    public Configurator signalingCollection(String signalingCollection) {
        return this.with(RelationalDatabaseConnectorConfig.SIGNAL_DATA_COLLECTION, signalingCollection);
    }

    public RelationalTableFilters createFilters() {
        return new RelationalTableFilters(this.configBuilder.build(), t -> true, TableId::toString, false);
    }
}

