/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters.recordandmetadata;

import io.debezium.converters.CloudEventsConverterConfig;
import io.debezium.converters.recordandmetadata.RecordAndMetadata;
import io.debezium.converters.recordandmetadata.RecordAndMetadataBaseImpl;
import java.util.function.Supplier;
import org.apache.kafka.common.header.Header;
import org.apache.kafka.common.header.Headers;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.json.JsonConverter;

public class RecordAndMetadataHeaderImpl
extends RecordAndMetadataBaseImpl
implements RecordAndMetadata {
    private final Headers headers;
    private final CloudEventsConverterConfig.MetadataLocation metadataLocation;
    private final JsonConverter jsonHeaderConverter;

    public RecordAndMetadataHeaderImpl(Struct record, Schema dataSchema, Headers headers, CloudEventsConverterConfig.MetadataLocation metadataLocation, JsonConverter jsonHeaderConverter) {
        super(record, dataSchema);
        this.headers = headers;
        this.metadataLocation = metadataLocation;
        this.jsonHeaderConverter = jsonHeaderConverter;
    }

    @Override
    public Schema dataSchema(String ... dataFields) {
        return this.getValueFromHeaderOrByDefault(this.metadataLocation.global(), null, null, () -> this.dataSchema, () -> super.dataSchema(dataFields));
    }

    @Override
    public String id() {
        return this.getValueFromHeaderOrByDefault(this.metadataLocation.id(), "id", false, null, () -> super.id());
    }

    @Override
    public String type() {
        return this.getValueFromHeaderOrByDefault(this.metadataLocation.type(), "type", false, null, () -> super.type());
    }

    @Override
    public Struct source() {
        return this.getValueFromHeaderOrByDefault(this.metadataLocation.global(), "source", false, null, () -> super.source());
    }

    @Override
    public String operation() {
        return this.getValueFromHeaderOrByDefault(this.metadataLocation.global(), "op", false, null, () -> super.operation());
    }

    @Override
    public Struct transaction() {
        return this.getValueFromHeaderOrByDefault(this.metadataLocation.global(), "transaction", true, null, () -> super.transaction());
    }

    @Override
    public SchemaAndValue timestamp() {
        return this.getValueFromHeaderOrByDefault(this.metadataLocation.global(), null, null, () -> {
            String ts_ms = this.source().getInt64("ts_ms").toString();
            Schema ts_msSchema = this.source().schema().field("ts_ms").schema();
            return new SchemaAndValue(ts_msSchema, (Object)ts_ms);
        }, () -> super.timestamp());
    }

    private <T> T getValueFromHeaderOrByDefault(CloudEventsConverterConfig.MetadataLocationValue metadataLocationValue, String headerName, Boolean headerIsOptional, Supplier<T> headerCaseDefaultSupplier, Supplier<T> defaultSupplier) {
        if (metadataLocationValue == CloudEventsConverterConfig.MetadataLocationValue.HEADER) {
            if (headerName != null) {
                return (T)this.getHeaderSchemaAndValue(this.headers, headerName, headerIsOptional).value();
            }
            return headerCaseDefaultSupplier.get();
        }
        return defaultSupplier.get();
    }

    private SchemaAndValue getHeaderSchemaAndValue(Headers headers, String headerName, boolean isOptional) {
        Header header = headers.lastHeader(headerName);
        if (header == null && !isOptional) {
            throw new RuntimeException("Header `" + headerName + "` was not provided");
        }
        return this.jsonHeaderConverter.toConnectData(null, header.value());
    }
}

