/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.doc.FixFor;
import io.debezium.transforms.AbstractExtractStateTest;
import io.debezium.transforms.ExtractChangedRecordState;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.source.SourceRecord;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class ExtractChangedRecordStateTest
extends AbstractExtractStateTest {
    @Test
    @FixFor(value={"DBZ-5283"})
    public void testAddUpdatedFieldToHeaders() {
        Header unchangedHeader;
        List changedHeaderValues;
        Header changedHeader;
        SourceRecord transformRecord;
        SourceRecord updatedRecord;
        HashMap<String, String> props;
        try (ExtractChangedRecordState transform = new ExtractChangedRecordState();){
            props = new HashMap<String, String>();
            props.put("header.changed.name", "Changed");
            props.put("header.unchanged.name", "Unchanged");
            transform.configure(props);
            updatedRecord = this.createUpdateRecord();
            transformRecord = (SourceRecord)transform.apply((ConnectRecord)updatedRecord);
            changedHeader = this.getSourceRecordHeader(transformRecord, "Changed");
            changedHeaderValues = (List)changedHeader.value();
            unchangedHeader = this.getSourceRecordHeader(transformRecord, "Unchanged");
            ArrayList unchangedHeaderValues = (ArrayList)unchangedHeader.value();
            Assertions.assertThat((int)transformRecord.headers().size()).isEqualTo(2);
            Assertions.assertThat((int)changedHeaderValues.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)changedHeaderValues.get(0))).isEqualTo((Object)"name");
            Assertions.assertThat((String)changedHeader.schema().name()).isEqualTo((Object)"Changed");
            Assertions.assertThat((int)unchangedHeaderValues.size()).isEqualTo(1);
            Assertions.assertThat((String)((String)unchangedHeaderValues.get(0))).isEqualTo((Object)"id");
        }
        transform = new ExtractChangedRecordState();
        try {
            props = new HashMap();
            props.put("header.changed.name", "Changed");
            transform.configure(props);
            updatedRecord = this.createUpdateRecord();
            transformRecord = (SourceRecord)transform.apply((ConnectRecord)updatedRecord);
            changedHeader = this.getSourceRecordHeader(transformRecord, "Changed");
            changedHeaderValues = (List)changedHeader.value();
            unchangedHeader = this.getSourceRecordHeader(transformRecord, "Unchanged");
            Assertions.assertThat((int)transformRecord.headers().size()).isEqualTo(1);
            Assertions.assertThat((boolean)changedHeaderValues.contains("name")).isTrue();
            Assertions.assertThat((Object)unchangedHeader).isNull();
        }
        finally {
            transform.close();
        }
    }

    @Test
    @FixFor(value={"DBZ-5283"})
    public void testAddCreatedFieldToHeaders() {
        try (ExtractChangedRecordState transform = new ExtractChangedRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            transform.configure(props);
            props.put("header.changed.name", "Changed");
            props.put("header.unchanged.name", "Unchanged");
            transform.configure(props);
            SourceRecord createdRecord = this.createCreateRecord();
            SourceRecord transformRecord = (SourceRecord)transform.apply((ConnectRecord)createdRecord);
            Assertions.assertThat((Iterable)transformRecord.headers()).isEmpty();
        }
    }

    @Test
    @FixFor(value={"DBZ-5283"})
    public void testNoHeadersSetWhenNotConfiguredWithCreate() {
        try (ExtractChangedRecordState transform = new ExtractChangedRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord createdRecord = this.createCreateRecord();
            SourceRecord transformRecord = (SourceRecord)transform.apply((ConnectRecord)createdRecord);
            Assertions.assertThat((Iterable)transformRecord.headers()).isEmpty();
        }
    }

    @Test
    @FixFor(value={"DBZ-5283"})
    public void testNoHeadersSetWhenNotConfiguredWithUpdate() {
        try (ExtractChangedRecordState transform = new ExtractChangedRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord updatedRecord = this.createUpdateRecord();
            SourceRecord transformRecord = (SourceRecord)transform.apply((ConnectRecord)updatedRecord);
            Assertions.assertThat((Iterable)transformRecord.headers()).isEmpty();
        }
    }

    @Test
    @FixFor(value={"DBZ-5283"})
    public void testNoHeadersSetWhenNotConfiguredWithDelete() {
        try (ExtractChangedRecordState transform = new ExtractChangedRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord transformRecord = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((Iterable)transformRecord.headers()).isEmpty();
        }
    }

    private Header getSourceRecordHeader(SourceRecord record, String headerKey) {
        Iterator operationHeader = record.headers().allWithName(headerKey);
        if (!operationHeader.hasNext()) {
            return null;
        }
        return (Header)operationHeader.next();
    }
}

