/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.config;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.config.Field;
import io.debezium.doc.FixFor;
import io.debezium.function.Predicates;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.history.SchemaHistory;
import io.debezium.util.Collect;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.apache.kafka.common.config.ConfigValue;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ConfigurationTest {
    private Configuration config;

    @Before
    public void beforeEach() {
        this.config = ((Configuration.Builder)Configuration.create().with("A", "a").with("B", "b").with("1", 1)).build();
    }

    @Test
    public void shouldConvertFromProperties() {
        Properties props = new Properties();
        props.setProperty("A", "a");
        props.setProperty("B", "b");
        props.setProperty("1", "1");
        this.config = Configuration.from((Properties)props);
        Assertions.assertThat((String)this.config.getString("A")).isEqualTo((Object)"a");
        Assertions.assertThat((String)this.config.getString("B")).isEqualTo((Object)"b");
        Assertions.assertThat((String)this.config.getString("1")).isEqualTo((Object)"1");
        Assertions.assertThat((Integer)this.config.getInteger("1")).isEqualTo(1);
        Assertions.assertThat((Boolean)this.config.getBoolean("1")).isNull();
    }

    @Test
    @FixFor(value={"DBZ-3514"})
    public void shouldNotBeModifiedAfterCreation() {
        Properties props = new Properties();
        props.setProperty("1", "one");
        props.setProperty("2", "two");
        this.config = Configuration.from((Properties)props);
        props.setProperty("1", "newValue");
        Assertions.assertThat((String)this.config.getString("1")).isEqualTo((Object)"one");
    }

    @Test
    public void shouldCreateInternalFields() {
        this.config = ((Configuration.Builder)Configuration.create().with(Field.createInternal((String)"a"), "a1")).build();
        Assertions.assertThat((String)this.config.getString("internal.a")).isEqualTo((Object)"a1");
    }

    @Test
    @FixFor(value={"DBZ-1962"})
    public void shouldThrowValidationOnDuplicateOldColumnFilterConfiguration() {
        this.config = ((Configuration.Builder)((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.COLUMN_INCLUDE_LIST, ".+aa")).with(RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST, ".+bb")).build();
        List errorMessages = ((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST})).get(RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST.name())).errorMessages();
        Assertions.assertThat((List)errorMessages).isNotEmpty();
        Assertions.assertThat((String)((String)errorMessages.get(0))).isEqualTo((Object)Field.validationOutput((Field)RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST, (String)"\"column.include.list\" is already specified"));
    }

    @Test
    @FixFor(value={"DBZ-1962"})
    public void shouldThrowValidationOnDuplicateColumnFilterConfiguration() {
        this.config = Configuration.create().with("column.include.list", ".+aa").with("column.exclude.list", ".+bb").build();
        List errorMessages = ((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST})).get(RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST.name())).errorMessages();
        Assertions.assertThat((List)errorMessages).isNotEmpty();
        Assertions.assertThat((String)((String)errorMessages.get(0))).isEqualTo((Object)Field.validationOutput((Field)RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST, (String)"\"column.include.list\" is already specified"));
    }

    @Test
    public void shouldAllowNewColumnFilterIncludeListConfiguration() {
        this.config = Configuration.create().with("column.include.list", ".+aa").build();
        List errorMessages = ((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST})).get(RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST.name())).errorMessages();
        Assertions.assertThat((List)errorMessages).isEmpty();
        errorMessages = ((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.COLUMN_INCLUDE_LIST})).get(RelationalDatabaseConnectorConfig.COLUMN_INCLUDE_LIST.name())).errorMessages();
        Assertions.assertThat((List)errorMessages).isEmpty();
    }

    @Test
    public void shouldAllowNewColumnFilterExcludeListConfiguration() {
        this.config = Configuration.create().with("column.exclude.list", ".+bb").build();
        List errorMessages = ((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST})).get(RelationalDatabaseConnectorConfig.COLUMN_EXCLUDE_LIST.name())).errorMessages();
        Assertions.assertThat((List)errorMessages).isEmpty();
    }

    @Test
    public void shouldCallFunctionOnEachMatchingFieldUsingRegex() {
        this.config = Configuration.create().with("column.truncate.to.-10.chars", "should-not-be-matched").with("column.truncate.to.10.chars", "10-chars").with("column.truncate.to.20.chars", "20-chars").with("column.mask.with.20.chars", "20-mask").with("column.mask.with.0.chars", "0-mask").with("column.mask.with.chars", "should-not-be-matched").build();
        AtomicInteger counter = new AtomicInteger();
        this.config.forEachMatchingFieldNameWithInteger("column\\.truncate\\.to\\.(\\d+)\\.chars", (value, n) -> {
            counter.incrementAndGet();
            Assertions.assertThat((String)value).isEqualTo((Object)(Integer.toString(n) + "-chars"));
        });
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
        counter.set(0);
        this.config.forEachMatchingFieldNameWithInteger("column.mask.with.(\\d+).chars", (value, n) -> {
            counter.incrementAndGet();
            Assertions.assertThat((String)value).isEqualTo((Object)(Integer.toString(n) + "-mask"));
        });
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
        counter.set(0);
        this.config.forEachMatchingFieldName("column.mask.with.(\\d+).chars", (name, value) -> {
            counter.incrementAndGet();
            Assertions.assertThat((String)name).startsWith((CharSequence)"column.mask.with.");
            Assertions.assertThat((String)name).endsWith((CharSequence)".chars");
            Assertions.assertThat((String)value).endsWith((CharSequence)"-mask");
        });
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
        counter.set(0);
        this.config.forEachMatchingFieldName("column.*", (name, value) -> {
            counter.incrementAndGet();
            Assertions.assertThat((String)name).startsWith((CharSequence)"column.");
            Assertions.assertThat((String)name).endsWith((CharSequence)".chars");
            Assertions.assertThat((String)value).isNotNull();
        });
        Assertions.assertThat((int)counter.get()).isEqualTo(6);
    }

    @Test
    public void shouldMaskPasswords() {
        Pattern p = Pattern.compile(".*password$", 2);
        Assertions.assertThat((boolean)p.matcher("password").matches()).isTrue();
        Assertions.assertThat((boolean)p.matcher("otherpassword").matches()).isTrue();
        this.config = Configuration.create().with("column.password", "warning").with("column.Password.this.is.not", "value").with("column.truncate.to.20.chars", "20-chars").with("column.mask.with.20.chars", "20-mask").with("column.mask.with.0.chars", "0-mask").with("column.mask.with.chars", "should-not-be-matched").build();
        Assertions.assertThat((boolean)this.config.withMaskedPasswords().toString().contains("warning")).isFalse();
        Assertions.assertThat((boolean)this.config.toString().contains("warning")).isFalse();
        Assertions.assertThat((String)this.config.withMaskedPasswords().getString("column.password")).isEqualTo((Object)"********");
        Assertions.assertThat((String)this.config.getString("column.password")).isEqualTo((Object)"warning");
    }

    @Test
    @FixFor(value={"DBZ-469"})
    public void defaultDdlFilterShouldFilterOutRdsHeartbeatInsert() {
        String defaultDdlFilter = Configuration.create().build().getString(SchemaHistory.DDL_FILTER);
        Predicate ddlFilter = Predicates.includes((String)defaultDdlFilter, (int)34);
        Assertions.assertThat((boolean)ddlFilter.test("INSERT INTO mysql.rds_heartbeat2(id, value) values (1,1510678117058) ON DUPLICATE KEY UPDATE value = 1510678117058")).isTrue();
    }

    @Test
    @FixFor(value={"DBZ-661"})
    public void defaultDdlFilterShouldFilterOutFlushRelayLogs() {
        String defaultDdlFilter = Configuration.create().build().getString(SchemaHistory.DDL_FILTER);
        Predicate ddlFilter = Predicates.includes((String)defaultDdlFilter, (int)34);
        Assertions.assertThat((boolean)ddlFilter.test("FLUSH RELAY LOGS")).isTrue();
    }

    @Test
    @FixFor(value={"DBZ-1492"})
    public void defaultDdlFilterShouldFilterOutRdsSysinfoStatements() {
        String defaultDdlFilter = Configuration.create().build().getString(SchemaHistory.DDL_FILTER);
        Predicate ddlFilter = Predicates.includes((String)defaultDdlFilter, (int)34);
        Assertions.assertThat((boolean)ddlFilter.test("DELETE FROM mysql.rds_sysinfo where name = 'innodb_txn_key'")).isTrue();
        Assertions.assertThat((boolean)ddlFilter.test("INSERT INTO mysql.rds_sysinfo(name, value) values ('innodb_txn_key','Thu Sep 19 19:38:23 UTC 2019')")).isTrue();
    }

    @Test
    @FixFor(value={"DBZ-1775"})
    public void defaultDdlFilterShouldFilterOutRdsMonitorStatements() {
        String defaultDdlFilter = Configuration.create().build().getString(SchemaHistory.DDL_FILTER);
        Predicate ddlFilter = Predicates.includes((String)defaultDdlFilter, (int)34);
        Assertions.assertThat((boolean)ddlFilter.test("DELETE FROM mysql.rds_monitor")).isTrue();
    }

    @Test
    @FixFor(value={"DBZ-3762"})
    public void defaultDdlFilterShouldFilterOutMySqlInlineComments() {
        String defaultDdlFilter = Configuration.create().build().getString(SchemaHistory.DDL_FILTER);
        Predicate ddlFilter = Predicates.includes((String)defaultDdlFilter, (int)34);
        Assertions.assertThat((boolean)ddlFilter.test("# Dummy event replacing event type 160")).isTrue();
        Assertions.assertThat((boolean)ddlFilter.test("    # Dummy event with leading white space characters")).isTrue();
        Assertions.assertThat((boolean)ddlFilter.test("INSERT INTO test(id) VALUES (1001); # test insert")).isFalse();
        Assertions.assertThat((boolean)ddlFilter.test("SELECT '[1, 2, 3]'::JSONB #> '{1}';")).isFalse();
    }

    @Test
    @FixFor(value={"DBZ-5709"})
    public void customDdlFilterShouldFilterOutMySqlCreateViewStatements() {
        String customDdlFilter = ((Configuration.Builder)Configuration.create().with(SchemaHistory.DDL_FILTER, "CREATE.*VIEW.*")).build().getString(SchemaHistory.DDL_FILTER);
        Predicate ddlFilter = Predicates.includes((String)customDdlFilter, (int)34);
        String createView = "create algorithm=undefined definer=`bi_rw`@`172.29.%` sql security definer view \nv_some_table as (\nwith a as (select * from some_table) \nselect * from a\n);";
        Assertions.assertThat((boolean)ddlFilter.test(createView)).isTrue();
    }

    @Test
    @FixFor(value={"DBZ-6840"})
    public void defaultDdlFilterShouldNotFilterMariaDBComments() {
        String defaultDdlFilter = Configuration.create().build().getString(SchemaHistory.DDL_FILTER);
        Predicate ddlFilter = Predicates.includes((String)defaultDdlFilter, (int)34);
        Assertions.assertThat((boolean)ddlFilter.test("# Create the new ENTITY table which will be the parent of all other resource tables.\nCREATE TABLE IF NOT EXISTS ENTITY (\n ID BIGINT AUTO_INCREMENT PRIMARY KEY,\n ENTITY_UUID VARCHAR(255) NOT NULL,\n ENTITY_TYPE VARCHAR(255) NULL,\n CREATED_ON DATETIME(6)\u00a0 NULL,\n UPDATED_ON DATETIME(6)\u00a0 NULL,\n CREATED_BY VARCHAR(255) NULL,\n UPDATED_BY VARCHAR(255) NULL,\n CONSTRAINT UI_ENTITY_UUID UNIQUE (ENTITY_UUID)\n)")).isFalse();
    }

    @Test
    @FixFor(value={"DBZ-1015"})
    public void testMsgKeyColumnsField() {
        this.config = Configuration.create().build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "")).build();
        List errorList = ((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages();
        Assertions.assertThat((String)((String)errorList.get(0))).isEqualTo((Object)Field.validationOutput((Field)RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, (String)"Must not be empty"));
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "t1:C1")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, " t1:C1 ")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "t1:C1,C2")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "t1:C1,C2;t2:C1,C2")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "t1:C1;(.*).t2:C1,C2")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "t1,t2")).build();
        errorList = ((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages();
        Assertions.assertThat((String)((String)errorList.get(0))).isEqualTo((Object)Field.validationOutput((Field)RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, (String)"t1,t2 has an invalid format (expecting '^\\s*([^\\s:]+):([^:\\s]+)\\s*$')"));
    }

    @Test
    @FixFor(value={"DBZ-2957"})
    public void testMsgKeyColumnsFieldRegexValidation() {
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "t1:C1;(.*).t2:C1,C2;")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "t1:C1;(.*).t2:C1,C2;t3.C1;")).build();
        List errorList = ((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages();
        Assertions.assertThat((String)((String)errorList.get(0))).isEqualTo((Object)Field.validationOutput((Field)RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, (String)"t3.C1 has an invalid format (expecting '^\\s*([^\\s:]+):([^:\\s]+)\\s*$')"));
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "t1:C1;(.*).t2:C1,C2;t3;")).build();
        errorList = ((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages();
        Assertions.assertThat((String)((String)errorList.get(0))).isEqualTo((Object)Field.validationOutput((Field)RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, (String)"t3 has an invalid format (expecting '^\\s*([^\\s:]+):([^:\\s]+)\\s*$')"));
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, "t1:C1;foobar")).build();
        errorList = ((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS})).get(RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS.name())).errorMessages();
        Assertions.assertThat((String)((String)errorList.get(0))).isEqualTo((Object)Field.validationOutput((Field)RelationalDatabaseConnectorConfig.MSG_KEY_COLUMNS, (String)"foobar has an invalid format (expecting '^\\s*([^\\s:]+):([^:\\s]+)\\s*$')"));
    }

    @Test
    @FixFor(value={"DBZ-3427"})
    public void testServerNameValidation() {
        this.config = ((Configuration.Builder)Configuration.create().with(CommonConnectorConfig.TOPIC_PREFIX, "server_11")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{CommonConnectorConfig.TOPIC_PREFIX})).get(CommonConnectorConfig.TOPIC_PREFIX.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(CommonConnectorConfig.TOPIC_PREFIX, "server-12")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{CommonConnectorConfig.TOPIC_PREFIX})).get(CommonConnectorConfig.TOPIC_PREFIX.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(CommonConnectorConfig.TOPIC_PREFIX, "server.12")).build();
        Assertions.assertThat((List)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{CommonConnectorConfig.TOPIC_PREFIX})).get(CommonConnectorConfig.TOPIC_PREFIX.name())).errorMessages()).isEmpty();
        this.config = ((Configuration.Builder)Configuration.create().with(CommonConnectorConfig.TOPIC_PREFIX, "server@X")).build();
        List errorList = ((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{CommonConnectorConfig.TOPIC_PREFIX})).get(CommonConnectorConfig.TOPIC_PREFIX.name())).errorMessages();
        Assertions.assertThat((String)((String)errorList.get(0))).isEqualTo((Object)Field.validationOutput((Field)CommonConnectorConfig.TOPIC_PREFIX, (String)"server@X has invalid format (only the underscore, hyphen, dot and alphanumeric characters are allowed)"));
    }

    @Test
    @FixFor(value={"DBZ-6156"})
    public void testHostnameValidation() {
        this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.HOSTNAME, "")).build();
        Assertions.assertThat((String)((String)((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.HOSTNAME})).get(RelationalDatabaseConnectorConfig.HOSTNAME.name())).errorMessages().get(0))).isEqualTo((Object)"The 'database.hostname' value is invalid: A value is required");
        List invalidHostnames = Collect.arrayListOf((Object)"~hostname", (Object[])new String[]{"hostname@", "host-*-name", "(hostname)", "hostname?inject_parameter=1234"});
        String errorMessage = " has invalid format (only the underscore, hyphen, dot and alphanumeric characters are allowed)";
        invalidHostnames.stream().forEach(hostname -> {
            this.config = ((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.HOSTNAME, hostname)).build();
            List errorList = ((ConfigValue)this.config.validate(Field.setOf((Field[])new Field[]{RelationalDatabaseConnectorConfig.HOSTNAME})).get(RelationalDatabaseConnectorConfig.HOSTNAME.name())).errorMessages();
            Assertions.assertThat((String)((String)errorList.get(0))).isEqualTo((Object)Field.validationOutput((Field)RelationalDatabaseConnectorConfig.HOSTNAME, (String)(hostname + errorMessage)));
        });
    }

    @Test
    @FixFor(value={"DBZ-5801"})
    public void testConfigurationMerge() {
        this.config = Configuration.create().with("database.hostname", "server1").with("driver.user", "mysqluser").build();
        Configuration dbConfig = this.config.subset("database.", true).merge(new Configuration[]{this.config.subset("driver.", true)});
        Assertions.assertThat((int)dbConfig.keys().size()).isEqualTo(2);
        Assertions.assertThat((String)dbConfig.getString("user")).isEqualTo((Object)"mysqluser");
    }
}

