/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.relational.Configurator;
import io.debezium.relational.RelationalTableFilters;
import io.debezium.relational.TableId;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class RelationalTableFiltersTest {
    private Configurator build;
    private RelationalTableFilters filters;

    @Before
    public void beforeEach() {
        this.build = new Configurator();
        this.filters = null;
    }

    @Test
    public void shouldIncludeDatabaseCoveredByLiteralInWhitelist() {
        this.filters = this.build.includeDatabases("db1").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isTrue();
    }

    @Test
    public void shouldIncludeDatabaseCoveredByMultipleLiteralsInWhitelist() {
        this.filters = this.build.includeDatabases("db1,db2").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isTrue();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db2")).isTrue();
    }

    @Test
    public void shouldIncludeDatabaseCoveredByWildcardInWhitelist() {
        this.filters = this.build.includeDatabases("db.*").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isTrue();
    }

    @Test
    public void shouldIncludeDatabaseCoveredByMultipleWildcardsInWhitelist() {
        this.filters = this.build.includeDatabases("db.*,mongo.*").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isTrue();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("mongo2")).isTrue();
    }

    @Test
    public void shouldExcludeDatabaseCoveredByLiteralInBlacklist() {
        this.filters = this.build.excludeDatabases("db1").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isFalse();
    }

    @Test
    public void shouldExcludeDatabaseCoveredByMultipleLiteralsInBlacklist() {
        this.filters = this.build.excludeDatabases("db1,db2").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isFalse();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db2")).isFalse();
    }

    @Test
    public void shouldNotExcludeDatabaseNotCoveredByLiteralInBlacklist() {
        this.filters = this.build.excludeDatabases("db1").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db2")).isTrue();
    }

    @Test
    public void shouldExcludeDatabaseCoveredByWildcardInBlacklist() {
        this.filters = this.build.excludeDatabases("db.*").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isFalse();
    }

    @Test
    public void shouldExcludeDatabaseCoveredByMultipleWildcardsInBlacklist() {
        this.filters = this.build.excludeDatabases("db.*,mongo.*").createFilters();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("db1")).isFalse();
        Assertions.assertThat((boolean)this.filters.databaseFilter().test("mongo2")).isFalse();
    }

    @Test
    public void shouldIncludeCollectionCoveredByLiteralWithPeriodAsWildcardInWhitelistAndNoBlacklist() {
        this.filters = this.build.includeCollections("db1.coll[.]?ection[x]?A,db1[.](.*)B").createFilters();
        this.assertCollectionIncluded("db1xcoll.ectionA");
        this.assertCollectionIncluded("db1.collectionA");
    }

    @Test
    public void shouldIncludeCollectionCoveredByLiteralInWhitelistAndNoBlacklist() {
        this.filters = this.build.includeCollections("db1.collectionA").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionExcluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
    }

    @Test
    public void shouldIncludeCollectionCoveredByLiteralWithEscapedPeriodInWhitelistAndNoBlacklist() {
        this.filters = this.build.includeCollections("db1[.]collectionA").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionExcluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.filters = this.build.includeCollections("db1\\.collectionA").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionExcluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
    }

    @Test
    public void shouldIncludeCollectionCoveredByMultipleLiteralsInWhitelistAndNoBlacklist() {
        this.filters = this.build.includeCollections("db1.collectionA,db1.collectionB").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.assertCollectionExcluded("db2.collectionB");
    }

    @Test
    public void shouldIncludeCollectionCoveredByMultipleRegexInWhitelistAndNoBlacklist() {
        this.filters = this.build.includeCollections("db1.collection[x]?A,db1[.](.*)B").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionxA");
        this.assertCollectionExcluded("db1.collectionx");
        this.assertCollectionExcluded("db1.collectioxA");
        this.assertCollectionIncluded("db1.B");
        this.assertCollectionIncluded("db1.collB");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.assertCollectionExcluded("db2.collectionxA");
        this.assertCollectionExcluded("db2.B");
        this.assertCollectionExcluded("db2.collB");
        this.assertCollectionExcluded("db2.collectionB");
    }

    @Test
    public void shouldIncludeCollectionCoveredByRegexWithWildcardInWhitelistAndNoBlacklist() {
        this.filters = this.build.includeCollections("db1[.](.*)").createFilters();
        this.assertCollectionIncluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionxA");
        this.assertCollectionIncluded("db1.collectionx");
        this.assertCollectionIncluded("db1.collectioxA");
        this.assertCollectionIncluded("db1.B");
        this.assertCollectionIncluded("db1.collB");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionExcluded("db2.collectionA");
        this.assertCollectionExcluded("db2.collectionxA");
        this.assertCollectionExcluded("db12.B");
        this.assertCollectionExcluded("db12.collB");
        this.assertCollectionExcluded("db12.collectionB");
    }

    @Test
    public void shouldExcludeCollectionCoveredByLiteralInBlacklist() {
        this.filters = this.build.excludeCollections("db1.collectionA").createFilters();
        this.assertCollectionExcluded("db1.collectionA");
        this.assertCollectionIncluded("db1.collectionB");
        this.assertCollectionIncluded("db2.collectionA");
    }

    @Test
    public void shouldIncludeSignalingCollectionAndNoWhitelistAndNoBlacklist() {
        this.filters = this.build.signalingCollection("db1.signal").createFilters();
        this.assertCollectionIncluded("db1.signal");
    }

    @Test
    public void shouldIncludeSignalingCollectionNotCoveredByWhitelist() {
        this.filters = this.build.includeCollections("db1.table").signalingCollection("db1.signal").createFilters();
        this.assertCollectionIncluded("db1.signal");
    }

    @Test
    public void shouldIncludeSignalingCollectionCoveredByLiteralInBlacklist() {
        this.filters = this.build.excludeCollections("db1.signal").signalingCollection("db1.signal").createFilters();
        this.assertCollectionIncluded("db1.signal");
    }

    @Test
    public void shouldIncludeSignalingCollectionCoveredByRegexInBlacklist() {
        this.filters = this.build.excludeCollections("db1.*").signalingCollection("db1.signal").createFilters();
        this.assertCollectionIncluded("db1.signal");
    }

    protected void assertCollectionIncluded(String fullyQualifiedCollectionName) {
        TableId id = TableId.parse((String)fullyQualifiedCollectionName);
        Assertions.assertThat((Comparable)id).isNotNull();
        Assertions.assertThat((boolean)this.filters.dataCollectionFilter().isIncluded(id)).isTrue();
    }

    protected void assertCollectionExcluded(String fullyQualifiedCollectionName) {
        TableId id = TableId.parse((String)fullyQualifiedCollectionName);
        Assertions.assertThat((Comparable)id).isNotNull();
        Assertions.assertThat((boolean)this.filters.dataCollectionFilter().isIncluded(id)).isFalse();
    }
}

