/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import io.debezium.data.Envelope;
import io.debezium.pipeline.txmetadata.TransactionMonitor;
import java.util.Map;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.assertj.core.api.Assertions;
import org.junit.Test;

public class EnvelopeTest {
    @Test
    public void shouldBuildWithSimpleOptionalTypesForBeforeAndAfter() {
        Envelope env = Envelope.defineSchema().withName("someName").withRecord(Schema.OPTIONAL_STRING_SCHEMA).withSource(Schema.OPTIONAL_INT64_SCHEMA).build();
        Assertions.assertThat((Object)env.schema()).isNotNull();
        Assertions.assertThat((String)env.schema().name()).isEqualTo((Object)"someName");
        Assertions.assertThat((String)env.schema().doc()).isNull();
        Assertions.assertThat((Integer)env.schema().version()).isEqualTo(1);
        this.assertOptionalField(env, "after", Schema.OPTIONAL_STRING_SCHEMA);
        this.assertOptionalField(env, "before", Schema.OPTIONAL_STRING_SCHEMA);
        this.assertOptionalField(env, "source", Schema.OPTIONAL_INT64_SCHEMA);
        this.assertRequiredField(env, "op", Schema.STRING_SCHEMA);
        this.assertOptionalField(env, "transaction", TransactionMonitor.TRANSACTION_BLOCK_SCHEMA);
    }

    protected void assertRequiredField(Envelope env, String fieldName, Schema expectedSchema) {
        this.assertField(env.schema().field(fieldName), fieldName, expectedSchema, false);
    }

    protected void assertOptionalField(Envelope env, String fieldName, Schema expectedSchema) {
        this.assertField(env.schema().field(fieldName), fieldName, expectedSchema, true);
    }

    protected void assertField(Field field, String fieldName, Schema expectedSchema, boolean optional) {
        Assertions.assertThat((String)field.name()).isEqualTo((Object)fieldName);
        Schema schema = field.schema();
        Assertions.assertThat((String)schema.name()).isEqualTo((Object)expectedSchema.name());
        Assertions.assertThat((String)schema.doc()).isEqualTo((Object)expectedSchema.doc());
        Assertions.assertThat((Map)schema.parameters()).isEqualTo((Object)expectedSchema.parameters());
        Assertions.assertThat((Integer)schema.version()).isEqualTo((Object)expectedSchema.version());
        Assertions.assertThat((boolean)schema.isOptional()).isEqualTo(optional);
        switch (expectedSchema.type()) {
            case STRUCT: {
                for (Field f : expectedSchema.fields()) {
                    this.assertField(schema.field(f.name()), f.name(), f.schema(), f.schema().isOptional());
                }
                break;
            }
        }
    }
}

