/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.data.Envelope;
import io.debezium.pipeline.txmetadata.TransactionMonitor;
import java.time.Instant;
import java.util.HashMap;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;

public abstract class AbstractExtractStateTest {
    protected final Schema recordSchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("name", Schema.STRING_SCHEMA).build();
    protected final Schema sourceSchema = SchemaBuilder.struct().field("lsn", Schema.INT32_SCHEMA).field("ts_ms", Schema.OPTIONAL_INT32_SCHEMA).build();
    protected final Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();

    protected SourceRecord createDeleteRecord() {
        Schema deleteSourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).field("version", (Schema)SchemaBuilder.string()).build();
        Envelope deleteEnvelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(deleteSourceSchema).build();
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(deleteSourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"myRecord");
        source.put("lsn", (Object)1234);
        source.put("version", (Object)"version!");
        Struct payload = deleteEnvelope.delete((Object)before, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", this.envelope.schema(), (Object)payload);
    }

    protected SourceRecord createTombstoneRecord() {
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
    }

    protected SourceRecord createTruncateRecord() {
        Struct source = new Struct(this.sourceSchema);
        source.put("lsn", (Object)1234);
        source.put("ts_ms", (Object)12836);
        Struct truncate = this.envelope.truncate(source, Instant.ofEpochMilli(System.currentTimeMillis()));
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", this.envelope.schema(), (Object)truncate);
    }

    protected SourceRecord createCreateRecord() {
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"myRecord");
        source.put("lsn", (Object)1234);
        source.put("ts_ms", (Object)12836);
        Struct payload = this.envelope.create((Object)before, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", this.envelope.schema(), (Object)payload);
    }

    protected SourceRecord createCreateRecordWithOptionalNull() {
        Schema recordSchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("name", SchemaBuilder.string().optional().defaultValue((Object)"default_str").build()).build();
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(this.sourceSchema).build();
        Struct after = new Struct(recordSchema);
        Struct source = new Struct(this.sourceSchema);
        after.put("id", (Object)1);
        after.put("name", null);
        source.put("lsn", (Object)1234);
        source.put("ts_ms", (Object)12836);
        Struct payload = envelope.create((Object)after, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", envelope.schema(), (Object)payload);
    }

    protected SourceRecord createCreateRecordWithKey() {
        Schema keySchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).build();
        Schema recordSchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("name", SchemaBuilder.string().optional().defaultValue((Object)"default_str").build()).build();
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(this.sourceSchema).build();
        Struct key = new Struct(keySchema);
        Struct after = new Struct(recordSchema);
        Struct source = new Struct(this.sourceSchema);
        key.put("id", (Object)1);
        after.put("id", (Object)1);
        after.put("name", null);
        source.put("lsn", (Object)1234);
        source.put("ts_ms", (Object)12836);
        Struct payload = envelope.create((Object)after, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", keySchema, (Object)key, envelope.schema(), (Object)payload);
    }

    protected SourceRecord createUpdateRecord() {
        Struct before = new Struct(this.recordSchema);
        Struct after = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        Struct transaction = new Struct(TransactionMonitor.TRANSACTION_BLOCK_SCHEMA);
        before.put("id", (Object)1);
        before.put("name", (Object)"myRecord");
        after.put("id", (Object)1);
        after.put("name", (Object)"updatedRecord");
        source.put("lsn", (Object)1234);
        transaction.put("id", (Object)"571");
        transaction.put("total_order", (Object)42L);
        transaction.put("data_collection_order", (Object)42L);
        Struct payload = this.envelope.update((Object)before, after, source, Instant.now());
        payload.put("transaction", (Object)transaction);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", this.envelope.schema(), (Object)payload);
    }

    protected SourceRecord createUpdateRecordWithOptionalNull() {
        Schema recordSchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("name", SchemaBuilder.string().optional().defaultValue((Object)"default_str").build()).build();
        Struct before = new Struct(recordSchema);
        Struct after = new Struct(recordSchema);
        Struct source = new Struct(this.sourceSchema);
        Struct transaction = new Struct(TransactionMonitor.TRANSACTION_BLOCK_SCHEMA);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(this.sourceSchema).build();
        before.put("id", (Object)1);
        before.put("name", null);
        after.put("id", (Object)1);
        after.put("name", (Object)"updatedRecord");
        source.put("lsn", (Object)1234);
        transaction.put("id", (Object)"571");
        transaction.put("total_order", (Object)42L);
        transaction.put("data_collection_order", (Object)42L);
        Struct payload = envelope.update((Object)before, after, source, Instant.now());
        payload.put("transaction", (Object)transaction);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", envelope.schema(), (Object)payload);
    }

    protected SourceRecord createUpdateRecordWithKey() {
        Schema keySchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).build();
        Schema recordSchema = SchemaBuilder.struct().field("id", Schema.INT8_SCHEMA).field("name", SchemaBuilder.string().optional().defaultValue((Object)"default_str").build()).build();
        Struct before = new Struct(recordSchema);
        Struct after = new Struct(recordSchema);
        Struct source = new Struct(this.sourceSchema);
        Struct key = new Struct(keySchema);
        Struct transaction = new Struct(TransactionMonitor.TRANSACTION_BLOCK_SCHEMA);
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(this.sourceSchema).build();
        key.put("id", (Object)1);
        before.put("id", (Object)1);
        before.put("name", null);
        after.put("id", (Object)1);
        after.put("name", (Object)"updatedRecord");
        source.put("lsn", (Object)1234);
        transaction.put("id", (Object)"571");
        transaction.put("total_order", (Object)42L);
        transaction.put("data_collection_order", (Object)42L);
        Struct payload = envelope.update((Object)before, after, source, Instant.now());
        payload.put("transaction", (Object)transaction);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", keySchema, (Object)key, envelope.schema(), (Object)payload);
    }

    protected SourceRecord createComplexCreateRecord() {
        Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).build();
        Schema sourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).field("version", (Schema)SchemaBuilder.string()).build();
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(sourceSchema).build();
        Struct before = new Struct(recordSchema);
        Struct source = new Struct(sourceSchema);
        before.put("id", (Object)1);
        source.put("lsn", (Object)1234);
        source.put("version", (Object)"version!");
        Struct payload = envelope.create((Object)before, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", envelope.schema(), (Object)payload);
    }

    protected SourceRecord createUnknownRecord() {
        Schema recordSchema = SchemaBuilder.struct().name("unknown").field("id", (Schema)SchemaBuilder.int8()).build();
        Struct before = new Struct(recordSchema);
        before.put("id", (Object)1);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", recordSchema, (Object)before);
    }

    protected SourceRecord createUnknownUnnamedSchemaRecord() {
        Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).build();
        Struct before = new Struct(recordSchema);
        before.put("id", (Object)1);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", recordSchema, (Object)before);
    }
}

