/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.document.Path;
import io.debezium.document.Paths;
import io.debezium.util.Testing;
import org.assertj.core.api.Assertions;
import org.junit.Before;
import org.junit.Test;

public class PathsTest
implements Testing {
    private Path path;

    @Before
    public void beforeEach() {
        this.path = null;
    }

    @Test
    public void shouldParseRootPath() {
        this.path = this.parse("/");
        Assertions.assertThat((boolean)this.path.isRoot()).isTrue();
        Assertions.assertThat((boolean)this.path.isSingle()).isFalse();
        Assertions.assertThat((int)this.path.size()).isEqualTo(0);
    }

    @Test
    public void shouldParseSingleRelativePath() {
        this.path = this.parse("a");
        Assertions.assertThat((boolean)this.path.isRoot()).isFalse();
        Assertions.assertThat((boolean)this.path.isSingle()).isTrue();
        Assertions.assertThat((int)this.path.size()).isEqualTo(1);
        Assertions.assertThat((String)this.path.segment(0)).isEqualTo((Object)"a");
    }

    @Test
    public void shouldParseSingleAbsolutePath() {
        this.path = this.parse("/a");
        Assertions.assertThat((boolean)this.path.isRoot()).isFalse();
        Assertions.assertThat((boolean)this.path.isSingle()).isTrue();
        Assertions.assertThat((int)this.path.size()).isEqualTo(1);
        Assertions.assertThat((String)this.path.segment(0)).isEqualTo((Object)"a");
    }

    @Test
    public void shouldParseDoubleRelativePath() {
        this.path = this.parse("a/b");
        Assertions.assertThat((boolean)this.path.isRoot()).isFalse();
        Assertions.assertThat((boolean)this.path.isSingle()).isFalse();
        Assertions.assertThat((int)this.path.size()).isEqualTo(2);
        Assertions.assertThat((String)this.path.segment(0)).isEqualTo((Object)"a");
        Assertions.assertThat((String)this.path.segment(1)).isEqualTo((Object)"b");
    }

    @Test
    public void shouldParseDoubleAbsolutePath() {
        this.path = this.parse("/a/b");
        Assertions.assertThat((boolean)this.path.isRoot()).isFalse();
        Assertions.assertThat((boolean)this.path.isSingle()).isFalse();
        Assertions.assertThat((int)this.path.size()).isEqualTo(2);
        Assertions.assertThat((String)this.path.segment(0)).isEqualTo((Object)"a");
        Assertions.assertThat((String)this.path.segment(1)).isEqualTo((Object)"b");
    }

    @Test
    public void shouldParseMultiRelativePath() {
        this.path = this.parse("a/b");
        Assertions.assertThat((boolean)this.path.isRoot()).isFalse();
        Assertions.assertThat((boolean)this.path.isSingle()).isFalse();
        Assertions.assertThat((int)this.path.size()).isEqualTo(2);
        Assertions.assertThat((String)this.path.segment(0)).isEqualTo((Object)"a");
        Assertions.assertThat((String)this.path.segment(1)).isEqualTo((Object)"b");
    }

    @Test
    public void shouldParseMultiAbsolutePath() {
        this.path = this.parse("/a/b/c/d/e");
        Assertions.assertThat((boolean)this.path.isRoot()).isFalse();
        Assertions.assertThat((boolean)this.path.isSingle()).isFalse();
        Assertions.assertThat((int)this.path.size()).isEqualTo(5);
        Assertions.assertThat((String)this.path.segment(0)).isEqualTo((Object)"a");
        Assertions.assertThat((String)this.path.segment(1)).isEqualTo((Object)"b");
        Assertions.assertThat((String)this.path.segment(2)).isEqualTo((Object)"c");
        Assertions.assertThat((String)this.path.segment(3)).isEqualTo((Object)"d");
        Assertions.assertThat((String)this.path.segment(4)).isEqualTo((Object)"e");
    }

    protected Path parse(String path) {
        return Paths.parse((String)path, (boolean)false);
    }
}

