/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.serde;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.debezium.data.Envelope;
import io.debezium.serde.DebeziumSerdes;
import io.debezium.util.Testing;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.kafka.common.serialization.Serde;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class SerdeTest
implements Testing {
    private static final int FIELDS_IN_ENVELOPE = Envelope.ALL_FIELD_NAMES.size();

    @Test
    public void simpleKey() {
        Serde keySerde = DebeziumSerdes.payloadJson(Integer.class);
        keySerde.configure(Collections.emptyMap(), true);
        Assertions.assertThat((Integer)((Integer)keySerde.deserializer().deserialize("xx", "{\"payload\": {\"a\": 1}}".getBytes()))).isEqualTo(1);
        Assertions.assertThat((Integer)((Integer)keySerde.deserializer().deserialize("xx", "{\"payload\": 1}".getBytes()))).isEqualTo(1);
        Assertions.assertThat((Integer)((Integer)keySerde.deserializer().deserialize("xx", "{\"payload\": {\"a\": null}}".getBytes()))).isNull();
        Assertions.assertThat((Integer)((Integer)keySerde.deserializer().deserialize("xx", "{\"payload\": null}".getBytes()))).isNull();
        Assertions.assertThat((Integer)((Integer)keySerde.deserializer().deserialize("xx", "{\"a\": 1}".getBytes()))).isEqualTo(1);
        Assertions.assertThat((Integer)((Integer)keySerde.deserializer().deserialize("xx", "1".getBytes()))).isEqualTo(1);
        Assertions.assertThat((Integer)((Integer)keySerde.deserializer().deserialize("xx", "{\"a\": null}".getBytes()))).isNull();
        Assertions.assertThat((Integer)((Integer)keySerde.deserializer().deserialize("xx", "null".getBytes()))).isNull();
    }

    @Test
    public void compositeKey() {
        Serde keySerde = DebeziumSerdes.payloadJson(CompositeKey.class);
        keySerde.configure(Collections.emptyMap(), true);
        Assertions.assertThat((Object)keySerde.deserializer().deserialize("xx", "{\"a\": 1, \"b\": 2}".getBytes())).isEqualTo((Object)new CompositeKey(1, 2));
    }

    @Test
    public void valuePayloadWithSchema() {
        Serde valueSerde = DebeziumSerdes.payloadJson(Customer.class);
        valueSerde.configure(Collections.singletonMap("from.field", "after"), false);
        String content = Testing.Files.readResourceAsString("json/serde-with-schema.json");
        Assertions.assertThat((Object)valueSerde.deserializer().deserialize("xx", content.getBytes())).isEqualTo((Object)new Customer(1004, "Anne", "Kretchmar", "annek@noanswer.org"));
    }

    @Test
    public void valueEnvelopeWithSchema() {
        Serde valueSerde = DebeziumSerdes.payloadJson(HashMap.class);
        valueSerde.configure(Collections.emptyMap(), false);
        String content = Testing.Files.readResourceAsString("json/serde-with-schema.json");
        Map envelope = (Map)valueSerde.deserializer().deserialize("xx", content.getBytes());
        Assertions.assertThat((Map)envelope).hasSize(FIELDS_IN_ENVELOPE - 1);
        Assertions.assertThat((String)((String)envelope.get("op"))).isEqualTo((Object)"c");
    }

    @Test
    public void valuePayloadWithoutSchema() {
        Serde valueSerde = DebeziumSerdes.payloadJson(Customer.class);
        valueSerde.configure(Collections.singletonMap("from.field", "after"), false);
        String content = Testing.Files.readResourceAsString("json/serde-without-schema.json");
        Assertions.assertThat((Object)valueSerde.deserializer().deserialize("xx", content.getBytes())).isEqualTo((Object)new Customer(1004, "Anne", "Kretchmar", "annek@noanswer.org"));
    }

    @Test
    public void valueEnvelopeWithoutSchema() {
        Serde valueSerde = DebeziumSerdes.payloadJson(HashMap.class);
        valueSerde.configure(Collections.emptyMap(), false);
        String content = Testing.Files.readResourceAsString("json/serde-without-schema.json");
        Map envelope = (Map)valueSerde.deserializer().deserialize("xx", content.getBytes());
        Assertions.assertThat((Map)envelope).hasSize(5);
        Assertions.assertThat((String)((String)envelope.get("op"))).isEqualTo((Object)"c");
    }

    @Test
    public void valueBeforeField() {
        Serde valueSerde = DebeziumSerdes.payloadJson(Customer.class);
        valueSerde.configure(Collections.singletonMap("from.field", "before"), false);
        String content = Testing.Files.readResourceAsString("json/serde-update.json");
        Assertions.assertThat((Object)valueSerde.deserializer().deserialize("xx", content.getBytes())).isEqualTo((Object)new Customer(1004, "Anne-Marie", "Kretchmar", "annek@noanswer.org"));
        content = Testing.Files.readResourceAsString("json/serde-without-schema.json");
        Assertions.assertThat((Object)valueSerde.deserializer().deserialize("xx", content.getBytes())).isNull();
    }

    @Test
    public void valueNull() {
        Serde valueSerde = DebeziumSerdes.payloadJson(Customer.class);
        valueSerde.configure(Collections.emptyMap(), false);
        Assertions.assertThat((Object)valueSerde.deserializer().deserialize("xx", "null".getBytes())).isNull();
        Assertions.assertThat((Object)valueSerde.deserializer().deserialize("xx", null)).isNull();
    }

    @Test
    public void valuePayloadUnwrapped() {
        Serde valueSerde = DebeziumSerdes.payloadJson(Customer.class);
        valueSerde.configure(Collections.emptyMap(), false);
        String content = Testing.Files.readResourceAsString("json/serde-unwrapped.json");
        Assertions.assertThat((Object)valueSerde.deserializer().deserialize("xx", content.getBytes())).isEqualTo((Object)new Customer(1004, "Anne", "Kretchmar", "annek@noanswer.org"));
    }

    @Test(expected=RuntimeException.class)
    public void valueWithUnknownPropertyThrowRuntimeException() {
        Serde valueSerde = DebeziumSerdes.payloadJson(Customer.class);
        valueSerde.configure(Collections.singletonMap("from.field", "before"), false);
        String content = Testing.Files.readResourceAsString("json/serde-unknown-property.json");
        Assertions.assertThat((Object)valueSerde.deserializer().deserialize("xx", content.getBytes())).isEqualTo((Object)new Customer(1004, "Anne-Marie", "Kretchmar", "annek@noanswer.org"));
    }

    @Test
    public void valueWithUnknownPropertyIgnored() {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("from.field", "before");
        options.put("unknown.properties.ignored", true);
        Serde valueSerde = DebeziumSerdes.payloadJson(Customer.class);
        valueSerde.configure(options, false);
        String content = Testing.Files.readResourceAsString("json/serde-unknown-property.json");
        Assertions.assertThat((Object)valueSerde.deserializer().deserialize("xx", content.getBytes())).isEqualTo((Object)new Customer(1004, "Anne-Marie", "Kretchmar", "annek@noanswer.org"));
    }

    private static final class CompositeKey {
        public int a;
        public int b;

        public CompositeKey() {
        }

        public CompositeKey(int a, int b) {
            this.a = a;
            this.b = b;
        }

        public int hashCode() {
            return Objects.hash(this.a, this.b);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CompositeKey other = (CompositeKey)obj;
            return this.a == other.a && this.b == other.b;
        }
    }

    private static final class Customer {
        public int id;
        @JsonProperty(value="first_name")
        public String firstName;
        @JsonProperty(value="last_name")
        public String lastName;
        public String email;

        public Customer() {
        }

        public Customer(int id, String firstName, String lastName, String email) {
            this.id = id;
            this.firstName = firstName;
            this.lastName = lastName;
            this.email = email;
        }

        public int hashCode() {
            return Objects.hash(this.email, this.firstName, this.id, this.lastName);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Customer other = (Customer)obj;
            return Objects.equals(this.email, other.email) && Objects.equals(this.firstName, other.firstName) && this.id == other.id && Objects.equals(this.lastName, other.lastName);
        }
    }
}

