/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.mapping;

import io.debezium.relational.Column;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.mapping.MaskStrings;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class MaskStringsTest {
    private final Column column = Column.editor().name("col").jdbcType(12).create();
    private ValueConverter converter;

    @Test
    public void shouldMaskStringsWithAsterisks() {
        String maskValue = "*****";
        this.converter = new MaskStrings(maskValue).create(this.column);
        Assertions.assertThat((String)this.converter.convert((Object)"1234567890").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"123456").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"12345").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"1234").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"123").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"12").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert((Object)"1").toString()).isEqualTo((Object)maskValue);
        Assertions.assertThat((String)this.converter.convert(null).toString()).isEqualTo((Object)maskValue);
    }

    @Test
    public void shouldTransformSameInputsToSameResultsForCharsetType() {
        this.converter = new MaskStrings("salt".getBytes(), "SHA-256", MaskStrings.HashingByteArrayStrategy.V1).create(this.column);
        Assertions.assertThat((Object)this.converter.convert((Object)"hello")).isEqualTo((Object)"af5843a0f0e728ab0332c8888b6e1190bfb79e584f0d40538de8f10df6ef29c6");
        Assertions.assertThat((Object)this.converter.convert((Object)"hello")).isEqualTo((Object)"af5843a0f0e728ab0332c8888b6e1190bfb79e584f0d40538de8f10df6ef29c6");
        Assertions.assertThat((Object)this.converter.convert((Object)"world")).isEqualTo((Object)"4588e1f2dcdc7fefc1515d3acd5acb9033478eace68286f383c337b9ff4464a3");
        Assertions.assertThat((Object)this.converter.convert((Object)"world")).isEqualTo((Object)"4588e1f2dcdc7fefc1515d3acd5acb9033478eace68286f383c337b9ff4464a3");
    }

    @Test
    public void shouldTransformSameInputsToSameResultsForCharsetTypeWithMD5() {
        this.converter = new MaskStrings("salt".getBytes(), "MD5", MaskStrings.HashingByteArrayStrategy.V1).create(this.column);
        Assertions.assertThat((Object)this.converter.convert((Object)"hello")).isEqualTo((Object)"46f48a7a5ea32efba87cbff49d46d35a");
        Assertions.assertThat((Object)this.converter.convert((Object)"world")).isEqualTo((Object)"030f632140d9c9591b0d8c21098024b8");
    }

    @Test
    public void shouldTransformSameInputsToSameResultsForCharsetTypeWithV2() {
        this.converter = new MaskStrings("salt".getBytes(), "SHA-256", MaskStrings.HashingByteArrayStrategy.V2).create(this.column);
        Assertions.assertThat((Object)this.converter.convert((Object)"hello")).isEqualTo((Object)"cd31b3b98ece60cb739c0bf770b2de892ae0ad133f645513c3d83f08757a843a");
        Assertions.assertThat((Object)this.converter.convert((Object)"hello")).isEqualTo((Object)"cd31b3b98ece60cb739c0bf770b2de892ae0ad133f645513c3d83f08757a843a");
        Assertions.assertThat((Object)this.converter.convert((Object)"world")).isEqualTo((Object)"e84ac3142870113ddc6710c06f76421befc8e8ca6de64e98d2993ed8d41f4085");
        Assertions.assertThat((Object)this.converter.convert((Object)"world")).isEqualTo((Object)"e84ac3142870113ddc6710c06f76421befc8e8ca6de64e98d2993ed8d41f4085");
    }

    @Test
    public void shouldTransformSameInputsToSameResultsForCharsetTypeWithMD5AndV2() {
        this.converter = new MaskStrings("salt".getBytes(), "MD5", MaskStrings.HashingByteArrayStrategy.V2).create(this.column);
        Assertions.assertThat((Object)this.converter.convert((Object)"hello")).isEqualTo((Object)"06decc8b095724f80103712c235586be");
        Assertions.assertThat((Object)this.converter.convert((Object)"world")).isEqualTo((Object)"172c8e95398cc72ab5358ead6981e7e5");
    }
}

