/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.pipeline.source.snapshot.incremental;

import io.debezium.config.CommonConnectorConfig;
import io.debezium.config.Configuration;
import io.debezium.connector.SourceInfoStructMaker;
import io.debezium.jdbc.JdbcConnection;
import io.debezium.pipeline.source.snapshot.incremental.IncrementalSnapshotContext;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotChangeEventSource;
import io.debezium.pipeline.source.snapshot.incremental.SignalBasedIncrementalSnapshotContext;
import io.debezium.pipeline.source.spi.DataChangeEventListener;
import io.debezium.pipeline.source.spi.SnapshotProgressListener;
import io.debezium.relational.Column;
import io.debezium.relational.ColumnFilterMode;
import io.debezium.relational.RelationalDatabaseConnectorConfig;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class SignalBasedSnapshotChangeEventSourceTest {
    protected RelationalDatabaseConnectorConfig config() {
        return new RelationalDatabaseConnectorConfig(((Configuration.Builder)Configuration.create().with(RelationalDatabaseConnectorConfig.SIGNAL_DATA_COLLECTION, "debezium.signal")).build(), "core", null, null, 0, ColumnFilterMode.CATALOG){

            protected SourceInfoStructMaker<?> getSourceInfoStructMaker(CommonConnectorConfig.Version version) {
                return null;
            }

            public String getContextName() {
                return null;
            }

            public String getConnectorName() {
                return null;
            }
        };
    }

    @Test
    public void testBuildQueryOnePkColumn() {
        SignalBasedIncrementalSnapshotChangeEventSource source = new SignalBasedIncrementalSnapshotChangeEventSource(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""), null, null, null, SnapshotProgressListener.NO_OP(), DataChangeEventListener.NO_OP());
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        source.setContext((IncrementalSnapshotContext)context);
        Column pk1 = Column.editor().name("pk1").create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1"}).create();
        Assertions.assertThat((String)source.buildChunkQuery(table)).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" ORDER BY \"pk1\" LIMIT 1024");
        context.nextChunkPosition(new Object[]{1, 5});
        context.maximumKey(new Object[]{10, 50});
        Assertions.assertThat((String)source.buildChunkQuery(table)).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE (\"pk1\" > ?) AND NOT (\"pk1\" > ?) ORDER BY \"pk1\" LIMIT 1024");
    }

    @Test
    public void testBuildQueryThreePkColumns() {
        SignalBasedIncrementalSnapshotChangeEventSource source = new SignalBasedIncrementalSnapshotChangeEventSource(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""), null, null, null, SnapshotProgressListener.NO_OP(), DataChangeEventListener.NO_OP());
        SignalBasedIncrementalSnapshotContext context = new SignalBasedIncrementalSnapshotContext();
        source.setContext((IncrementalSnapshotContext)context);
        Column pk1 = Column.editor().name("pk1").create();
        Column pk2 = Column.editor().name("pk2").create();
        Column pk3 = Column.editor().name("pk3").create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(pk2).addColumn(pk3).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1", "pk2", "pk3"}).create();
        Assertions.assertThat((String)source.buildChunkQuery(table)).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" ORDER BY \"pk1\", \"pk2\", \"pk3\" LIMIT 1024");
        context.nextChunkPosition(new Object[]{1, 5});
        context.maximumKey(new Object[]{10, 50});
        Assertions.assertThat((String)source.buildChunkQuery(table)).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" WHERE ((\"pk1\" > ?) OR (\"pk1\" = ? AND \"pk2\" > ?) OR (\"pk1\" = ? AND \"pk2\" = ? AND \"pk3\" > ?)) AND NOT ((\"pk1\" > ?) OR (\"pk1\" = ? AND \"pk2\" > ?) OR (\"pk1\" = ? AND \"pk2\" = ? AND \"pk3\" > ?)) ORDER BY \"pk1\", \"pk2\", \"pk3\" LIMIT 1024");
    }

    @Test
    public void testMaxQuery() {
        SignalBasedIncrementalSnapshotChangeEventSource source = new SignalBasedIncrementalSnapshotChangeEventSource(this.config(), new JdbcConnection(this.config().getJdbcConfig(), config -> null, "\"", "\""), null, null, null, SnapshotProgressListener.NO_OP(), DataChangeEventListener.NO_OP());
        Column pk1 = Column.editor().name("pk1").create();
        Column pk2 = Column.editor().name("pk2").create();
        Column val1 = Column.editor().name("val1").create();
        Column val2 = Column.editor().name("val2").create();
        Table table = Table.editor().tableId(new TableId(null, "s1", "table1")).addColumn(pk1).addColumn(pk2).addColumn(val1).addColumn(val2).setPrimaryKeyNames(new String[]{"pk1", "pk2"}).create();
        Assertions.assertThat((String)source.buildMaxPrimaryKeyQuery(table)).isEqualTo((Object)"SELECT * FROM \"s1\".\"table1\" ORDER BY \"pk1\" DESC, \"pk2\" DESC LIMIT 1");
    }
}

