/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.junit;

public interface DatabaseVersionResolver {
    public DatabaseVersion getVersion();

    public static class DatabaseVersion {
        private final int dbVersionMajor;
        private final int dbVersionMinor;
        private final int dbVersionPatch;

        public DatabaseVersion(int major, int minor, int patch) {
            this.dbVersionMajor = major;
            this.dbVersionMinor = minor;
            this.dbVersionPatch = patch;
        }

        public int getMajor() {
            return this.dbVersionMajor;
        }

        public int getMinor() {
            return this.dbVersionMinor;
        }

        public int getPatch() {
            return this.dbVersionPatch;
        }

        public boolean isLessThan(int major, int minor, int patch) {
            if (this.dbVersionMajor < major) {
                return true;
            }
            if (this.dbVersionMajor == major) {
                if (minor == -1 || this.dbVersionMinor < minor) {
                    return true;
                }
                if (this.dbVersionMinor == minor && (patch == -1 || this.dbVersionPatch < patch)) {
                    return true;
                }
            }
            return false;
        }

        public boolean isLessThanEqualTo(int major, int minor, int patch) {
            return this.isLessThan(major, minor, patch) || this.isEqualTo(major, minor, patch);
        }

        public boolean isEqualTo(int major, int minor, int patch) {
            return !(this.dbVersionMajor != major || minor != -1 && this.dbVersionMinor != minor || patch != -1 && this.dbVersionPatch != patch);
        }

        public boolean isGreaterThanEqualTo(int major, int minor, int patch) {
            return this.isGreaterThan(major, minor, patch) || this.isEqualTo(major, minor, patch);
        }

        public boolean isGreaterThan(int major, int minor, int patch) {
            if (this.dbVersionMajor > major) {
                return true;
            }
            if (this.dbVersionMajor == major) {
                if (minor == -1 || this.dbVersionMinor > minor) {
                    return true;
                }
                if (this.dbVersionMinor == minor && (patch == -1 || this.dbVersionPatch > patch)) {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return this.dbVersionMajor + "." + this.dbVersionMinor + "." + this.dbVersionPatch;
        }
    }
}

