/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.document;

import io.debezium.document.Array;
import io.debezium.document.ArrayReader;
import io.debezium.document.ArraySerdes;
import io.debezium.util.Testing;
import java.io.IOException;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class ArraySerdesTest
implements Testing {
    private static final ArraySerdes SERDES = new ArraySerdes();

    @Test
    public void shouldConvertFromBytesToArray1() throws IOException {
        this.readAsStringAndBytes("json/array1.json");
    }

    @Test
    public void shouldConvertFromBytesToArray2() throws IOException {
        this.readAsStringAndBytes("json/array2.json");
    }

    protected void readAsStringAndBytes(String resourceFile) throws IOException {
        String content = Testing.Files.readResourceAsString(resourceFile);
        Array doc = ArrayReader.defaultReader().readArray(content);
        byte[] bytes = SERDES.serialize("topicA", doc);
        Array reconstituted = SERDES.deserialize("topicA", bytes);
        Assertions.assertThat((Object)reconstituted).isEqualTo((Object)doc);
    }
}

