/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.util.SchemaNameAdjuster;
import java.util.concurrent.atomic.AtomicInteger;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class SchemaNameAdjusterTest {
    @Test
    public void shouldDetermineValidFirstCharacters() {
        String validChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";
        for (int i = 0; i != validChars.length(); ++i) {
            Assertions.assertThat((boolean)SchemaNameAdjuster.isValidFullnameFirstCharacter((char)validChars.charAt(i))).isTrue();
        }
    }

    @Test
    public void shouldDetermineValidNonFirstCharacters() {
        String validChars = ".abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
        for (int i = 0; i != validChars.length(); ++i) {
            Assertions.assertThat((boolean)SchemaNameAdjuster.isValidFullnameNonFirstCharacter((char)validChars.charAt(i))).isTrue();
        }
    }

    @Test
    public void shouldConsiderValidFullnames() {
        this.assertValidFullname("test_server.connector_test.products.Key");
        this.assertValidFullname("t1234.connector_test.products.Key");
    }

    @Test
    public void shouldConsiderInvalidFullnames() {
        this.assertNotValidFullname("test-server.connector_test.products.Key");
    }

    @Test
    public void shouldReportReplacementEveryTime() {
        AtomicInteger counter = new AtomicInteger();
        AtomicInteger conflicts = new AtomicInteger();
        SchemaNameAdjuster.ReplacementOccurred handler = (original, replacement, conflict) -> {
            if (conflict != null) {
                conflicts.incrementAndGet();
            }
            counter.incrementAndGet();
        };
        SchemaNameAdjuster adjuster = SchemaNameAdjuster.create((String)"_", (SchemaNameAdjuster.ReplacementOccurred)handler);
        for (int i = 0; i != 20; ++i) {
            adjuster.adjust("some-invalid-fullname$");
        }
        Assertions.assertThat((int)counter.get()).isEqualTo(20);
        Assertions.assertThat((int)conflicts.get()).isEqualTo(0);
    }

    @Test
    public void shouldReportReplacementOnlyOnce() {
        AtomicInteger counter = new AtomicInteger();
        AtomicInteger conflicts = new AtomicInteger();
        SchemaNameAdjuster.ReplacementOccurred handler = (original, replacement, conflict) -> {
            if (conflict != null) {
                conflicts.incrementAndGet();
            }
            counter.incrementAndGet();
        };
        SchemaNameAdjuster adjuster = SchemaNameAdjuster.create((String)"_", (SchemaNameAdjuster.ReplacementOccurred)handler.firstTimeOnly());
        for (int i = 0; i != 20; ++i) {
            adjuster.adjust("some-invalid-fullname$");
        }
        Assertions.assertThat((int)counter.get()).isEqualTo(1);
        Assertions.assertThat((int)conflicts.get()).isEqualTo(0);
    }

    @Test
    public void shouldReportConflictReplacement() {
        AtomicInteger counter = new AtomicInteger();
        AtomicInteger conflicts = new AtomicInteger();
        SchemaNameAdjuster.ReplacementOccurred handler = (original, replacement, conflict) -> {
            if (conflict != null) {
                conflicts.incrementAndGet();
            }
            counter.incrementAndGet();
        };
        SchemaNameAdjuster adjuster = SchemaNameAdjuster.create((String)"_", (SchemaNameAdjuster.ReplacementOccurred)handler.firstTimeOnly());
        adjuster.adjust("some-invalid-fullname$");
        adjuster.adjust("some-invalid%fullname_");
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
        Assertions.assertThat((int)conflicts.get()).isEqualTo(1);
    }

    protected void assertValidFullname(String fullname) {
        Assertions.assertThat((boolean)SchemaNameAdjuster.isValidFullname((String)fullname)).isTrue();
    }

    protected void assertNotValidFullname(String fullname) {
        Assertions.assertThat((boolean)SchemaNameAdjuster.isValidFullname((String)fullname)).isFalse();
    }
}

