/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.data.Envelope;
import io.debezium.doc.FixFor;
import io.debezium.pipeline.txmetadata.TransactionMonitor;
import io.debezium.transforms.ExtractNewRecordState;
import java.time.Instant;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class ExtractNewRecordStateTest {
    private static final String DROP_TOMBSTONES = "drop.tombstones";
    private static final String HANDLE_DELETES = "delete.handling.mode";
    private static final String ROUTE_BY_FIELD = "route.by.field";
    private static final String ADD_FIELDS = "add.fields";
    private static final String ADD_HEADERS = "add.headers";
    private static final String ADD_FIELDS_PREFIX = "add.fields.prefix";
    private static final String ADD_HEADERS_PREFIX = "add.headers.prefix";
    final Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).field("name", (Schema)SchemaBuilder.string()).build();
    final Schema sourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).build();
    final Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();

    @Test
    public void testTombstoneDroppedByDefault() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord tombstone = new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
            Assertions.assertThat((Object)transform.apply((ConnectRecord)tombstone)).isNull();
        }
    }

    @Test
    public void testTombstoneDroppedConfigured() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(DROP_TOMBSTONES, "true");
            transform.configure(props);
            SourceRecord tombstone = new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
            Assertions.assertThat((Object)transform.apply((ConnectRecord)tombstone)).isNull();
        }
    }

    @Test
    public void testTombstoneForwardConfigured() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(DROP_TOMBSTONES, "false");
            transform.configure(props);
            SourceRecord tombstone = new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
            Assertions.assertThat((Object)transform.apply((ConnectRecord)tombstone)).isEqualTo((Object)tombstone);
        }
    }

    private SourceRecord createDeleteRecord() {
        Schema deleteSourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).field("version", (Schema)SchemaBuilder.string()).build();
        Envelope deleteEnvelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(deleteSourceSchema).build();
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(deleteSourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"myRecord");
        source.put("lsn", (Object)1234);
        source.put("version", (Object)"version!");
        Struct payload = deleteEnvelope.delete((Object)before, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", this.envelope.schema(), (Object)payload);
    }

    private SourceRecord createTombstoneRecord() {
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
    }

    private SourceRecord createCreateRecord() {
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        before.put("id", (Object)1);
        before.put("name", (Object)"myRecord");
        source.put("lsn", (Object)1234);
        Struct payload = this.envelope.create((Object)before, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", this.envelope.schema(), (Object)payload);
    }

    private SourceRecord createUpdateRecord() {
        Struct before = new Struct(this.recordSchema);
        Struct after = new Struct(this.recordSchema);
        Struct source = new Struct(this.sourceSchema);
        Struct transaction = new Struct(TransactionMonitor.TRANSACTION_BLOCK_SCHEMA);
        before.put("id", (Object)1);
        before.put("name", (Object)"myRecord");
        after.put("id", (Object)1);
        after.put("name", (Object)"updatedRecord");
        source.put("lsn", (Object)1234);
        transaction.put("id", (Object)"571");
        transaction.put("total_order", (Object)42L);
        transaction.put("data_collection_order", (Object)42L);
        Struct payload = this.envelope.update((Object)before, after, source, Instant.now());
        payload.put("transaction", (Object)transaction);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", this.envelope.schema(), (Object)payload);
    }

    private SourceRecord createComplexCreateRecord() {
        Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).build();
        Schema sourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).field("version", (Schema)SchemaBuilder.string()).build();
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(sourceSchema).build();
        Struct before = new Struct(recordSchema);
        Struct source = new Struct(sourceSchema);
        before.put("id", (Object)1);
        source.put("lsn", (Object)1234);
        source.put("version", (Object)"version!");
        Struct payload = envelope.create((Object)before, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", envelope.schema(), (Object)payload);
    }

    private SourceRecord createUnknownRecord() {
        Schema recordSchema = SchemaBuilder.struct().name("unknown").field("id", (Schema)SchemaBuilder.int8()).build();
        Struct before = new Struct(recordSchema);
        before.put("id", (Object)1);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", recordSchema, (Object)before);
    }

    private SourceRecord createUnknownUnnamedSchemaRecord() {
        Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).build();
        Struct before = new Struct(recordSchema);
        before.put("id", (Object)1);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", recordSchema, (Object)before);
    }

    private String getSourceRecordHeaderByKey(SourceRecord record, String headerKey) {
        Iterator operationHeader = record.headers().allWithName(headerKey);
        if (!operationHeader.hasNext()) {
            return null;
        }
        Object value = ((Header)operationHeader.next()).value();
        return value != null ? value.toString() : null;
    }

    @Test
    public void testDeleteDroppedByDefault() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)deleteRecord)).isNull();
        }
    }

    @Test
    public void testHandleDeleteDrop() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "drop");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)deleteRecord)).isNull();
        }
    }

    @Test
    public void testHandleDeleteNone() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "none");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord tombstone = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((Object)tombstone.value()).isNull();
        }
    }

    @Test
    public void testHandleDeleteRewrite() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
        }
    }

    @Test
    public void testHandleCreateRewrite() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(ADD_HEADERS, "op");
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"false");
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(1);
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__op");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.CREATE.code());
        }
    }

    @Test
    public void testUnwrapCreateRecord() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Byte)((Struct)unwrapped.value()).getInt8("id")).isEqualTo((byte)1);
        }
    }

    @Test
    public void testIgnoreUnknownRecord() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord unknownRecord = this.createUnknownRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)unknownRecord)).isEqualTo((Object)unknownRecord);
            SourceRecord unnamedSchemaRecord = this.createUnknownUnnamedSchemaRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)unnamedSchemaRecord)).isEqualTo((Object)unnamedSchemaRecord);
        }
    }

    @Test
    @FixFor(value={"DBZ-971"})
    public void testUnwrapPropagatesRecordHeaders() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            createRecord.headers().addString("application/debezium-test-header", "shouldPropagatePreviousRecordHeaders");
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Byte)((Struct)unwrapped.value()).getInt8("id")).isEqualTo((byte)1);
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(1);
            Iterator headers = unwrapped.headers().allWithName("application/debezium-test-header");
            Assertions.assertThat((boolean)headers.hasNext()).isTrue();
            Assertions.assertThat((String)((Header)headers.next()).value().toString()).isEqualTo((Object)"shouldPropagatePreviousRecordHeaders");
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_FIELDS, "op");
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__op")).isEqualTo((Object)Envelope.Operation.CREATE.code());
        }
    }

    @Test
    @FixFor(value={"DBZ-1452", "DBZ-2504"})
    public void testAddFields() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_FIELDS, "op , lsn,id");
            props.put(ADD_FIELDS_PREFIX, "prefix.");
            transform.configure(props);
            SourceRecord updateRecord = this.createUpdateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)updateRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("prefix.op")).isEqualTo((Object)Envelope.Operation.UPDATE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("prefix.lsn")).isEqualTo((Object)1234);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("prefix.id")).isEqualTo((Object)"571");
        }
    }

    @Test
    @FixFor(value={"DBZ-2606"})
    public void testNewFieldAndHeaderMapping() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            String fieldPrefix = "";
            String headerPrefix = "prefix.";
            props.put(ADD_FIELDS, "op:OP, lsn:LSN, id:ID, source.lsn:source_lsn, transaction.total_order:TOTAL_ORDER");
            props.put(ADD_FIELDS_PREFIX, fieldPrefix);
            props.put(ADD_HEADERS, "op, source.lsn:source_lsn, transaction.id:TXN_ID, transaction.total_order:TOTAL_ORDER");
            props.put(ADD_HEADERS_PREFIX, headerPrefix);
            transform.configure(props);
            SourceRecord updateRecord = this.createUpdateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)updateRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "OP")).isEqualTo((Object)Envelope.Operation.UPDATE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "LSN")).isEqualTo((Object)1234);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "ID")).isEqualTo((Object)"571");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "source_lsn")).isEqualTo((Object)1234);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get(fieldPrefix + "TOTAL_ORDER")).isEqualTo((Object)42L);
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(4);
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, headerPrefix + "op");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.UPDATE.code());
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, headerPrefix + "source_lsn");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(1234));
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, headerPrefix + "TXN_ID");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(571L));
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, headerPrefix + "TOTAL_ORDER");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(42L));
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddFieldsForMissingOptionalField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_FIELDS, "op,lsn,id");
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__op")).isEqualTo((Object)Envelope.Operation.CREATE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__lsn")).isEqualTo((Object)1234);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__id")).isEqualTo(null);
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddFieldsSpecifyStruct() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_FIELDS, "op,source.lsn,transaction.id,transaction.total_order");
            transform.configure(props);
            SourceRecord updateRecord = this.createUpdateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)updateRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__op")).isEqualTo((Object)Envelope.Operation.UPDATE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__source_lsn")).isEqualTo((Object)1234);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__transaction_id")).isEqualTo((Object)"571");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__transaction_total_order")).isEqualTo((Object)42L);
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddHeader() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_HEADERS, "op");
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(1);
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__op");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.CREATE.code());
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddHeaders() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_HEADERS, "op , lsn,id");
            transform.configure(props);
            SourceRecord updateRecord = this.createUpdateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)updateRecord);
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(3);
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__op");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.UPDATE.code());
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__lsn");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(1234));
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__id");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(571L));
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddHeadersForMissingOptionalField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_HEADERS, "op,lsn,id");
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(3);
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__op");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.CREATE.code());
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__lsn");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(1234));
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__id");
            Assertions.assertThat((String)headerValue).isNull();
        }
    }

    @Test
    @FixFor(value={"DBZ-1452", "DBZ-2504"})
    public void testAddHeadersSpecifyStruct() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_HEADERS, "op,source.lsn,transaction.id,transaction.total_order");
            props.put(ADD_HEADERS_PREFIX, "prefix.");
            transform.configure(props);
            SourceRecord updateRecord = this.createUpdateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)updateRecord);
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(4);
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, "prefix.op");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.UPDATE.code());
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "prefix.source_lsn");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(1234));
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "prefix.transaction_id");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(571L));
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "prefix.transaction_total_order");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(42L));
        }
    }

    @Test
    public void testAddTopicRoutingField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ROUTE_BY_FIELD, "name");
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrappedCreate = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((String)unwrappedCreate.topic()).isEqualTo((Object)"myRecord");
        }
    }

    @Test
    public void testUpdateTopicRoutingField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ROUTE_BY_FIELD, "name");
            transform.configure(props);
            SourceRecord updateRecord = this.createUpdateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)updateRecord);
            Assertions.assertThat((String)unwrapped.topic()).isEqualTo((Object)"updatedRecord");
        }
    }

    @Test
    public void testDeleteTopicRoutingField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ROUTE_BY_FIELD, "name");
            props.put(HANDLE_DELETES, "none");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            Assertions.assertThat((String)((SourceRecord)transform.apply((ConnectRecord)deleteRecord)).topic()).isEqualTo((Object)"myRecord");
        }
    }

    @Test
    @FixFor(value={"DBZ-1876"})
    public void testAddHeadersHandleDeleteRewriteAndTombstone() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(ADD_HEADERS, "op,source.lsn");
            props.put(DROP_TOMBSTONES, "false");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__op");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.DELETE.code());
            headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__source_lsn");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)String.valueOf(1234));
            SourceRecord tombstone = (SourceRecord)transform.apply((ConnectRecord)this.createTombstoneRecord());
            Assertions.assertThat((String)this.getSourceRecordHeaderByKey(tombstone, "__op")).isEqualTo((Object)Envelope.Operation.DELETE.code());
            Assertions.assertThat((Object)tombstone.value()).isNull();
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testAddFieldNonExistantField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_FIELDS, "nope");
            transform.configure(props);
            SourceRecord createRecord = this.createComplexCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).schema().field("__nope")).isNull();
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddFieldHandleDeleteRewrite() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(ADD_FIELDS, "op");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__op")).isEqualTo((Object)Envelope.Operation.DELETE.code());
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddFieldsHandleDeleteRewrite() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(ADD_FIELDS, "op,lsn");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__op")).isEqualTo((Object)Envelope.Operation.DELETE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__lsn")).isEqualTo((Object)1234);
        }
    }

    @Test
    @FixFor(value={"DBZ-1876"})
    public void testAddFieldsHandleDeleteRewriteAndTombstone() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(ADD_FIELDS, "op,lsn");
            props.put(DROP_TOMBSTONES, "false");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__op")).isEqualTo((Object)Envelope.Operation.DELETE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__lsn")).isEqualTo((Object)1234);
            SourceRecord tombstone = (SourceRecord)transform.apply((ConnectRecord)this.createTombstoneRecord());
            Assertions.assertThat((Object)tombstone.value()).isNull();
        }
    }

    @Test
    @FixFor(value={"DBZ-1452"})
    public void testAddFieldsSpecifyStructHandleDeleteRewrite() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(ADD_FIELDS, "op,source.lsn");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__op")).isEqualTo((Object)Envelope.Operation.DELETE.code());
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__source_lsn")).isEqualTo((Object)1234);
        }
    }

    @Test
    @FixFor(value={"DBZ-1517"})
    public void testSchemaChangeEventWithOperationHeader() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_HEADERS, "op");
            transform.configure(props);
            SourceRecord unknownRecord = this.createUnknownRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)unknownRecord)).isEqualTo((Object)unknownRecord);
            SourceRecord unnamedSchemaRecord = this.createUnknownUnnamedSchemaRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)unnamedSchemaRecord)).isEqualTo((Object)unnamedSchemaRecord);
        }
    }
}

