/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.text;

import io.debezium.text.Position;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class PositionTest {
    private int combinedIndex(int firstIndex, int secondIndex) {
        Position first = new Position(firstIndex, 1, 0);
        Position second = new Position(secondIndex, 1, 0);
        int firstPlusSecond = first.add(second).index();
        int secondPlusFirst = second.add(first).index();
        Assertions.assertThat((int)firstPlusSecond).isEqualTo(secondPlusFirst);
        return firstPlusSecond;
    }

    @Test
    public void shouldAddNoContentPositionToValidPosition() {
        Assertions.assertThat((int)this.combinedIndex(-1, 0)).isEqualTo(0);
        Assertions.assertThat((int)this.combinedIndex(-1, 1)).isEqualTo(1);
        Assertions.assertThat((int)this.combinedIndex(-1, 10)).isEqualTo(10);
    }

    @Test
    public void shouldAddValidPositionToNoContentPosition() {
        Assertions.assertThat((int)this.combinedIndex(0, -1)).isEqualTo(0);
        Assertions.assertThat((int)this.combinedIndex(1, -1)).isEqualTo(1);
        Assertions.assertThat((int)this.combinedIndex(10, -1)).isEqualTo(10);
    }

    @Test
    public void shouldAddValidPositionToValidPosition() {
        Assertions.assertThat((int)this.combinedIndex(1, 1)).isEqualTo(2);
        Assertions.assertThat((int)this.combinedIndex(10, 1)).isEqualTo(11);
        Assertions.assertThat((int)this.combinedIndex(1, 10)).isEqualTo(11);
        Assertions.assertThat((int)this.combinedIndex(10, 10)).isEqualTo(20);
    }

    @Test
    public void shouldAddStartingPositionToStartingPosition() {
        Assertions.assertThat((int)this.combinedIndex(0, 0)).isEqualTo(0);
    }

    @Test
    public void shouldAddNoContentPositionToNoContentPosition() {
        Assertions.assertThat((int)this.combinedIndex(-1, -1)).isEqualTo(-1);
        Assertions.assertThat((int)this.combinedIndex(-10, -1)).isEqualTo(-1);
        Assertions.assertThat((int)this.combinedIndex(-1, -10)).isEqualTo(-1);
    }
}

