/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.document.DocumentReader;
import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.history.HistoryRecord;
import io.debezium.relational.history.JsonTableChangeSerializer;
import io.debezium.relational.history.TableChanges;
import io.debezium.util.Collect;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class HistoryRecordTest {
    @Test
    public void canSerializeAndDeserializeHistoryRecord() throws Exception {
        Map source = Collect.linkMapOf((Object)"server", (Object)"abc");
        Map position = Collect.linkMapOf((Object)"file", (Object)"x.log", (Object)"positionInt", (Object)100, (Object)"positionLong", (Object)Long.MAX_VALUE, (Object)"entry", (Object)1);
        String databaseName = "db";
        String schemaName = "myschema";
        String ddl = "CREATE TABLE foo ( first VARCHAR(22) NOT NULL );";
        Table table = Table.editor().tableId(new TableId(databaseName, schemaName, "foo")).addColumn(Column.editor().name("first").jdbcType(12).type("VARCHAR").length(22).optional(false).create()).setPrimaryKeyNames(new String[]{"first"}).create();
        TableChanges tableChanges = new TableChanges().create(table);
        HistoryRecord record = new HistoryRecord(source, position, databaseName, schemaName, ddl, tableChanges);
        String serialized = record.toString();
        DocumentReader reader = DocumentReader.defaultReader();
        HistoryRecord deserialized = new HistoryRecord(reader.read(serialized));
        Assertions.assertThat((Iterable)deserialized.source()).isNotNull();
        Assertions.assertThat((Object)deserialized.source().get((CharSequence)"server")).isEqualTo((Object)"abc");
        Assertions.assertThat((Iterable)deserialized.position()).isNotNull();
        Assertions.assertThat((Object)deserialized.position().get((CharSequence)"file")).isEqualTo((Object)"x.log");
        Assertions.assertThat((Object)deserialized.position().get((CharSequence)"positionInt")).isEqualTo((Object)100);
        Assertions.assertThat((Object)deserialized.position().get((CharSequence)"positionLong")).isEqualTo((Object)Long.MAX_VALUE);
        Assertions.assertThat((Object)deserialized.position().get((CharSequence)"entry")).isEqualTo((Object)1);
        Assertions.assertThat((String)deserialized.databaseName()).isEqualTo((Object)databaseName);
        Assertions.assertThat((String)deserialized.schemaName()).isEqualTo((Object)schemaName);
        Assertions.assertThat((String)deserialized.ddl()).isEqualTo((Object)ddl);
        System.out.println(record);
        JsonTableChangeSerializer tableChangesSerializer = new JsonTableChangeSerializer();
        Assertions.assertThat((Object)tableChangesSerializer.deserialize((Object)deserialized.tableChanges(), true)).isEqualTo((Object)tableChanges);
    }
}

