/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.converters;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.connect.avro.AvroConverter;
import io.confluent.kafka.schemaregistry.client.MockSchemaRegistryClient;
import io.confluent.kafka.schemaregistry.client.SchemaRegistryClient;
import io.debezium.config.Configuration;
import io.debezium.converters.CloudEventsConverter;
import io.debezium.data.SchemaUtil;
import io.debezium.util.Testing;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import org.apache.kafka.connect.data.SchemaAndValue;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.json.JsonDeserializer;
import org.apache.kafka.connect.source.SourceRecord;
import org.apache.kafka.connect.storage.Converter;
import org.fest.assertions.Assertions;
import org.junit.Assert;

public class CloudEventsConverterTest {
    public static void shouldConvertToCloudEventsInJson(SourceRecord record, boolean hasTransaction) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serializer.type", "json");
        config.put("data.serializer.type", "json");
        config.put("json.schemas.enable", Boolean.TRUE.toString());
        config.put("json.schemas.cache.size", String.valueOf(100));
        CloudEventsConverter cloudEventsConverter = new CloudEventsConverter();
        cloudEventsConverter.configure(config, false);
        JsonNode valueJson = null;
        String msg = null;
        try {
            if (record.key() != null) {
                msg = "checking key is not null";
                Assertions.assertThat((Object)record.key()).isNotNull();
                Assertions.assertThat((Object)record.keySchema()).isNotNull();
            } else {
                msg = "checking key schema and key are both null";
                Assertions.assertThat((Object)record.key()).isNull();
                Assertions.assertThat((Object)record.keySchema()).isNull();
            }
            if (record.value() == null) {
                msg = "checking value schema is null";
                Assertions.assertThat((Object)record.valueSchema()).isNull();
                msg = "checking key is not null when value is null";
                Assertions.assertThat((Object)record.key()).isNotNull();
            } else {
                msg = "checking value schema is not null";
                Assertions.assertThat((Object)record.valueSchema()).isNotNull();
            }
            msg = "converting value using CloudEvents JSON converter";
            byte[] valueBytes = cloudEventsConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
            msg = "deserializing value using JSON deserializer";
            try (JsonDeserializer jsonDeserializer = new JsonDeserializer();){
                jsonDeserializer.configure(Collections.emptyMap(), false);
                valueJson = jsonDeserializer.deserialize(record.topic(), valueBytes);
            }
            msg = "inspecting all required CloudEvents fields in the value";
            Assertions.assertThat((Iterable)valueJson.get("id")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("source")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("specversion")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("dataschema")).isNull();
            Assertions.assertThat((Iterable)valueJson.get("type")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("datacontenttype")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("time")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("data")).isNotNull();
            msg = "inspecting required CloudEvents extension attributes for Debezium";
            Assertions.assertThat((Iterable)valueJson.get("iodebeziumop")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("iodebeziumtsms")).isNotNull();
            if (hasTransaction) {
                msg = "inspecting transaction metadata attributes";
                Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxid")).isNotNull();
                Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxtotalorder")).isNotNull();
                Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxdatacollectionorder")).isNotNull();
            }
            msg = "inspecting the data field in the value";
            JsonNode dataJson = valueJson.get("data");
            Assertions.assertThat((Iterable)dataJson.get("schema")).isNotNull();
            Assertions.assertThat((Iterable)dataJson.get("payload")).isNotNull();
            Assertions.assertThat((Iterable)dataJson.get("payload").get("after")).isNotNull();
        }
        catch (Throwable t) {
            Testing.Print.enable();
            Testing.print("Problem with message on topic '" + record.topic() + "':");
            Testing.printError(t);
            Testing.print("error " + msg);
            Testing.print("  value: " + SchemaUtil.asString((Object)record.value()));
            Testing.print("  value deserialized from CloudEvents in JSON: " + CloudEventsConverterTest.prettyJson(valueJson));
            if (t instanceof AssertionError) {
                throw t;
            }
            Assert.fail((String)("error " + msg + ": " + t.getMessage()));
        }
    }

    public static void shouldConvertToCloudEventsInJsonWithDataAsAvro(SourceRecord record, boolean hasTransaction) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serializer.type", "json");
        config.put("data.serializer.type", "avro");
        config.put("avro.schema.registry.url", "http://fake-url");
        MockSchemaRegistryClient ceSchemaRegistry = new MockSchemaRegistryClient();
        AvroConverter avroConverter = new AvroConverter((SchemaRegistryClient)ceSchemaRegistry);
        avroConverter.configure(Configuration.from(config).subset("avro", true).asMap(), false);
        CloudEventsConverter cloudEventsConverter = new CloudEventsConverter((Converter)avroConverter);
        cloudEventsConverter.configure(config, false);
        JsonNode valueJson = null;
        String msg = null;
        try {
            if (record.key() != null) {
                msg = "checking key is not null";
                Assertions.assertThat((Object)record.key()).isNotNull();
                Assertions.assertThat((Object)record.keySchema()).isNotNull();
            } else {
                msg = "checking key schema and key are both null";
                Assertions.assertThat((Object)record.key()).isNull();
                Assertions.assertThat((Object)record.keySchema()).isNull();
            }
            if (record.value() == null) {
                msg = "checking value schema is null";
                Assertions.assertThat((Object)record.valueSchema()).isNull();
                msg = "checking key is not null when value is null";
                Assertions.assertThat((Object)record.key()).isNotNull();
            } else {
                msg = "checking value schema is not null";
                Assertions.assertThat((Object)record.valueSchema()).isNotNull();
            }
            msg = "converting value using CloudEvents JSON converter";
            byte[] valueBytes = cloudEventsConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
            msg = "deserializing value using JSON deserializer";
            try (JsonDeserializer jsonDeserializer = new JsonDeserializer();){
                jsonDeserializer.configure(Collections.emptyMap(), false);
                valueJson = jsonDeserializer.deserialize(record.topic(), valueBytes);
            }
            msg = "inspecting all required CloudEvents fields in the value";
            Assertions.assertThat((Iterable)valueJson.get("id")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("source")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("specversion")).isNotNull();
            Assertions.assertThat((String)valueJson.get("datacontenttype").asText()).isEqualTo((Object)"application/avro");
            Assertions.assertThat((String)valueJson.get("dataschema").asText()).startsWith("http://fake-url/schemas/ids/");
            Assertions.assertThat((Iterable)valueJson.get("type")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("time")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("data")).isNotNull();
            msg = "inspecting required CloudEvents extension attributes for Debezium";
            Assertions.assertThat((Iterable)valueJson.get("iodebeziumop")).isNotNull();
            Assertions.assertThat((Iterable)valueJson.get("iodebeziumtsms")).isNotNull();
            if (hasTransaction) {
                msg = "inspecting transaction metadata attributes";
                Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxid")).isNotNull();
                Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxtotalorder")).isNotNull();
                Assertions.assertThat((Iterable)valueJson.get("iodebeziumtxdatacollectionorder")).isNotNull();
            }
            msg = "inspecting the data field in the value";
            JsonNode dataJson = valueJson.get("data");
            Assertions.assertThat((Iterable)dataJson).isNotNull();
            avroConverter.configure(Collections.singletonMap("schema.registry.url", "http://fake-url"), false);
            SchemaAndValue data = avroConverter.toConnectData(record.topic(), Base64.getDecoder().decode(dataJson.asText()));
            Assertions.assertThat((Object)data.value()).isInstanceOf(Struct.class);
            Assertions.assertThat((Object)((Struct)data.value()).get("after")).isNotNull();
        }
        catch (Throwable t) {
            Testing.Print.enable();
            Testing.print("Problem with message on topic '" + record.topic() + "':");
            Testing.printError(t);
            Testing.print("error " + msg);
            Testing.print("  value: " + SchemaUtil.asString((Object)record.value()));
            Testing.print("  value deserialized from CloudEvents in JSON: " + CloudEventsConverterTest.prettyJson(valueJson));
            if (t instanceof AssertionError) {
                throw t;
            }
            Assert.fail((String)("error " + msg + ": " + t.getMessage()));
        }
    }

    public static void shouldConvertToCloudEventsInAvro(SourceRecord record, String connectorName, String serverName, boolean hasTransaction) {
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("serializer.type", "avro");
        config.put("data.serializer.type", "avro");
        config.put("avro.schema.registry.url", "http://fake-url");
        MockSchemaRegistryClient ceSchemaRegistry = new MockSchemaRegistryClient();
        AvroConverter avroConverter = new AvroConverter((SchemaRegistryClient)ceSchemaRegistry);
        avroConverter.configure(Configuration.from(config).subset("avro", true).asMap(), false);
        CloudEventsConverter cloudEventsConverter = new CloudEventsConverter((Converter)avroConverter);
        cloudEventsConverter.configure(config, false);
        SchemaAndValue avroSchemaAndValue = null;
        String msg = null;
        try {
            if (record.key() != null) {
                msg = "checking key is not null";
                Assertions.assertThat((Object)record.key()).isNotNull();
                Assertions.assertThat((Object)record.keySchema()).isNotNull();
            } else {
                msg = "checking key schema and key are both null";
                Assertions.assertThat((Object)record.key()).isNull();
                Assertions.assertThat((Object)record.keySchema()).isNull();
            }
            if (record.value() == null) {
                msg = "checking value schema is null";
                Assertions.assertThat((Object)record.valueSchema()).isNull();
                msg = "checking key is not null when value is null";
                Assertions.assertThat((Object)record.key()).isNotNull();
            } else {
                msg = "checking value schema is not null";
                Assertions.assertThat((Object)record.valueSchema()).isNotNull();
            }
            msg = "converting value using CloudEvents Avro converter";
            byte[] valueBytes = cloudEventsConverter.fromConnectData(record.topic(), record.valueSchema(), record.value());
            msg = "deserializing value using Avro deserializer";
            avroSchemaAndValue = cloudEventsConverter.toConnectData(record.topic(), valueBytes);
            msg = "inspecting all required CloudEvents fields in the value";
            Struct avroValue = (Struct)avroSchemaAndValue.value();
            Assertions.assertThat((Object)avroValue.get("id")).isNotNull();
            Assertions.assertThat((String)avroValue.getString("source")).isEqualTo((Object)("/debezium/" + connectorName + "/" + serverName));
            Assertions.assertThat((Object)avroValue.get("specversion")).isEqualTo((Object)"1.0");
            Assertions.assertThat((Object)avroValue.get("type")).isEqualTo((Object)("io.debezium." + connectorName + ".datachangeevent"));
            Assertions.assertThat((Object)avroValue.get("datacontenttype")).isEqualTo((Object)"application/avro");
            Assertions.assertThat((String)avroValue.getString("dataschema")).startsWith("http://fake-url/schemas/ids/");
            Assertions.assertThat((Object)avroValue.get("time")).isNotNull();
            Assertions.assertThat((Object)avroValue.get("data")).isNotNull();
            msg = "inspecting required CloudEvents extension attributes in the value";
            Assertions.assertThat((Object)avroValue.get(CloudEventsConverter.adjustExtensionName((String)"op"))).isNotNull();
            Assertions.assertThat((Object)avroValue.get(CloudEventsConverter.adjustExtensionName((String)"ts_ms"))).isNotNull();
            if (hasTransaction) {
                msg = "inspecting transaction metadata attributes";
                Assertions.assertThat((Object)avroValue.get("iodebeziumtxid")).isNotNull();
                Assertions.assertThat((Object)avroValue.get("iodebeziumtxtotalorder")).isNotNull();
                Assertions.assertThat((Object)avroValue.get("iodebeziumtxdatacollectionorder")).isNotNull();
            }
            msg = "inspecting the data field in the value";
            Struct avroDataField = avroValue.getStruct("data");
            Assertions.assertThat((Object)avroDataField.schema().field("after")).isNotNull();
        }
        catch (Throwable t) {
            Testing.Print.enable();
            Testing.print("Problem with message on topic '" + record.topic() + "':");
            Testing.printError(t);
            Testing.print("error " + msg);
            Testing.print("  value: " + SchemaUtil.asString((Object)record.value()));
            if (avroSchemaAndValue != null) {
                Testing.print("  value to/from Avro: " + SchemaUtil.asString((Object)avroSchemaAndValue.value()));
            }
            if (t instanceof AssertionError) {
                throw t;
            }
            Assert.fail((String)("error " + msg + ": " + t.getMessage()));
        }
    }

    private static String prettyJson(JsonNode json) {
        try {
            return new ObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString((Object)json);
        }
        catch (Throwable t) {
            Testing.printError(t);
            Assert.fail((String)t.getMessage());
            assert (false) : "Will not get here";
            return null;
        }
    }
}

