/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.DebeziumException;
import io.debezium.data.Envelope;
import io.debezium.transforms.Filter;
import java.time.Instant;
import java.util.HashMap;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class FilterTest {
    private static final String LANGUAGE = "language";
    private static final String EXPRESSION = "condition";
    private static final String NULL_HANDLING = "null.handling.mode";
    final Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).field("name", (Schema)SchemaBuilder.string()).build();
    final Schema sourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).build();
    final Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(this.sourceSchema).build();

    @Test(expected=DebeziumException.class)
    public void testLanguageRequired() {
        try (Filter transform = new Filter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(EXPRESSION, "operation != 'd'");
            transform.configure(props);
        }
    }

    @Test(expected=DebeziumException.class)
    public void testExpressionRequired() {
        try (Filter transform = new Filter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(LANGUAGE, "jsr223.groovy");
            transform.configure(props);
        }
    }

    @Test(expected=DebeziumException.class)
    public void shouldFailOnUnkownLanguage() {
        try (Filter transform = new Filter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(EXPRESSION, "operation != 'd'");
            props.put(LANGUAGE, "jsr223.jython");
            transform.configure(props);
        }
    }

    @Test(expected=DebeziumException.class)
    public void shouldFailToParseCondition() {
        try (Filter transform = new Filter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(EXPRESSION, "operation != 'd");
            props.put(LANGUAGE, "jsr223.groovy");
            transform.configure(props);
        }
    }

    @Test
    public void shouldProcessCondition() {
        try (Filter transform = new Filter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(EXPRESSION, "value.op != 'd' || value.before.id != 2");
            props.put(LANGUAGE, "jsr223.groovy");
            transform.configure(props);
            SourceRecord record = this.createDeleteRecord(1);
            Assertions.assertThat((Object)transform.apply((ConnectRecord)this.createDeleteRecord(2))).isNull();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)record)).isSameAs((Object)record);
        }
    }

    @Test
    public void shouldKeepNulls() {
        try (Filter transform = new Filter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(EXPRESSION, "value.op != 'd' || value.before.id != 2");
            props.put(LANGUAGE, "jsr223.groovy");
            transform.configure(props);
            SourceRecord record = this.createNullRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)record)).isSameAs((Object)record);
        }
    }

    @Test
    public void shouldDropNulls() {
        try (Filter transform = new Filter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(EXPRESSION, "value.op != 'd' || value.before.id != 2");
            props.put(LANGUAGE, "jsr223.groovy");
            props.put(NULL_HANDLING, "drop");
            transform.configure(props);
            SourceRecord record = this.createNullRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)record)).isNull();
        }
    }

    @Test(expected=DebeziumException.class)
    public void shouldEvaluateNulls() {
        try (Filter transform = new Filter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(EXPRESSION, "value.op != 'd' || value.before.id != 2");
            props.put(LANGUAGE, "jsr223.groovy");
            props.put(NULL_HANDLING, "evaluate");
            transform.configure(props);
            SourceRecord record = this.createNullRecord();
            transform.apply((ConnectRecord)record);
        }
    }

    private SourceRecord createDeleteRecord(int id) {
        Schema deleteSourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).field("version", (Schema)SchemaBuilder.string()).build();
        Envelope deleteEnvelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(this.recordSchema).withSource(deleteSourceSchema).build();
        Struct before = new Struct(this.recordSchema);
        Struct source = new Struct(deleteSourceSchema);
        before.put("id", (Object)((byte)id));
        before.put("name", (Object)"myRecord");
        source.put("lsn", (Object)1234);
        source.put("version", (Object)"version!");
        Struct payload = deleteEnvelope.delete((Object)before, source, Instant.now());
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", this.envelope.schema(), (Object)payload);
    }

    private SourceRecord createNullRecord() {
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null, null, null);
    }

    @Test
    public void shouldRunJavaScript() {
        try (Filter transform = new Filter();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(EXPRESSION, "value.get('op') != 'd' || value.get('before').get('id') != 2");
            props.put(LANGUAGE, "jsr223.graal.js");
            transform.configure(props);
            SourceRecord record = this.createDeleteRecord(1);
            Assertions.assertThat((Object)transform.apply((ConnectRecord)this.createDeleteRecord(2))).isNull();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)record)).isSameAs((Object)record);
        }
    }
}

