/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.junit;

import io.debezium.junit.AnnotationBasedTestRule;
import io.debezium.junit.SkipLongRunning;
import io.debezium.junit.SkipOnOS;
import io.debezium.junit.SkipWhenKafkaVersion;
import io.debezium.util.Testing;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SkipTestRule
extends AnnotationBasedTestRule {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Statement apply(Statement base, Description description) {
        SkipWhenKafkaVersion skipWhenKafkaVersionAnnotation;
        SkipOnOS skipOnOSAnnotation;
        SkipLongRunning skipLongRunningAnnotation = this.hasAnnotation(description, SkipLongRunning.class);
        if (skipLongRunningAnnotation != null) {
            String skipLongRunning = System.getProperty("skipLongRunningTests");
            if (skipLongRunning == null) return SkipTestRule.emptyStatement(skipLongRunningAnnotation.value(), description);
            if (Boolean.valueOf(skipLongRunning).booleanValue()) {
                return SkipTestRule.emptyStatement(skipLongRunningAnnotation.value(), description);
            }
        }
        if ((skipOnOSAnnotation = this.hasAnnotation(description, SkipOnOS.class)) != null) {
            String[] oses = skipOnOSAnnotation.value();
            String osName = System.getProperty("os.name");
            if (osName != null && !osName.trim().isEmpty()) {
                for (String os : oses) {
                    if (!osName.toLowerCase().startsWith(os.toLowerCase())) continue;
                    return SkipTestRule.emptyStatement(skipOnOSAnnotation.description(), description);
                }
            }
        }
        if ((skipWhenKafkaVersionAnnotation = this.hasAnnotation(description, SkipWhenKafkaVersion.class)) == null) return base;
        SkipWhenKafkaVersion.KafkaVersion kafkaVersion = skipWhenKafkaVersionAnnotation.value();
        SkipWhenKafkaVersion.EqualityCheck check = skipWhenKafkaVersionAnnotation.check();
        try (InputStream stream = Testing.class.getResourceAsStream("/kafka/kafka-version.properties");){
            if (stream == null) return base;
            Properties properties = new Properties();
            properties.load(stream);
            String version = properties.getProperty("version");
            String[] versionArray = version.split("\\.");
            int major = versionArray.length >= 1 ? Integer.parseInt(versionArray[0]) : 0;
            int minor = versionArray.length >= 2 ? Integer.parseInt(versionArray[1]) : 1;
            int patch = versionArray.length >= 3 ? Integer.parseInt(versionArray[2]) : 2;
            switch (check) {
                case LESS_THAN: {
                    if (!kafkaVersion.isLessThan(major, minor, patch)) return base;
                    Statement statement = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                    return statement;
                }
                case LESS_THAN_OR_EQUAL: {
                    if (!kafkaVersion.isLessThanOrEqualTo(major, minor, patch)) return base;
                    Statement statement = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                    return statement;
                }
                case EQUAL: {
                    if (!kafkaVersion.isEqualTo(major, minor, patch)) return base;
                    Statement statement = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                    return statement;
                }
                case GREATER_THAN_OR_EQUAL: {
                    if (!kafkaVersion.isGreaterThanOrEqualTo(major, minor, patch)) return base;
                    Statement statement = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                    return statement;
                }
                case GREATER_THAN: {
                    if (!kafkaVersion.isGreaterThan(major, minor, patch)) return base;
                    Statement statement = SkipTestRule.emptyStatement(skipWhenKafkaVersionAnnotation.description(), description);
                    return statement;
                }
            }
            return base;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return base;
    }
}

