/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.annotation.Immutable;
import io.debezium.util.Iterators;
import java.util.Iterator;
import java.util.Random;
import java.util.function.Supplier;
import java.util.stream.IntStream;

@Immutable
public class Sequences {
    public static IntStream times(int number) {
        return IntStream.range(0, number);
    }

    public static Iterable<Integer> infiniteIntegers() {
        return Sequences.infiniteIntegers(0);
    }

    public static Iterable<Integer> infiniteIntegers(final int startingAt) {
        return Iterators.around(new Iterator<Integer>(){
            private int counter;
            {
                this.counter = startingAt;
            }

            @Override
            public boolean hasNext() {
                return true;
            }

            @Override
            public Integer next() {
                return this.counter++;
            }
        });
    }

    @SafeVarargs
    public static <T> Supplier<T> randomlySelect(T first, T ... additional) {
        if (additional == null || additional.length == 0) {
            return () -> first;
        }
        Random rng = new Random(System.currentTimeMillis());
        int max = additional.length + 1;
        return () -> {
            int index = rng.nextInt(max);
            return index == 0 ? first : additional[index - 1];
        };
    }

    @SafeVarargs
    public static <T> Supplier<T> randomlySelect(T ... values) {
        if (values == null || values.length == 0) {
            throw new IllegalArgumentException("The values array may not be null or empty");
        }
        Random rng = new Random(System.currentTimeMillis());
        return () -> values[rng.nextInt(values.length)];
    }
}

