/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.data.Envelope;
import io.debezium.doc.FixFor;
import io.debezium.transforms.ExtractNewRecordState;
import io.debezium.transforms.UnwrapFromEnvelope;
import java.util.HashMap;
import java.util.Iterator;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.connect.connector.ConnectRecord;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;
import org.apache.kafka.connect.data.Struct;
import org.apache.kafka.connect.header.Header;
import org.apache.kafka.connect.source.SourceRecord;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class ExtractNewRecordStateTest {
    private static final String DROP_TOMBSTONES = "drop.tombstones";
    private static final String HANDLE_DELETES = "delete.handling.mode";
    private static final String OPERATION_HEADER = "operation.header";
    private static final String ADD_SOURCE_FIELDS = "add.source.fields";

    @Test
    public void testTombstoneDroppedByDefault() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord tombstone = new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
            Assertions.assertThat((Object)transform.apply((ConnectRecord)tombstone)).isNull();
        }
    }

    @Test
    public void testTombstoneDroppedConfigured() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(DROP_TOMBSTONES, "true");
            transform.configure(props);
            SourceRecord tombstone = new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
            Assertions.assertThat((Object)transform.apply((ConnectRecord)tombstone)).isNull();
        }
    }

    @Test
    public void testTombstoneForwardConfigured() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(DROP_TOMBSTONES, "false");
            transform.configure(props);
            SourceRecord tombstone = new SourceRecord(new HashMap(), new HashMap(), "dummy", null, null);
            Assertions.assertThat((Object)transform.apply((ConnectRecord)tombstone)).isEqualTo((Object)tombstone);
        }
    }

    private SourceRecord createDeleteRecord() {
        Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).build();
        Schema sourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).field("version", (Schema)SchemaBuilder.string()).build();
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(sourceSchema).build();
        Struct before = new Struct(recordSchema);
        Struct source = new Struct(sourceSchema);
        before.put("id", (Object)1);
        source.put("lsn", (Object)1234);
        source.put("version", (Object)"version!");
        Struct payload = envelope.delete((Object)before, source, Long.valueOf(System.nanoTime()));
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", envelope.schema(), (Object)payload);
    }

    private SourceRecord createCreateRecord() {
        Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).build();
        Schema sourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).build();
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(sourceSchema).build();
        Struct before = new Struct(recordSchema);
        Struct source = new Struct(sourceSchema);
        before.put("id", (Object)1);
        source.put("lsn", (Object)1234);
        Struct payload = envelope.create((Object)before, source, Long.valueOf(System.nanoTime()));
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", envelope.schema(), (Object)payload);
    }

    private SourceRecord createComplexCreateRecord() {
        Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).build();
        Schema sourceSchema = SchemaBuilder.struct().field("lsn", (Schema)SchemaBuilder.int32()).field("version", (Schema)SchemaBuilder.string()).build();
        Envelope envelope = Envelope.defineSchema().withName("dummy.Envelope").withRecord(recordSchema).withSource(sourceSchema).build();
        Struct before = new Struct(recordSchema);
        Struct source = new Struct(sourceSchema);
        before.put("id", (Object)1);
        source.put("lsn", (Object)1234);
        source.put("version", (Object)"version!");
        Struct payload = envelope.create((Object)before, source, Long.valueOf(System.nanoTime()));
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", envelope.schema(), (Object)payload);
    }

    private SourceRecord createUnknownRecord() {
        Schema recordSchema = SchemaBuilder.struct().name("unknown").field("id", (Schema)SchemaBuilder.int8()).build();
        Struct before = new Struct(recordSchema);
        before.put("id", (Object)1);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", recordSchema, (Object)before);
    }

    private SourceRecord createUnknownUnnamedSchemaRecord() {
        Schema recordSchema = SchemaBuilder.struct().field("id", (Schema)SchemaBuilder.int8()).build();
        Struct before = new Struct(recordSchema);
        before.put("id", (Object)1);
        return new SourceRecord(new HashMap(), new HashMap(), "dummy", recordSchema, (Object)before);
    }

    private String getSourceRecordHeaderByKey(SourceRecord record, String headerKey) {
        Iterator operationHeader = record.headers().allWithName(headerKey);
        if (!operationHeader.hasNext()) {
            return null;
        }
        return ((Header)operationHeader.next()).value().toString();
    }

    @Test
    public void testDeleteDroppedByDefault() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)deleteRecord)).isNull();
        }
    }

    @Test
    public void testHandleDeleteDrop() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "drop");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)deleteRecord)).isNull();
        }
    }

    @Test
    public void testHandleDeleteNone() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "none");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord tombstone = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((Object)tombstone.value()).isNull();
        }
    }

    @Test
    public void testHandleDeleteRewrite() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
        }
    }

    @Test
    public void testHandleCreateRewrite() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(OPERATION_HEADER, "true");
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"false");
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(1);
            String headerValue = this.getSourceRecordHeaderByKey(unwrapped, "__debezium-operation");
            Assertions.assertThat((String)headerValue).isEqualTo((Object)Envelope.Operation.CREATE.code());
        }
    }

    @Test
    public void testUnwrapCreateRecord() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Byte)((Struct)unwrapped.value()).getInt8("id")).isEqualTo((byte)1);
        }
    }

    @Test
    public void testIgnoreUnknownRecord() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord unknownRecord = this.createUnknownRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)unknownRecord)).isEqualTo((Object)unknownRecord);
            SourceRecord unnamedSchemaRecord = this.createUnknownUnnamedSchemaRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)unnamedSchemaRecord)).isEqualTo((Object)unnamedSchemaRecord);
        }
    }

    @Test
    @FixFor(value={"DBZ-971"})
    public void testUnwrapPropagatesRecordHeaders() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            createRecord.headers().addString("application/debezium-test-header", "shouldPropagatePreviousRecordHeaders");
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Byte)((Struct)unwrapped.value()).getInt8("id")).isEqualTo((byte)1);
            Assertions.assertThat((Iterable)unwrapped.headers()).hasSize(1);
            Iterator headers = unwrapped.headers().allWithName("application/debezium-test-header");
            Assertions.assertThat((boolean)headers.hasNext()).isTrue();
            Assertions.assertThat((String)((Header)headers.next()).value().toString()).isEqualTo((Object)"shouldPropagatePreviousRecordHeaders");
        }
    }

    @Test
    @FixFor(value={"DBZ-677"})
    public void canUseDeprecatedSmt() {
        try (UnwrapFromEnvelope transform = new UnwrapFromEnvelope();){
            HashMap props = new HashMap();
            transform.configure(props);
            SourceRecord createRecord = this.createCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Byte)((Struct)unwrapped.value()).getInt8("id")).isEqualTo((byte)1);
        }
    }

    @Test
    public void testAddSourceField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_SOURCE_FIELDS, "lsn");
            transform.configure(props);
            SourceRecord createRecord = this.createComplexCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__lsn")).isEqualTo((Object)1234);
        }
    }

    @Test
    public void testAddSourceFields() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_SOURCE_FIELDS, "lsn,version");
            transform.configure(props);
            SourceRecord createRecord = this.createComplexCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__lsn")).isEqualTo((Object)1234);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__version")).isEqualTo((Object)"version!");
        }
    }

    @Test(expected=ConfigException.class)
    public void testAddSourceNonExistantField() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(ADD_SOURCE_FIELDS, "nope");
            transform.configure(props);
            SourceRecord createRecord = this.createComplexCreateRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)createRecord);
            Assertions.assertThat((Object)((Struct)unwrapped.value()).schema().field("__nope")).isNull();
        }
    }

    @Test
    @FixFor(value={"DBZ-1448"})
    public void testAddSourceFieldHandleDeleteRewrite() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(ADD_SOURCE_FIELDS, "lsn");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__lsn")).isEqualTo((Object)1234);
        }
    }

    @Test
    @FixFor(value={"DBZ-1448"})
    public void testAddSourceFieldsHandleDeleteRewrite() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(HANDLE_DELETES, "rewrite");
            props.put(ADD_SOURCE_FIELDS, "lsn,version");
            transform.configure(props);
            SourceRecord deleteRecord = this.createDeleteRecord();
            SourceRecord unwrapped = (SourceRecord)transform.apply((ConnectRecord)deleteRecord);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__deleted")).isEqualTo((Object)"true");
            Assertions.assertThat((Object)((Struct)unwrapped.value()).get("__lsn")).isEqualTo((Object)1234);
            Assertions.assertThat((String)((Struct)unwrapped.value()).getString("__version")).isEqualTo((Object)"version!");
        }
    }

    @Test
    @FixFor(value={"DBZ-1517"})
    public void testSchemaChangeEventWithOperationHeader() {
        try (ExtractNewRecordState transform = new ExtractNewRecordState();){
            HashMap<String, String> props = new HashMap<String, String>();
            props.put(OPERATION_HEADER, "true");
            transform.configure(props);
            SourceRecord unknownRecord = this.createUnknownRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)unknownRecord)).isEqualTo((Object)unknownRecord);
            SourceRecord unnamedSchemaRecord = this.createUnknownUnnamedSchemaRecord();
            Assertions.assertThat((Object)transform.apply((ConnectRecord)unnamedSchemaRecord)).isEqualTo((Object)unnamedSchemaRecord);
        }
    }
}

