/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.text.ParsingException;
import io.debezium.util.Collect;
import io.debezium.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class StringsTest {
    public void compareSeparatedLines(Object ... lines) {
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(content);
        for (Object line : lines) {
            stream.println(line);
        }
        List actualLines = Strings.splitLines((String)content.toString());
        Assert.assertArrayEquals((Object[])lines, (Object[])actualLines.toArray());
    }

    @Test
    public void splitLinesShouldWorkCorrectly() {
        this.compareSeparatedLines("Line 1", "Line 2", "Line 3", "Line 4");
    }

    @Test
    public void setLengthShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)"This is the st", (Object)Strings.setLength((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void setLengthShouldAppendCharacterForStringsThatAreTooShort() {
        Assert.assertEquals((Object)"This      ", (Object)Strings.setLength((String)"This", (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldNotRemoveLeadingWhitespace() {
        Assert.assertEquals((Object)" This     ", (Object)Strings.setLength((String)" This", (int)10, (char)' '));
        Assert.assertEquals((Object)"\tThis     ", (Object)Strings.setLength((String)"\tThis", (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldAppendCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.setLength((String)"", (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldAppendCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.setLength(null, (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)Strings.setLength((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void justifyLeftShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)"This is the st", (Object)Strings.justifyLeft((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void justifyLeftShouldAppendCharacterForStringsThatAreTooShort() {
        Assert.assertEquals((Object)"This      ", (Object)Strings.justifyLeft((String)"This", (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldRemoveLeadingWhitespace() {
        Assert.assertEquals((Object)"This      ", (Object)Strings.justifyLeft((String)" This", (int)10, (char)' '));
        Assert.assertEquals((Object)"This      ", (Object)Strings.justifyLeft((String)"\tThis", (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldAppendCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyLeft((String)"", (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldAppendCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyLeft(null, (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)Strings.justifyLeft((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void justifyRightShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)" is the string", (Object)Strings.justifyRight((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void justifyRightShouldPrependCharacterForStringsThatAreTooShort() {
        Assert.assertEquals((Object)"      This", (Object)Strings.justifyRight((String)"This", (int)10, (char)' '));
    }

    @Test
    public void justifyRightShouldPrependCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyRight((String)"", (int)10, (char)' '));
    }

    @Test
    public void justifyRightShouldPrependCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyRight(null, (int)10, (char)' '));
    }

    @Test
    public void justifyRightShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)Strings.justifyRight((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void justifyCenterShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)"This is the st", (Object)Strings.justifyCenter((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependAndAppendSameNumberOfCharacterForStringsThatAreTooShortButOfAnEvenLength() {
        Assert.assertEquals((Object)"   This   ", (Object)Strings.justifyCenter((String)"This", (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependOneMoreCharacterThanAppendingForStringsThatAreTooShortButOfAnOddLength() {
        Assert.assertEquals((Object)"   Thing  ", (Object)Strings.justifyCenter((String)"Thing", (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyCenter((String)"", (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyCenter(null, (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)Strings.justifyCenter((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void replaceVariablesShouldReplaceVariableThatHaveSameCase() {
        this.assertReplacement("some ${v1} text", this.vars("v1", "abc"), "some abc text");
        this.assertReplacement("some ${v1} text", this.vars("v1", "abc", "V1", "ABC"), "some abc text");
        this.assertReplacement("some ${v1:other} text", this.vars("V1", "ABC"), "some other text");
    }

    @Test
    public void replaceVariablesShouldNotReplaceVariableThatHasNoDefaultAndIsNotFound() {
        this.assertReplacement("some ${varName} text", this.vars("v1", "value1"), "some ${varName} text");
        this.assertReplacement("some${varName}text", this.vars("v1", "value1"), "some${varName}text");
        this.assertReplacement("${varName}", this.vars("v1", "value1"), "${varName}");
    }

    @Test
    public void replaceVariablesShouldReplaceVariablesWithNoDefault() {
        this.assertReplacement("${varName}", this.vars("varName", "replaced"), "replaced");
        this.assertReplacement("some${varName}text", this.vars("varName", "replaced"), "somereplacedtext");
        this.assertReplacement("some ${varName} text", this.vars("varName", "replaced"), "some replaced text");
        this.assertReplacement("some ${var1,var2,var3:other} text", this.vars("var1", "replaced"), "some replaced text");
        this.assertReplacement("some ${var1,var2,var3:other} text", this.vars("v1", "replaced", "var2", "new"), "some new text");
        this.assertReplacement("some ${var1,var2,var3:other} text", this.vars("v1", "replaced", "var3", "new"), "some new text");
    }

    @Test
    public void replaceVariablesShouldReplaceVariablesWithDefaultWhenNoReplacementIsFound() {
        this.assertReplacement("some${varName:other}text", this.vars("v1", "replaced"), "someothertext");
        this.assertReplacement("some ${varName:other} text", this.vars("v1", "replaced"), "some other text");
        this.assertReplacement("some ${var1,var2,var3:other} text", this.vars("var10", "replaced"), "some other text");
        this.assertReplacement("some ${var1,var2,var3:other} text", this.vars("var10", "replaced", "var11", "new"), "some other text");
    }

    @Test
    public void replaceVariablesShouldReplaceMultipleVariables() {
        this.assertReplacement("${v1}${v1}", this.vars("v1", "first", "v2", "second"), "firstfirst");
        this.assertReplacement("${v1}${v2}", this.vars("v1", "first", "v2", "second"), "firstsecond");
        this.assertReplacement("some${v1}text${v2}end", this.vars("v1", "first", "v2", "second"), "somefirsttextsecondend");
        this.assertReplacement("some ${v1} text ${v2} end", this.vars("v1", "first", "v2", "second"), "some first text second end");
        this.assertReplacement("some ${v1:other} text", this.vars("vx1", "replaced"), "some other text");
        this.assertReplacement("some ${v1,v2,v3:other} text ${v1,v2,v3:other}", this.vars("var10", "replaced", "v2", "s"), "some s text s");
        this.assertReplacement("some ${v1,v2:other}${v2,v3:other} text", this.vars("v1", "1", "v2", "2"), "some 12 text");
    }

    @Test
    public void isNullOrEmptyReturnsTrueForNull() {
        Assertions.assertThat((boolean)Strings.isNullOrEmpty(null)).isTrue();
    }

    @Test
    public void isNullOrEmptyReturnsTrueForEmptyString() {
        Assertions.assertThat((boolean)Strings.isNullOrEmpty((String)"")).isTrue();
    }

    @Test
    public void isNullOrEmptyReturnsFalseForFalseForNonEmptyString() {
        Assertions.assertThat((boolean)Strings.isNullOrEmpty((String)"hello")).isFalse();
    }

    @Test
    public void isNullOrEmptyReturnsFalseForFalseForBlankString() {
        Assertions.assertThat((boolean)Strings.isNullOrEmpty((String)"     ")).isFalse();
    }

    @Test
    public void isNumericShouldReturnFalseForNull() {
        Assertions.assertThat((boolean)Strings.isNumeric(null)).isFalse();
    }

    @Test
    public void isNumericShouldReturnFalseForEmptyString() {
        Assertions.assertThat((boolean)Strings.isNumeric((String)"")).isFalse();
    }

    @Test
    public void isNumericShouldReturnFalseForBlankString() {
        Assertions.assertThat((boolean)Strings.isNumeric((String)"     ")).isFalse();
    }

    @Test
    public void isNumericShouldReturnTrueForNumericString() {
        Assertions.assertThat((boolean)Strings.isNumeric((String)"123")).isTrue();
    }

    public void unquoteIdentifierPartShouldReturnNullForNull() {
        Assertions.assertThat((String)Strings.unquoteIdentifierPart(null)).isNull();
    }

    @Test
    public void unquoteIdentifierPartShouldReturnSameValueForUnquotedString() {
        Assertions.assertThat((String)Strings.unquoteIdentifierPart((String)"table")).isEqualTo((Object)"table");
    }

    @Test
    public void unquoteIdentifierPartShouldReturnEmptyStringForEmptyQuotedString() {
        Assertions.assertThat((String)Strings.unquoteIdentifierPart((String)"''")).isEqualTo((Object)"");
    }

    @Test
    public void unquoteIdentifierPartShouldReturnUnquotedString() {
        Assertions.assertThat((String)Strings.unquoteIdentifierPart((String)"'Table'")).isEqualTo((Object)"Table");
    }

    @Test
    public void unquoteIdentifierPartShouldUnescapeEscapedQuote() {
        Assertions.assertThat((String)Strings.unquoteIdentifierPart((String)"'Tab''le'")).isEqualTo((Object)"Tab'le");
    }

    @Test
    public void unquoteIdentifierPartShouldSupportDoubleQuotes() {
        Assertions.assertThat((String)Strings.unquoteIdentifierPart((String)"\"Tab\"\"le\"")).isEqualTo((Object)"Tab\"le");
    }

    @Test
    public void unquoteIdentifierPartShouldSupportBackTicks() {
        Assertions.assertThat((String)Strings.unquoteIdentifierPart((String)"`Tab``le`")).isEqualTo((Object)"Tab`le");
    }

    @Test
    public void hexStringToByteArrayShouldReturnCorrectByteArray() {
        Assertions.assertThat((byte[])Strings.hexStringToByteArray(null)).isNull();
        Assertions.assertThat((byte[])Strings.hexStringToByteArray((String)"00")).isEqualTo(new byte[]{0});
        Assertions.assertThat((byte[])Strings.hexStringToByteArray((String)"010203")).isEqualTo(new byte[]{1, 2, 3});
        Assertions.assertThat((byte[])Strings.hexStringToByteArray((String)"CAFEBABE")).isEqualTo(new byte[]{-54, -2, -70, -66});
    }

    @Test
    public void regexSplit() {
        this.assertRegexSet("a,b", "a", "b");
        this.assertRegexSet("a\\,b", "a,b");
        this.assertRegexSet("a,b,", "a", "b");
        this.assertRegexSet("a,b\\,", "a", "b,");
        this.assertRegexSet("a\\\\\\,b", "a\\\\,b");
        this.assertRegexSet("DROP TEMPORARY TABLE IF EXISTS .+ /\\\\* generated by server \\\\*/,INSERT INTO mysql.rds_heartbeat2\\(.*\\,.*\\) values \\(.*\\,.*\\) ON DUPLICATE KEY UPDATE value = .*", "DROP TEMPORARY TABLE IF EXISTS .+ /\\\\* generated by server \\\\*/", "INSERT INTO mysql.rds_heartbeat2\\(.*,.*\\) values \\(.*,.*\\) ON DUPLICATE KEY UPDATE value = .*");
        this.assertRegexList("a,b", "a", "b");
        this.assertRegexList("a\\,b", "a,b");
        this.assertRegexList("a,b,", "a", "b");
        this.assertRegexList("a,b\\,", "a", "b,");
        this.assertRegexList("a\\\\\\,b", "a\\\\,b");
        this.assertRegexList("DROP TEMPORARY TABLE IF EXISTS .+ /\\\\* generated by server \\\\*/,INSERT INTO mysql.rds_heartbeat2\\(.*\\,.*\\) values \\(.*\\,.*\\) ON DUPLICATE KEY UPDATE value = .*", "DROP TEMPORARY TABLE IF EXISTS .+ /\\\\* generated by server \\\\*/", "INSERT INTO mysql.rds_heartbeat2\\(.*,.*\\) values \\(.*,.*\\) ON DUPLICATE KEY UPDATE value = .*");
    }

    @Test
    public void joinShouldExcludeFirstNullableElement() {
        Assertions.assertThat((String)Strings.join((CharSequence)",", Arrays.asList(null, "b", "c"))).isEqualTo((Object)"b,c");
    }

    @Test
    public void joinShouldExcludeSecondNullableElement() {
        Assertions.assertThat((String)Strings.join((CharSequence)",", Arrays.asList("a", null, "c"))).isEqualTo((Object)"a,c");
    }

    @Test
    public void joinShouldExcludeAllNullableElements() {
        Assertions.assertThat((String)Strings.join((CharSequence)",", Arrays.asList(null, null, null))).isEqualTo((Object)"");
    }

    @Test
    public void joinWithConversionShouldConvertAllElements() {
        Assertions.assertThat((String)Strings.join((CharSequence)",", Arrays.asList("a", "b", "c"), s -> "_" + s)).isEqualTo((Object)"_a,_b,_c");
    }

    @Test(expected=ParsingException.class)
    public void regexSplitWrongEscape() {
        Strings.setOfRegex((String)"a,b\\,c\\");
    }

    protected void assertReplacement(String before, Map<String, String> replacements, String after) {
        String result = Strings.replaceVariables((String)before, replacements::get);
        Assertions.assertThat((String)result).isEqualTo((Object)after);
    }

    protected Map<String, String> vars(String var1, String val1) {
        return Collect.hashMapOf((Object)var1, (Object)val1);
    }

    protected Map<String, String> vars(String var1, String val1, String var2, String val2) {
        return Collect.hashMapOf((Object)var1, (Object)val1, (Object)var2, (Object)val2);
    }

    protected void assertRegexSet(String patterns, String ... matches) {
        Set regexSet = Strings.setOfRegex((String)patterns);
        Assertions.assertThat((Collection)regexSet.stream().map(Pattern::pattern).collect(Collectors.toSet())).containsOnly((Object[])matches);
    }

    protected void assertRegexList(String patterns, String ... matches) {
        List regexList = Strings.listOfRegex((String)patterns, (int)2);
        Assertions.assertThat(regexList.stream().map(Pattern::pattern).collect(Collectors.toList())).isEqualTo(Arrays.asList((Object[])matches));
    }
}

