/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.relational.Table;
import io.debezium.relational.TableEditor;
import io.debezium.relational.TableId;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class TableEditorTest {
    private final TableId id = new TableId("catalog", "schema", "table");
    private TableEditor editor;
    private Table table;
    private ColumnEditor columnEditor;

    @Before
    public void beforeEach() {
        this.editor = Table.editor();
        this.table = null;
        this.columnEditor = Column.editor();
    }

    @Test
    public void shouldNotHaveColumnsIfEmpty() {
        Assertions.assertThat((Object)this.editor.columnWithName("any")).isNull();
        Assertions.assertThat((List)this.editor.columns()).isEmpty();
        Assertions.assertThat((List)this.editor.primaryKeyColumnNames()).isEmpty();
    }

    @Test(expected=IllegalStateException.class)
    public void shouldFailToCreateTableWhenEditorIsMissingTableId() {
        this.editor.create();
    }

    @Test
    public void shouldCreateTableWhenEditorHasIdButNoColumns() {
        this.table = this.editor.tableId(this.id).create();
        Assertions.assertThat((Object)this.table.columnWithName("any")).isNull();
        Assertions.assertThat((List)this.table.columns()).isEmpty();
        Assertions.assertThat((List)this.table.primaryKeyColumnNames()).isEmpty();
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotAllowAddingPrimaryKeyColumnWhenNotFound() {
        this.editor.tableId(this.id);
        Column c1 = this.columnEditor.name("C1").type("VARCHAR").jdbcType(12).length(10).position(1).create();
        Column c2 = this.columnEditor.name("C2").type("NUMBER").jdbcType(2).length(5).position(1).create();
        Column c3 = this.columnEditor.name("C3").type("DATE").jdbcType(91).position(1).create();
        this.editor.addColumns(new Column[]{c1, c2, c3});
        this.editor.setPrimaryKeyNames(new String[]{"C1", "WOOPS"});
    }

    @Test
    public void shouldAllowAddingPrimaryKeyColumnWhenFound() {
        this.editor.tableId(this.id);
        Column c1 = this.columnEditor.name("C1").type("VARCHAR").jdbcType(12).length(10).position(1).create();
        Column c2 = this.columnEditor.name("C2").type("NUMBER").jdbcType(2).length(5).position(1).create();
        Column c3 = this.columnEditor.name("C3").type("DATE").jdbcType(91).position(1).create();
        this.editor.addColumns(new Column[]{c1, c2, c3});
        this.editor.setPrimaryKeyNames(new String[]{"C1"});
        c1 = this.editor.columnWithName(c1.name());
        c2 = this.editor.columnWithName(c2.name());
        c3 = this.editor.columnWithName(c3.name());
        Assertions.assertThat((int)c1.position()).isEqualTo(1);
        Assertions.assertThat((int)c2.position()).isEqualTo(2);
        Assertions.assertThat((int)c3.position()).isEqualTo(3);
        this.table = this.editor.create();
        Assertions.assertThat((List)this.table.retrieveColumnNames()).containsExactly(new Object[]{"C1", "C2", "C3"});
        Assertions.assertThat((List)this.table.columns()).containsExactly(new Object[]{c1, c2, c3});
        Assertions.assertThat((List)this.table.primaryKeyColumnNames()).containsOnly(new Object[]{"C1"});
        this.assertValidPositions(this.editor);
    }

    @Test
    public void shouldFindNonExistingColumnByNameIndependentOfCase() {
        this.editor.tableId(this.id);
        Column c1 = this.columnEditor.name("C1").type("VARCHAR").jdbcType(12).length(10).position(1).create();
        Column c2 = this.columnEditor.name("C2").type("NUMBER").jdbcType(2).length(5).position(1).create();
        Column c3 = this.columnEditor.name("C3").type("DATE").jdbcType(91).position(1).create();
        this.editor.addColumns(new Column[]{c1, c2, c3});
        this.editor.columns().forEach(col -> {
            Assertions.assertThat((Object)this.editor.columnWithName(col.name())).isNotNull();
            Assertions.assertThat((Object)this.editor.columnWithName(col.name().toUpperCase())).isNotNull();
            Assertions.assertThat((Object)this.editor.columnWithName(col.name().toLowerCase())).isNotNull();
        });
        Assertions.assertThat((Object)this.editor.columnWithName("WOOPS")).isNull();
    }

    @Test
    public void shouldFindGeneratedColumns() {
        this.editor.tableId(this.id);
        Column c1 = this.columnEditor.name("C1").type("VARCHAR").jdbcType(12).length(10).position(1).create();
        Column c2 = this.columnEditor.name("C2").type("NUMBER").jdbcType(2).length(5).generated(true).create();
        Column c3 = this.columnEditor.name("C3").type("DATE").jdbcType(91).generated(true).create();
        this.editor.addColumns(new Column[]{c1, c2, c3});
        this.editor.setPrimaryKeyNames(new String[]{"C1"});
        this.table = this.editor.create();
        Assertions.assertThat((List)this.table.retrieveColumnNames()).containsExactly(new Object[]{"C1", "C2", "C3"});
        this.table.columns().forEach(col -> Assertions.assertThat((boolean)this.table.isGenerated(col.name())).isEqualTo(col.isGenerated()));
        this.assertValidPositions(this.editor);
    }

    @Test
    public void shouldFindAutoIncrementedColumns() {
        this.editor.tableId(this.id);
        Column c1 = this.columnEditor.name("C1").type("VARCHAR").jdbcType(12).length(10).position(1).create();
        Column c2 = this.columnEditor.name("C2").type("NUMBER").jdbcType(2).length(5).autoIncremented(true).create();
        Column c3 = this.columnEditor.name("C3").type("DATE").jdbcType(91).autoIncremented(true).create();
        this.editor.addColumns(new Column[]{c1, c2, c3});
        this.editor.setPrimaryKeyNames(new String[]{"C1"});
        this.table = this.editor.create();
        Assertions.assertThat((List)this.table.retrieveColumnNames()).containsExactly(new Object[]{"C1", "C2", "C3"});
        this.table.columns().forEach(col -> Assertions.assertThat((boolean)this.table.isAutoIncremented(col.name())).isEqualTo(col.isAutoIncremented()));
        this.assertValidPositions(this.editor);
    }

    @Test
    public void shouldReorderColumns() {
        this.editor.tableId(this.id);
        Column c1 = this.columnEditor.name("C1").type("VARCHAR").jdbcType(12).length(10).position(1).create();
        Column c2 = this.columnEditor.name("C2").type("NUMBER").jdbcType(2).length(5).autoIncremented(true).create();
        Column c3 = this.columnEditor.name("C3").type("DATE").jdbcType(91).autoIncremented(true).create();
        this.editor.addColumns(new Column[]{c1, c2, c3});
        this.assertValidPositions(this.editor);
        this.editor.reorderColumn("C1", null);
        Assertions.assertThat((List)this.editor.columns()).containsExactly(new Object[]{this.editor.columnWithName("C1"), this.editor.columnWithName("C2"), this.editor.columnWithName("C3")});
        this.assertValidPositions(this.editor);
        this.editor.reorderColumn("C2", "C1");
        Assertions.assertThat((List)this.editor.columns()).containsExactly(new Object[]{this.editor.columnWithName("C1"), this.editor.columnWithName("C2"), this.editor.columnWithName("C3")});
        this.assertValidPositions(this.editor);
        this.editor.reorderColumn("C3", "C2");
        Assertions.assertThat((List)this.editor.columns()).containsExactly(new Object[]{this.editor.columnWithName("C1"), this.editor.columnWithName("C2"), this.editor.columnWithName("C3")});
        this.assertValidPositions(this.editor);
        this.editor.reorderColumn("C3", "C1");
        Assertions.assertThat((List)this.editor.columns()).containsExactly(new Object[]{this.editor.columnWithName("C1"), this.editor.columnWithName("C3"), this.editor.columnWithName("C2")});
        this.assertValidPositions(this.editor);
        this.editor.reorderColumn("C3", null);
        Assertions.assertThat((List)this.editor.columns()).containsExactly(new Object[]{this.editor.columnWithName("C3"), this.editor.columnWithName("C1"), this.editor.columnWithName("C2")});
        this.assertValidPositions(this.editor);
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldNotReorderColumnIfNameDoesNotMatch() {
        this.editor.tableId(this.id);
        Column c1 = this.columnEditor.name("C1").type("VARCHAR").jdbcType(12).length(10).position(1).create();
        Column c2 = this.columnEditor.name("C2").type("NUMBER").jdbcType(2).length(5).autoIncremented(true).create();
        Column c3 = this.columnEditor.name("C3").type("DATE").jdbcType(91).autoIncremented(true).create();
        this.editor.addColumns(new Column[]{c1, c2, c3});
        this.editor.reorderColumn("WOOPS", "C2");
        this.assertValidPositions(this.editor);
    }

    @Test
    public void shouldRemoveColumnByName() {
        this.editor.tableId(this.id);
        Column c1 = this.columnEditor.name("C1").type("VARCHAR").jdbcType(12).length(10).position(1).create();
        Column c2 = this.columnEditor.name("C2").type("NUMBER").jdbcType(2).length(5).autoIncremented(true).create();
        Column c3 = this.columnEditor.name("C3").type("DATE").jdbcType(91).autoIncremented(true).create();
        this.editor.addColumns(new Column[]{c1, c2, c3});
        this.editor.removeColumn("C2");
        Assertions.assertThat((List)this.editor.columns()).containsExactly(new Object[]{this.editor.columnWithName("C1"), this.editor.columnWithName("C3")});
        this.assertValidPositions(this.editor);
    }

    protected void assertValidPositions(TableEditor editor) {
        AtomicInteger position = new AtomicInteger(1);
        Assertions.assertThat((boolean)editor.columns().stream().allMatch(defn -> defn.position() == position.getAndIncrement())).isTrue();
    }

    protected void assertValidPositions(Table editor) {
        AtomicInteger position = new AtomicInteger(1);
        Assertions.assertThat((boolean)editor.columns().stream().allMatch(defn -> defn.position() == position.getAndIncrement())).isTrue();
    }
}

