/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.ddl;

import io.debezium.relational.Column;
import io.debezium.relational.Table;
import io.debezium.relational.TableId;
import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParserSql2003;
import io.debezium.relational.ddl.LegacyDdlParser;
import java.util.List;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DdlParserSql2003Test {
    private LegacyDdlParser parser;
    private Tables tables;

    @Before
    public void beforeEach() {
        this.parser = new DdlParserSql2003();
        this.tables = new Tables();
    }

    @Test
    public void shouldParseMultipleStatements() {
        String ddl = "CREATE TABLE foo ( " + System.lineSeparator() + " c1 INTEGER NOT NULL, " + System.lineSeparator() + " c2 VARCHAR(22) " + System.lineSeparator() + "); " + System.lineSeparator() + "-- This is a comment" + System.lineSeparator() + "DROP TABLE foo;" + System.lineSeparator();
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
    }

    @Test
    public void shouldParseCreateTableStatementWithSingleGeneratedAndPrimaryKeyColumn() {
        String ddl = "CREATE TABLE foo ( " + System.lineSeparator() + " c1 INTEGER GENERATED ALWAYS AS IDENTITY NOT NULL PRIMARY KEY, " + System.lineSeparator() + " c2 VARCHAR(22) " + System.lineSeparator() + "); " + System.lineSeparator();
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table foo = this.tables.forTable(new TableId(null, null, "foo"));
        Assertions.assertThat((Object)foo).isNotNull();
        Assertions.assertThat((List)foo.columnNames()).containsExactly(new Object[]{"c1", "c2"});
        Assertions.assertThat((List)foo.primaryKeyColumnNames()).containsExactly(new Object[]{"c1"});
        this.assertColumn(foo, "c1", "INTEGER", 4, -1, -1, false, true, true);
        this.assertColumn(foo, "c2", "VARCHAR", 12, 22, -1, true, false, false);
    }

    @Test
    public void shouldParseCreateTableStatementWithSingleGeneratedColumnAsPrimaryKey() {
        String ddl = "CREATE TABLE my.foo ( " + System.lineSeparator() + " c1 INTEGER GENERATED ALWAYS AS IDENTITY NOT NULL, " + System.lineSeparator() + " c2 VARCHAR(22), " + System.lineSeparator() + " PRIMARY KEY (c1)" + System.lineSeparator() + "); " + System.lineSeparator();
        this.parser.parse(ddl, this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(1);
        Table foo = this.tables.forTable(new TableId("my", null, "foo"));
        Assertions.assertThat((Object)foo).isNotNull();
        Assertions.assertThat((List)foo.columnNames()).containsExactly(new Object[]{"c1", "c2"});
        Assertions.assertThat((List)foo.primaryKeyColumnNames()).containsExactly(new Object[]{"c1"});
        this.assertColumn(foo, "c1", "INTEGER", 4, -1, -1, false, true, true);
        this.assertColumn(foo, "c2", "VARCHAR", 12, 22, -1, true, false, false);
        this.parser.parse("DROP TABLE my.foo", this.tables);
        Assertions.assertThat((int)this.tables.size()).isEqualTo(0);
    }

    protected void assertColumn(Table table, String name, String typeName, int jdbcType, int length, int scale, boolean optional, boolean generated, boolean autoIncremented) {
        Column column = table.columnWithName(name);
        Assertions.assertThat((String)column.name()).isEqualTo((Object)name);
        Assertions.assertThat((String)column.typeName()).isEqualTo((Object)typeName);
        Assertions.assertThat((int)column.jdbcType()).isEqualTo(jdbcType);
        Assertions.assertThat((int)column.length()).isEqualTo(length);
        if (scale == -1) {
            Assert.assertFalse((boolean)column.scale().isPresent());
        } else {
            Assertions.assertThat((Integer)((Integer)column.scale().get())).isEqualTo(scale);
        }
        Assertions.assertThat((boolean)column.isOptional()).isEqualTo(optional);
        Assertions.assertThat((boolean)column.isGenerated()).isEqualTo(generated);
        Assertions.assertThat((boolean)column.isAutoIncremented()).isEqualTo(autoIncremented);
    }
}

