/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ColumnEditorTest {
    private ColumnEditor editor;
    private Column column;

    @Before
    public void beforeEach() {
        this.editor = Column.editor();
        this.column = null;
    }

    protected void createColumnWithAllFieldsSetToNonDefaults() {
        this.column = this.editor.name("price").type("NUMBER").jdbcType(8).length(5).scale(Integer.valueOf(2)).position(4).optional(true).autoIncremented(true).generated(true).create();
    }

    @Test
    public void shouldCreateColumnWithAllFieldsSetToNonDefaults() {
        this.createColumnWithAllFieldsSetToNonDefaults();
        Assertions.assertThat((String)this.column.name()).isEqualTo((Object)"price");
        Assertions.assertThat((String)this.column.typeName()).isEqualTo((Object)"NUMBER");
        Assertions.assertThat((int)this.column.jdbcType()).isEqualTo(8);
        Assertions.assertThat((int)this.column.length()).isEqualTo(5);
        Assertions.assertThat((Integer)((Integer)this.column.scale().get())).isEqualTo(2);
        Assertions.assertThat((int)this.column.position()).isEqualTo(4);
        Assertions.assertThat((boolean)this.column.isOptional()).isTrue();
        Assertions.assertThat((boolean)this.column.isAutoIncremented()).isTrue();
        Assertions.assertThat((boolean)this.column.isGenerated()).isTrue();
    }

    @Test
    public void shouldCreateColumnWithAllFieldsSetToDefaults() {
        Column column = this.editor.create();
        Assertions.assertThat((String)column.name()).isNull();
        Assertions.assertThat((String)column.typeName()).isNull();
        Assertions.assertThat((int)column.jdbcType()).isEqualTo(4);
        Assertions.assertThat((int)column.length()).isEqualTo(-1);
        Assert.assertFalse((boolean)column.scale().isPresent());
        Assertions.assertThat((int)column.position()).isEqualTo(1);
        Assertions.assertThat((boolean)column.isOptional()).isTrue();
        Assertions.assertThat((boolean)column.isAutoIncremented()).isFalse();
        Assertions.assertThat((boolean)column.isGenerated()).isFalse();
    }

    @Test
    public void shouldHaveToStringThatMatchesColumn() {
        this.createColumnWithAllFieldsSetToNonDefaults();
        Assertions.assertThat((String)this.editor.toString()).isEqualTo((Object)this.column.toString());
        Assertions.assertThat((String)this.editor.toString()).isNotEmpty();
    }

    @Test
    public void shouldCompareBasedUponPosition() {
        this.createColumnWithAllFieldsSetToNonDefaults();
        Assertions.assertThat((int)this.editor.compareTo((Object)this.column)).isEqualTo(0);
        this.editor.position(100);
        Assertions.assertThat((int)this.editor.compareTo((Object)this.column)).isGreaterThan(0);
        this.editor.position(1);
        Assertions.assertThat((int)this.editor.compareTo((Object)this.column)).isLessThan(0);
    }
}

