/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.data;

import java.util.List;
import java.util.function.Supplier;
import org.apache.kafka.connect.data.Field;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.Struct;
import org.fest.assertions.Assertions;
import org.fest.assertions.ByteArrayAssert;
import org.fest.assertions.ListAssert;
import org.fest.assertions.ObjectAssert;

public class SchemaAndValueField {
    private final Object schema;
    private final Object value;
    private final String fieldName;
    private Supplier<Boolean> assertValueOnlyIf = null;

    public SchemaAndValueField(String fieldName, Object schema, Object value) {
        this.schema = schema;
        this.value = value;
        this.fieldName = fieldName;
    }

    public SchemaAndValueField assertValueOnlyIf(Supplier<Boolean> predicate) {
        this.assertValueOnlyIf = predicate;
        return this;
    }

    public void assertFor(Struct content) {
        this.assertSchema(content);
        this.assertValue(content);
    }

    private void assertValue(Struct content) {
        if (this.assertValueOnlyIf != null && !this.assertValueOnlyIf.get().booleanValue()) {
            return;
        }
        if (this.value == null) {
            ((ObjectAssert)Assertions.assertThat((Object)content.get(this.fieldName)).as(this.fieldName + " is present in the actual content")).isNull();
            return;
        }
        Object actualValue = content.get(this.fieldName);
        ((ObjectAssert)Assertions.assertThat((Object)actualValue).as(this.fieldName + " is not present in the actual content")).isNotNull();
        if (actualValue instanceof List) {
            ((ObjectAssert)Assertions.assertThat((Object)this.value).as("Incorrect value type for " + this.fieldName)).isInstanceOf(List.class);
            List actualValueList = (List)actualValue;
            List valueList = (List)this.value;
            ((ListAssert)Assertions.assertThat((List)actualValueList).as("List size don't match for " + this.fieldName)).hasSize(valueList.size());
            if (!valueList.isEmpty() && valueList.iterator().next() instanceof Struct) {
                for (int i = 0; i < valueList.size(); ++i) {
                    this.assertStruct((Struct)valueList.get(i), (Struct)actualValueList.get(i));
                }
                return;
            }
        } else {
            ((ObjectAssert)Assertions.assertThat(actualValue.getClass()).as("Incorrect value type for " + this.fieldName)).isEqualTo(this.value.getClass());
        }
        if (actualValue instanceof byte[]) {
            ((ByteArrayAssert)Assertions.assertThat((byte[])((byte[])actualValue)).as("Values don't match for " + this.fieldName)).isEqualTo((byte[])this.value);
        } else if (actualValue instanceof Struct) {
            this.assertStruct((Struct)this.value, (Struct)actualValue);
        } else {
            ((ObjectAssert)Assertions.assertThat((Object)actualValue).as("Values don't match for " + this.fieldName)).isEqualTo(this.value);
        }
    }

    private void assertStruct(Struct expectedStruct, Struct actualStruct) {
        expectedStruct.schema().fields().stream().forEach(field -> {
            Object expectedValue = expectedStruct.get(field);
            if (expectedValue == null) {
                ((ObjectAssert)Assertions.assertThat((Object)actualStruct.get(field.name())).as(this.fieldName + " is present in the actual content")).isNull();
                return;
            }
            Object actualValue = actualStruct.get(field.name());
            ((ObjectAssert)Assertions.assertThat((Object)actualValue).as("No value found for " + this.fieldName)).isNotNull();
            ((ObjectAssert)Assertions.assertThat(actualValue.getClass()).as("Incorrect value type for " + this.fieldName)).isEqualTo(expectedValue.getClass());
            if (actualValue instanceof byte[]) {
                ((ObjectAssert)Assertions.assertThat((Object)expectedValue).as("Array is not expected for " + this.fieldName)).isInstanceOf(byte[].class);
                ((ByteArrayAssert)Assertions.assertThat((byte[])((byte[])actualValue)).as("Values don't match for " + this.fieldName)).isEqualTo((byte[])expectedValue);
            } else if (actualValue instanceof Struct) {
                this.assertStruct((Struct)expectedValue, (Struct)actualValue);
            } else {
                ((ObjectAssert)Assertions.assertThat((Object)actualValue).as("Values don't match for " + this.fieldName)).isEqualTo(expectedValue);
            }
        });
    }

    private void assertSchema(Struct content) {
        if (this.schema == null) {
            return;
        }
        Schema schema = content.schema();
        Field field = schema.field(this.fieldName);
        ((ObjectAssert)Assertions.assertThat((Object)field).as(this.fieldName + " not found in schema " + schema)).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)field.schema()).as("Schema for " + field.name() + " does not match the actual value")).isEqualTo(this.schema);
    }
}

