/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.config;

import io.debezium.config.Configuration;
import io.debezium.config.Field;
import org.apache.kafka.common.config.ConfigDef;

public class CommonConnectorConfig {
    public static final Field TOMBSTONES_ON_DELETE = Field.create("tombstones.on.delete").withDisplayName("Change the behaviour of Debezium with regards to delete operations").withType(ConfigDef.Type.BOOLEAN).withWidth(ConfigDef.Width.SHORT).withImportance(ConfigDef.Importance.MEDIUM).withDefault(true).withValidation(Field::isBoolean).withDescription("Whether delete operations should be represented by a delete event and a subsquenttombstone event (true) or only by a delete event (false). Emitting the tombstone event (the default behavior) allows Kafka to completely delete all events pertaining to the given key once the source record got deleted.");
    private final boolean emitTombstoneOnDelete;

    protected CommonConnectorConfig(Configuration config) {
        this.emitTombstoneOnDelete = config.getBoolean(TOMBSTONES_ON_DELETE);
    }

    public boolean isEmitTombstoneOnDelete() {
        return this.emitTombstoneOnDelete;
    }
}

