/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational;

import io.debezium.relational.Column;
import io.debezium.relational.ColumnEditor;
import io.debezium.util.Strings;

final class ColumnImpl
implements Column,
Comparable<Column> {
    private final String name;
    private final int position;
    private final int jdbcType;
    private final int componentType;
    private final String typeName;
    private final String typeExpression;
    private final String charsetName;
    private final int length;
    private final int scale;
    private final boolean optional;
    private final boolean autoIncremented;
    private final boolean generated;

    protected ColumnImpl(String columnName, int position, int jdbcType, int componentType, String typeName, String typeExpression, String charsetName, String defaultCharsetName, int columnLength, int columnScale, boolean optional, boolean autoIncremented, boolean generated) {
        this.name = columnName;
        this.position = position;
        this.jdbcType = jdbcType;
        this.componentType = componentType;
        this.typeName = typeName;
        this.typeExpression = typeExpression;
        if (this.typeUsesCharset() && (charsetName == null || "DEFAULT".equalsIgnoreCase(charsetName))) {
            charsetName = defaultCharsetName;
        }
        this.charsetName = charsetName;
        this.length = columnLength;
        this.scale = columnScale;
        this.optional = optional;
        this.autoIncremented = autoIncremented;
        this.generated = generated;
        assert (this.scale >= -1);
        assert (this.length >= -1);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public int position() {
        return this.position;
    }

    @Override
    public int jdbcType() {
        return this.jdbcType;
    }

    @Override
    public int componentType() {
        return this.componentType;
    }

    @Override
    public String typeName() {
        return this.typeName;
    }

    @Override
    public String typeExpression() {
        return this.typeExpression;
    }

    @Override
    public String charsetName() {
        return this.charsetName;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public int scale() {
        return this.scale;
    }

    @Override
    public boolean isOptional() {
        return this.optional;
    }

    @Override
    public boolean isAutoIncremented() {
        return this.autoIncremented;
    }

    @Override
    public boolean isGenerated() {
        return this.generated;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Column) {
            Column that = (Column)obj;
            return this.name().equalsIgnoreCase(that.name()) && this.typeExpression().equalsIgnoreCase(that.typeExpression()) && this.typeName().equalsIgnoreCase(that.typeName()) && this.jdbcType() == that.jdbcType() && Strings.equalsIgnoreCase(this.charsetName(), that.charsetName()) && this.position() == that.position() && this.length() == that.length() && this.scale() == that.scale() && this.isOptional() == that.isOptional() && this.isAutoIncremented() == that.isAutoIncremented() && this.isGenerated() == that.isGenerated();
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.name);
        sb.append(" ").append(this.typeName);
        if (this.length >= 0) {
            sb.append('(').append(this.length);
            if (this.scale >= 0) {
                sb.append(',').append(this.scale);
            }
            sb.append(')');
        }
        if (this.charsetName != null && !this.charsetName.isEmpty()) {
            sb.append(" CHARSET ").append(this.charsetName);
        }
        if (!this.optional) {
            sb.append(" NOT NULL");
        }
        if (this.autoIncremented) {
            sb.append(" AUTO_INCREMENTED");
        }
        if (this.generated) {
            sb.append(" GENERATED");
        }
        return sb.toString();
    }

    @Override
    public ColumnEditor edit() {
        ColumnEditor editor = Column.editor().name(this.name()).type(this.typeName(), this.typeExpression()).jdbcType(this.jdbcType()).charsetName(this.charsetName).length(this.length()).scale(this.scale()).position(this.position()).optional(this.isOptional()).autoIncremented(this.isAutoIncremented()).generated(this.isGenerated());
        if (this.jdbcType() == 2003) {
            editor.componentType(this.componentType());
        }
        return editor;
    }
}

