/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.transforms;

import io.debezium.transforms.ByLogicalTableRouter;
import java.util.HashMap;
import org.apache.kafka.connect.errors.ConnectException;
import org.junit.Assert;
import org.junit.Test;

public class ByLogicalTableRouterTest {
    @Test(expected=ConnectException.class)
    public void testBrokenKeyReplacementConfigurationNullValue() {
        ByLogicalTableRouter subject = new ByLogicalTableRouter();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topic.regex", "someValidRegex(.*)");
        props.put("topic.replacement", "$1");
        props.put("key.field.regex", "If this is set, key.field.replacement must be non-empty");
        subject.configure(props);
    }

    @Test(expected=ConnectException.class)
    public void testBrokenKeyReplacementConfigurationEmptyValue() {
        ByLogicalTableRouter subject = new ByLogicalTableRouter();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topic.regex", "someValidRegex(.*)");
        props.put("topic.replacement", "$1");
        props.put("key.field.regex", "If this is set, key.field.replacement must be non-empty");
        props.put("key.field.replacement", "");
        subject.configure(props);
    }

    @Test
    public void testKeyReplacementWorkingConfiguration() {
        ByLogicalTableRouter subject = new ByLogicalTableRouter();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topic.regex", "someValidRegex(.*)");
        props.put("topic.replacement", "$1");
        props.put("key.field.regex", "anotherValidRegex(.*)");
        props.put("key.field.replacement", "$1");
        subject.configure(props);
        Assert.assertTrue((boolean)true);
    }

    @Test(expected=ConnectException.class)
    public void testBrokenTopicReplacementConfigurationNullValue() {
        ByLogicalTableRouter subject = new ByLogicalTableRouter();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topic.regex", "someValidRegex(.*)");
        subject.configure(props);
    }

    @Test(expected=ConnectException.class)
    public void testBrokenTopicReplacementConfigurationEmptyValue() {
        ByLogicalTableRouter subject = new ByLogicalTableRouter();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("topic.regex", "someValidRegex(.*)");
        props.put("topic.replacement", "");
        subject.configure(props);
    }
}

