/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import io.debezium.time.Conversions;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Date;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class ConversionsTest {
    @Test
    public void shouldReturnNullIfNullIsSupplied() {
        Assertions.assertThat((Object)Conversions.toLocalDate(null)).isNull();
        Assertions.assertThat((Object)Conversions.toLocalDateTime(null)).isNull();
        Assertions.assertThat((Object)Conversions.toLocalTime(null)).isNull();
    }

    @Test
    public void shouldReturnSameLocalDateInstanceWhenConvertingToLocalDate() {
        LocalDate now = LocalDate.now();
        Assertions.assertThat((Object)Conversions.toLocalDate((Object)now)).isSameAs((Object)now);
    }

    @Test
    public void shouldReturnLocalDateInstanceWhenConvertingLocalDateTimeToLocalDate() {
        LocalDateTime now = LocalDateTime.now();
        Assertions.assertThat((Object)Conversions.toLocalDate((Object)now)).isEqualTo((Object)now.toLocalDate());
    }

    @Test
    public void shouldReturnLocalDateInstanceWhenConvertingUtilDateToLocalDate() {
        LocalDate now = LocalDate.now();
        Date date = new Date(now.getYear() - 1900, now.getMonthValue() - 1, now.getDayOfMonth());
        Assertions.assertThat((Object)Conversions.toLocalDate((Object)date)).isEqualTo((Object)now);
    }

    @Test
    public void shouldReturnLocalDateInstanceWhenConvertingSqlDateToLocalDate() {
        LocalDate now = LocalDate.now();
        java.sql.Date date = new java.sql.Date(now.getYear() - 1900, now.getMonthValue() - 1, now.getDayOfMonth());
        Assertions.assertThat((Object)Conversions.toLocalDate((Object)date)).isEqualTo((Object)now);
    }

    @Test
    public void shouldThrowExceptionWhenConvertingSqlTimeToLocalDate() {
        Time time = new Time(1L);
        try {
            Conversions.toLocalDate((Object)time);
            Assert.fail((String)"Should not accept java.sql.Time values");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnLocalDateInstanceWhenConvertingLongToLocalDate() {
        LocalDate now = LocalDate.now();
        long epochDay = now.toEpochDay();
        Assertions.assertThat((Object)Conversions.toLocalDate((Object)epochDay)).isEqualTo((Object)now);
    }

    @Test
    public void shouldReturnSameLocalDateTimeInstanceWhenConvertingToLocalDateTime() {
        LocalDateTime now = LocalDateTime.now();
        Assertions.assertThat((Object)Conversions.toLocalDateTime((Object)now)).isSameAs((Object)now);
    }

    @Test
    public void shouldReturnLocalDateTimeInstanceWhenConvertingLocalDateToLocalDateTime() {
        LocalDate now = LocalDate.now();
        Assertions.assertThat((Object)Conversions.toLocalDateTime((Object)now)).isEqualTo((Object)LocalDateTime.of(now, LocalTime.MIDNIGHT));
    }

    @Test
    public void shouldReturnLocalDateTimeInstanceWhenConvertingLocalTimeToLocalDateTime() {
        LocalTime now = LocalTime.now();
        Assertions.assertThat((Object)Conversions.toLocalDateTime((Object)now)).isEqualTo((Object)LocalDateTime.of(Conversions.EPOCH, now));
    }

    @Test
    public void shouldReturnLocalDateTimeInstanceWhenConvertingUtilTimeToLocalDateTime() {
        LocalDateTime now = LocalDateTime.now();
        Date date = new Date(now.getYear() - 1900, now.getMonthValue() - 1, now.getDayOfMonth(), now.getHour(), now.getMinute(), now.getSecond());
        Assertions.assertThat((Object)Conversions.toLocalDateTime((Object)date)).isEqualTo((Object)now.withNano(0));
    }

    @Test
    public void shouldReturnLocalDateTimeInstanceWhenConvertingSqlDateToLocalDateTime() {
        LocalDate now = LocalDate.now();
        java.sql.Date date = new java.sql.Date(now.getYear() - 1900, now.getMonthValue() - 1, now.getDayOfMonth());
        Assertions.assertThat((Object)Conversions.toLocalDateTime((Object)date)).isEqualTo((Object)LocalDateTime.of(now, LocalTime.MIDNIGHT));
    }

    @Test
    public void shouldReturnLocalDateTimeInstanceWhenConvertingSqlTimeToLocalDateTime() {
        LocalTime now = LocalTime.now();
        Time time = new Time(now.getHour(), now.getMinute(), now.getSecond());
        Assertions.assertThat((Object)Conversions.toLocalDateTime((Object)time)).isEqualTo((Object)LocalDateTime.of(Conversions.EPOCH, now.withNano(0)));
    }

    @Test
    public void shouldReturnLocalDateTimeInstanceWhenConvertingLongToLocalDateTime() {
        try {
            Conversions.toLocalDateTime((Object)1L);
            Assert.fail((String)"Should not accept Long values");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnSameLocalTimeInstanceWhenConvertingToLocalTime() {
        LocalTime now = LocalTime.now();
        Assertions.assertThat((Object)Conversions.toLocalTime((Object)now)).isSameAs((Object)now);
    }

    @Test
    public void shouldReturnLocalTimeInstanceWhenConvertingLocalDateTimeToLocalTime() {
        LocalDateTime now = LocalDateTime.now();
        Assertions.assertThat((Object)Conversions.toLocalTime((Object)now)).isEqualTo((Object)now.toLocalTime());
    }

    @Test
    public void shouldReturnLocalTimeInstanceWhenConvertingUtilTimeToLocalTime() {
        LocalTime now = LocalTime.now();
        Date date = new Date(0, 0, 1, now.getHour(), now.getMinute(), now.getSecond());
        Assertions.assertThat((Object)Conversions.toLocalTime((Object)date)).isEqualTo((Object)now.withNano(0));
    }

    @Test
    public void shouldThrowExceptionWhenConvertingSqlDateToLocalTime() {
        java.sql.Date date = new java.sql.Date(1L);
        try {
            Conversions.toLocalTime((Object)date);
            Assert.fail((String)"Should not accept java.sql.Date values");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void shouldReturnLocalTimeInstanceWhenConvertingSqlTimeToLocalTime() {
        LocalTime now = LocalTime.now();
        Time time = new Time(now.getHour(), now.getMinute(), now.getSecond());
        Assertions.assertThat((Object)Conversions.toLocalTime((Object)time)).isEqualTo((Object)now.withNano(0));
    }

    @Test
    public void shouldReturnLocalTimeInstanceWhenConvertingLongToLocalTime() {
        LocalTime now = LocalTime.now();
        long nanoOfDay = now.toNanoOfDay();
        Assertions.assertThat((Object)Conversions.toLocalTime((Object)nanoOfDay)).isEqualTo((Object)now);
    }
}

