/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.history;

import io.debezium.relational.Tables;
import io.debezium.relational.ddl.DdlParser;
import io.debezium.relational.ddl.DdlParserSql2003;
import io.debezium.relational.history.DatabaseHistory;
import io.debezium.util.Collect;
import io.debezium.util.Testing;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public abstract class AbstractDatabaseHistoryTest {
    protected DatabaseHistory history;
    protected Map<String, Object> source1;
    protected Map<String, Object> source2;
    protected Tables tables;
    protected Tables t0;
    protected Tables t1;
    protected Tables t2;
    protected Tables t3;
    protected Tables t4;
    protected Tables all;
    protected DdlParser parser;

    @Before
    public void beforeEach() {
        this.parser = new DdlParserSql2003();
        this.tables = new Tables();
        this.t0 = new Tables();
        this.t1 = new Tables();
        this.t2 = new Tables();
        this.t3 = new Tables();
        this.t4 = new Tables();
        this.all = new Tables();
        this.source1 = this.server("abc");
        this.source2 = this.server("xyz");
        this.history = this.createHistory();
    }

    @After
    public void afterEach() {
        if (this.history != null) {
            this.history.stop();
        }
    }

    protected abstract DatabaseHistory createHistory();

    protected Map<String, Object> server(String serverName) {
        return Collect.linkMapOf((Object)"server", (Object)serverName);
    }

    protected Map<String, Object> position(String filename, long position, int entry) {
        return Collect.linkMapOf((Object)"file", (Object)filename, (Object)"position", (Object)position, (Object)"entry", (Object)entry);
    }

    protected void record(long pos, int entry, String ddl, Tables ... update) {
        try {
            this.history.record(this.source1, this.position("a.log", pos, entry), "db", this.tables, ddl);
        }
        catch (Throwable t) {
            Assert.fail((String)t.getMessage());
        }
        for (Tables tables : update) {
            if (tables == null) continue;
            this.parser.setCurrentSchema("db");
            this.parser.parse(ddl, tables);
        }
    }

    protected Tables recover(long pos, int entry) {
        Tables result = new Tables();
        this.history.recover(this.source1, this.position("a.log", pos, entry), result, this.parser);
        return result;
    }

    @Test
    public void shouldRecordChangesAndRecoverToVariousPoints() {
        this.record(1L, 0, "CREATE TABLE foo ( first VARCHAR(22) NOT NULL );", this.all, this.t3, this.t2, this.t1, this.t0);
        this.record(23L, 1, "CREATE TABLE\\nperson ( name VARCHAR(22) NOT NULL );", this.all, this.t3, this.t2, this.t1);
        this.record(30L, 2, "CREATE TABLE address\\n( street VARCHAR(22) NOT NULL );", this.all, this.t3, this.t2);
        this.record(32L, 3, "ALTER TABLE address ADD city VARCHAR(22) NOT NULL;", this.all, this.t3);
        if (Testing.Print.isEnabled()) {
            Testing.print("t0 = " + this.t0);
            Testing.print("t1 = " + this.t1);
            Testing.print("t2 = " + this.t2);
            Testing.print("t3 = " + this.t3);
        }
        Assertions.assertThat((Object)this.recover(1L, 0)).isEqualTo((Object)this.t0);
        Assertions.assertThat((Object)this.recover(1L, 3)).isEqualTo((Object)this.t0);
        Assertions.assertThat((Object)this.recover(10L, 1)).isEqualTo((Object)this.t0);
        Assertions.assertThat((Object)this.recover(22L, 999999)).isEqualTo((Object)this.t0);
        Assertions.assertThat((Object)this.recover(23L, 0)).isEqualTo((Object)this.t0);
        Assertions.assertThat((Object)this.recover(23L, 1)).isEqualTo((Object)this.t1);
        Assertions.assertThat((Object)this.recover(23L, 2)).isEqualTo((Object)this.t1);
        Assertions.assertThat((Object)this.recover(23L, 3)).isEqualTo((Object)this.t1);
        Assertions.assertThat((Object)this.recover(29L, 999)).isEqualTo((Object)this.t1);
        Assertions.assertThat((Object)this.recover(30L, 1)).isEqualTo((Object)this.t1);
        Assertions.assertThat((Object)this.recover(30L, 2)).isEqualTo((Object)this.t2);
        Assertions.assertThat((Object)this.recover(30L, 3)).isEqualTo((Object)this.t2);
        Assertions.assertThat((Object)this.recover(32L, 2)).isEqualTo((Object)this.t2);
        Assertions.assertThat((Object)this.recover(32L, 3)).isEqualTo((Object)this.t3);
        Assertions.assertThat((Object)this.recover(32L, 4)).isEqualTo((Object)this.t3);
        Assertions.assertThat((Object)this.recover(33L, 0)).isEqualTo((Object)this.t3);
        Assertions.assertThat((Object)this.recover(33L, 0)).isEqualTo((Object)this.all);
        Assertions.assertThat((Object)this.recover(1033L, 4)).isEqualTo((Object)this.t3);
        Assertions.assertThat((Object)this.recover(1033L, 4)).isEqualTo((Object)this.t3);
    }
}

