/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.util.Collect;
import io.debezium.util.Strings;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.List;
import java.util.Map;
import org.fest.assertions.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class StringsTest {
    public void compareSeparatedLines(Object ... lines) {
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        PrintStream stream = new PrintStream(content);
        for (Object line : lines) {
            stream.println(line);
        }
        List actualLines = Strings.splitLines((String)content.toString());
        Assert.assertArrayEquals((Object[])lines, (Object[])actualLines.toArray());
    }

    @Test
    public void splitLinesShouldWorkCorrectly() {
        this.compareSeparatedLines("Line 1", "Line 2", "Line 3", "Line 4");
    }

    @Test
    public void setLengthShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)"This is the st", (Object)Strings.setLength((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void setLengthShouldAppendCharacterForStringsThatAreTooShort() {
        Assert.assertEquals((Object)"This      ", (Object)Strings.setLength((String)"This", (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldNotRemoveLeadingWhitespace() {
        Assert.assertEquals((Object)" This     ", (Object)Strings.setLength((String)" This", (int)10, (char)' '));
        Assert.assertEquals((Object)"\tThis     ", (Object)Strings.setLength((String)"\tThis", (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldAppendCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.setLength((String)"", (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldAppendCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.setLength(null, (int)10, (char)' '));
    }

    @Test
    public void setLengthShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)Strings.setLength((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void justifyLeftShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)"This is the st", (Object)Strings.justifyLeft((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void justifyLeftShouldAppendCharacterForStringsThatAreTooShort() {
        Assert.assertEquals((Object)"This      ", (Object)Strings.justifyLeft((String)"This", (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldRemoveLeadingWhitespace() {
        Assert.assertEquals((Object)"This      ", (Object)Strings.justifyLeft((String)" This", (int)10, (char)' '));
        Assert.assertEquals((Object)"This      ", (Object)Strings.justifyLeft((String)"\tThis", (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldAppendCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyLeft((String)"", (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldAppendCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyLeft(null, (int)10, (char)' '));
    }

    @Test
    public void justifyLeftShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)Strings.justifyLeft((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void justifyRightShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)" is the string", (Object)Strings.justifyRight((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void justifyRightShouldPrependCharacterForStringsThatAreTooShort() {
        Assert.assertEquals((Object)"      This", (Object)Strings.justifyRight((String)"This", (int)10, (char)' '));
    }

    @Test
    public void justifyRightShouldPrependCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyRight((String)"", (int)10, (char)' '));
    }

    @Test
    public void justifyRightShouldPrependCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyRight(null, (int)10, (char)' '));
    }

    @Test
    public void justifyRightShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)Strings.justifyRight((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void justifyCenterShouldTruncateStringsThatAreTooLong() {
        Assert.assertEquals((Object)"This is the st", (Object)Strings.justifyCenter((String)"This is the string", (int)14, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependAndAppendSameNumberOfCharacterForStringsThatAreTooShortButOfAnEvenLength() {
        Assert.assertEquals((Object)"   This   ", (Object)Strings.justifyCenter((String)"This", (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependOneMoreCharacterThanAppendingForStringsThatAreTooShortButOfAnOddLength() {
        Assert.assertEquals((Object)"   Thing  ", (Object)Strings.justifyCenter((String)"Thing", (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependCharacterForEmptyStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyCenter((String)"", (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldPrependCharacterForNullStrings() {
        Assert.assertEquals((Object)"          ", (Object)Strings.justifyCenter(null, (int)10, (char)' '));
    }

    @Test
    public void justifyCenterShouldReturnStringsThatAreTheDesiredLength() {
        Assert.assertEquals((Object)"This is the string", (Object)Strings.justifyCenter((String)"This is the string", (int)18, (char)' '));
    }

    @Test
    public void replaceVariablesShouldReplaceVariableThatHaveSameCase() {
        this.assertReplacement("some ${v1} text", this.vars("v1", "abc"), "some abc text");
        this.assertReplacement("some ${v1} text", this.vars("v1", "abc", "V1", "ABC"), "some abc text");
        this.assertReplacement("some ${v1:other} text", this.vars("V1", "ABC"), "some other text");
    }

    @Test
    public void replaceVariablesShouldNotReplaceVariableThatHasNoDefaultAndIsNotFound() {
        this.assertReplacement("some ${varName} text", this.vars("v1", "value1"), "some ${varName} text");
        this.assertReplacement("some${varName}text", this.vars("v1", "value1"), "some${varName}text");
        this.assertReplacement("${varName}", this.vars("v1", "value1"), "${varName}");
    }

    @Test
    public void replaceVariablesShouldReplaceVariablesWithNoDefault() {
        this.assertReplacement("${varName}", this.vars("varName", "replaced"), "replaced");
        this.assertReplacement("some${varName}text", this.vars("varName", "replaced"), "somereplacedtext");
        this.assertReplacement("some ${varName} text", this.vars("varName", "replaced"), "some replaced text");
        this.assertReplacement("some ${var1,var2,var3:other} text", this.vars("var1", "replaced"), "some replaced text");
        this.assertReplacement("some ${var1,var2,var3:other} text", this.vars("v1", "replaced", "var2", "new"), "some new text");
        this.assertReplacement("some ${var1,var2,var3:other} text", this.vars("v1", "replaced", "var3", "new"), "some new text");
    }

    @Test
    public void replaceVariablesShouldReplaceVariablesWithDefaultWhenNoReplacementIsFound() {
        this.assertReplacement("some${varName:other}text", this.vars("v1", "replaced"), "someothertext");
        this.assertReplacement("some ${varName:other} text", this.vars("v1", "replaced"), "some other text");
        this.assertReplacement("some ${var1,var2,var3:other} text", this.vars("var10", "replaced"), "some other text");
        this.assertReplacement("some ${var1,var2,var3:other} text", this.vars("var10", "replaced", "var11", "new"), "some other text");
    }

    @Test
    public void replaceVariablesShouldReplaceMultipleVariables() {
        this.assertReplacement("${v1}${v1}", this.vars("v1", "first", "v2", "second"), "firstfirst");
        this.assertReplacement("${v1}${v2}", this.vars("v1", "first", "v2", "second"), "firstsecond");
        this.assertReplacement("some${v1}text${v2}end", this.vars("v1", "first", "v2", "second"), "somefirsttextsecondend");
        this.assertReplacement("some ${v1} text ${v2} end", this.vars("v1", "first", "v2", "second"), "some first text second end");
        this.assertReplacement("some ${v1:other} text", this.vars("vx1", "replaced"), "some other text");
        this.assertReplacement("some ${v1,v2,v3:other} text ${v1,v2,v3:other}", this.vars("var10", "replaced", "v2", "s"), "some s text s");
        this.assertReplacement("some ${v1,v2:other}${v2,v3:other} text", this.vars("v1", "1", "v2", "2"), "some 12 text");
    }

    protected void assertReplacement(String before, Map<String, String> replacements, String after) {
        String result = Strings.replaceVariables((String)before, replacements::get);
        Assertions.assertThat((String)result).isEqualTo((Object)after);
    }

    protected Map<String, String> vars(String var1, String val1) {
        return Collect.hashMapOf((Object)var1, (Object)val1);
    }

    protected Map<String, String> vars(String var1, String val1, String var2, String val2) {
        return Collect.hashMapOf((Object)var1, (Object)val1, (Object)var2, (Object)val2);
    }
}

