/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.util;

import io.debezium.util.AvroValidator;
import java.util.concurrent.atomic.AtomicInteger;
import org.fest.assertions.Assertions;
import org.junit.Test;

public class AvroValidatorTest {
    @Test
    public void shouldDetermineValidFirstCharacters() {
        String validChars = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ_";
        for (int i = 0; i != validChars.length(); ++i) {
            Assertions.assertThat((boolean)AvroValidator.isValidFullnameFirstCharacter((char)validChars.charAt(i))).isTrue();
        }
    }

    @Test
    public void shouldDetermineValidNonFirstCharacters() {
        String validChars = ".abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789_";
        for (int i = 0; i != validChars.length(); ++i) {
            Assertions.assertThat((boolean)AvroValidator.isValidFullnameNonFirstCharacter((char)validChars.charAt(i))).isTrue();
        }
    }

    @Test
    public void shouldConsiderValidFullnames() {
        this.assertValidFullname("test_server.connector_test.products.Key");
        this.assertValidFullname("t1234.connector_test.products.Key");
    }

    @Test
    public void shouldConsiderInvalidFullnames() {
        this.assertNotValidFullname("test-server.connector_test.products.Key");
    }

    @Test
    public void shouldReportReplacementEveryTime() {
        AtomicInteger counter = new AtomicInteger();
        AtomicInteger conflicts = new AtomicInteger();
        AvroValidator.ReplacementOccurred handler = (original, replacement, conflict) -> {
            if (conflict != null) {
                conflicts.incrementAndGet();
            }
            counter.incrementAndGet();
        };
        AvroValidator validator = AvroValidator.create((AvroValidator.ReplacementOccurred)handler);
        for (int i = 0; i != 20; ++i) {
            validator.validate("some-invalid-fullname$");
        }
        Assertions.assertThat((int)counter.get()).isEqualTo(20);
        Assertions.assertThat((int)conflicts.get()).isEqualTo(0);
    }

    @Test
    public void shouldReportReplacementOnlyOnce() {
        AtomicInteger counter = new AtomicInteger();
        AtomicInteger conflicts = new AtomicInteger();
        AvroValidator.ReplacementOccurred handler = (original, replacement, conflict) -> {
            if (conflict != null) {
                conflicts.incrementAndGet();
            }
            counter.incrementAndGet();
        };
        AvroValidator validator = AvroValidator.create((AvroValidator.ReplacementOccurred)handler.firstTimeOnly());
        for (int i = 0; i != 20; ++i) {
            validator.validate("some-invalid-fullname$");
        }
        Assertions.assertThat((int)counter.get()).isEqualTo(1);
        Assertions.assertThat((int)conflicts.get()).isEqualTo(0);
    }

    @Test
    public void shouldReportConflictReplacement() {
        AtomicInteger counter = new AtomicInteger();
        AtomicInteger conflicts = new AtomicInteger();
        AvroValidator.ReplacementOccurred handler = (original, replacement, conflict) -> {
            if (conflict != null) {
                conflicts.incrementAndGet();
            }
            counter.incrementAndGet();
        };
        AvroValidator validator = AvroValidator.create((AvroValidator.ReplacementOccurred)handler.firstTimeOnly());
        validator.validate("some-invalid-fullname$");
        validator.validate("some-invalid%fullname_");
        Assertions.assertThat((int)counter.get()).isEqualTo(2);
        Assertions.assertThat((int)conflicts.get()).isEqualTo(1);
    }

    protected void assertValidFullname(String fullname) {
        Assertions.assertThat((boolean)AvroValidator.isValidFullname((String)fullname)).isTrue();
    }

    protected void assertNotValidFullname(String fullname) {
        Assertions.assertThat((boolean)AvroValidator.isValidFullname((String)fullname)).isFalse();
    }
}

