/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.time;

import io.debezium.time.Conversions;
import java.time.LocalDateTime;
import org.apache.kafka.connect.data.Schema;
import org.apache.kafka.connect.data.SchemaBuilder;

public class Timestamp {
    public static final String SCHEMA_NAME = "io.debezium.time.Timestamp";

    public static SchemaBuilder builder() {
        return SchemaBuilder.int64().name(SCHEMA_NAME).version(Integer.valueOf(1));
    }

    public static Schema schema() {
        return Timestamp.builder().build();
    }

    public static long toEpochMillis(Object value) {
        LocalDateTime dateTime = Conversions.toLocalDateTime(value);
        long epochNanos = Conversions.toEpochNanos(dateTime);
        return Math.floorDiv(epochNanos, Conversions.NANOSECONDS_PER_MILLISECOND);
    }

    private Timestamp() {
    }
}

