/*
 * Decompiled with CFR 0.152.
 */
package io.debezium.relational.mapping;

import io.debezium.relational.Column;
import io.debezium.relational.TableId;
import io.debezium.relational.ValueConverter;
import io.debezium.relational.mapping.ColumnMapper;
import io.debezium.relational.mapping.ColumnMappers;
import io.debezium.util.Strings;
import org.fest.assertions.Assertions;
import org.junit.Before;
import org.junit.Test;

public class ColumnMappersTest {
    private TableId tableId = new TableId("db", null, "A");
    private Column column;
    private Column column2;
    private Column column3;
    private ColumnMappers mappers;
    private ValueConverter converter;
    private String fullyQualifiedNames;

    @Before
    public void beforeEach() {
        this.column = Column.editor().name("firstName").jdbcType(12).type("VARCHAR").position(1).create();
        this.column2 = Column.editor().name("lastName").jdbcType(12).type("VARCHAR").position(2).create();
        this.column3 = Column.editor().name("otherColumn").jdbcType(12).type("VARCHAR").position(3).create();
        this.fullyQualifiedNames = this.tableId + "." + this.column.name() + "," + this.tableId + "." + this.column3.name() + ",";
    }

    @Test
    public void shouldNotFindMapperForUnmatchedColumn() {
        this.mappers = ColumnMappers.create().truncateStrings(this.fullyQualifiedNames, 10).build();
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column2);
        Assertions.assertThat((Object)this.converter).isNull();
    }

    @Test
    public void shouldTruncateStrings() {
        this.mappers = ColumnMappers.create().truncateStrings(this.fullyQualifiedNames.toUpperCase(), 10).build();
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column);
        Assertions.assertThat((Object)this.converter).isNotNull();
        Assertions.assertThat((String)this.converter.convert((Object)"12345678901234567890").toString()).isEqualTo((Object)"1234567890");
        Assertions.assertThat((int)this.converter.convert((Object)"12345678901234567890").toString().length()).isEqualTo(10);
        Assertions.assertThat((String)this.converter.convert((Object)"12345678901").toString()).isEqualTo((Object)"1234567890");
        Assertions.assertThat((int)this.converter.convert((Object)"12345678901").toString().length()).isEqualTo(10);
        Assertions.assertThat((String)this.converter.convert((Object)"1234567890").toString()).isEqualTo((Object)"1234567890");
        Assertions.assertThat((int)this.converter.convert((Object)"1234567890").toString().length()).isEqualTo(10);
        Assertions.assertThat((String)this.converter.convert((Object)"123456789").toString()).isEqualTo((Object)"123456789");
        Assertions.assertThat((int)this.converter.convert((Object)"123456789").toString().length()).isEqualTo(9);
        Assertions.assertThat((Object)this.converter.convert(null)).isNull();
    }

    @Test
    public void shouldMaskStringsToFixedLength() {
        String maskValue = "**********";
        this.mappers = ColumnMappers.create().maskStrings(this.fullyQualifiedNames, maskValue.length()).build();
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column);
        Assertions.assertThat((Object)this.converter).isNotNull();
        Assertions.assertThat((Object)this.converter.convert((Object)"12345678901234567890")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"12345678901")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"1234567890")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"123456789")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert(null)).isEqualTo((Object)maskValue);
    }

    @Test
    public void shouldMaskStringsToFixedNumberOfSpecifiedCharacters() {
        char maskChar = '=';
        String maskValue = Strings.createString((char)maskChar, (int)10);
        this.mappers = ColumnMappers.create().maskStrings(this.fullyQualifiedNames, maskValue.length(), maskChar).build();
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column);
        Assertions.assertThat((Object)this.converter).isNotNull();
        Assertions.assertThat((Object)this.converter.convert((Object)"12345678901234567890")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"12345678901")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"1234567890")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"123456789")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert(null)).isEqualTo((Object)maskValue);
    }

    @Test
    public void shouldMaskStringsWithSpecificValue() {
        String maskValue = "*-*-*-*-*";
        this.mappers = ColumnMappers.create().maskStrings(this.fullyQualifiedNames, maskValue).build();
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column);
        Assertions.assertThat((Object)this.converter).isNotNull();
        Assertions.assertThat((Object)this.converter.convert((Object)"12345678901234567890")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"12345678901")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"1234567890")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert((Object)"123456789")).isEqualTo((Object)maskValue);
        Assertions.assertThat((Object)this.converter.convert(null)).isEqualTo((Object)maskValue);
    }

    @Test
    public void shouldMapValuesUsingColumnMapperInstance() {
        RepeatingColumnMapper mapper = new RepeatingColumnMapper();
        this.mappers = ColumnMappers.create().map(this.fullyQualifiedNames, (ColumnMapper)mapper).build();
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column);
        Assertions.assertThat((Object)this.converter).isNotNull();
        Assertions.assertThat((Object)this.converter.convert((Object)"1234")).isEqualTo((Object)"12341234");
        Assertions.assertThat((Object)this.converter.convert((Object)"a")).isEqualTo((Object)"aa");
        Assertions.assertThat((Object)this.converter.convert(null)).isNull();
    }

    @Test
    public void shouldMapValuesUsingFunctionByClassName() {
        this.mappers = ColumnMappers.create().map(this.fullyQualifiedNames, RepeatingColumnMapper.class.getName()).build();
        this.converter = this.mappers.mappingConverterFor(this.tableId, this.column);
        Assertions.assertThat((Object)this.converter).isNotNull();
        Assertions.assertThat((Object)this.converter.convert((Object)"1234")).isEqualTo((Object)"12341234");
        Assertions.assertThat((Object)this.converter.convert((Object)"a")).isEqualTo((Object)"aa");
        Assertions.assertThat((Object)this.converter.convert(null)).isNull();
    }

    public static class RepeatingColumnMapper
    implements ColumnMapper {
        public ValueConverter create(Column column) {
            return value -> value == null ? null : value.toString() + value.toString();
        }
    }
}

